/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.node.ConfigurableNode;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.LocalizedInfoNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbRelationshipRoleNode
extends DeploymentDescriptorNode {
    RelationRoleDescriptor descriptor;

    public EjbRelationshipRoleNode() {
        this.registerElementHandler(new XMLElement("description"), LocalizedInfoNode.class);
    }

    public XMLNode getHandlerFor(XMLElement element) {
        if ("relationship-role-source".equals(element.getQName())) {
            HashMap<String, String> dispatchTable = new HashMap<String, String>();
            dispatchTable.put("description", "setRoleSourceDescription");
            ConfigurableNode newNode = new ConfigurableNode(this.getDescriptor(), dispatchTable, element);
            return newNode;
        }
        if ("cmr-field".equals(element.getQName())) {
            HashMap<String, String> dispatchTable = new HashMap<String, String>();
            dispatchTable.put("description", "setCMRFieldDescription");
            ConfigurableNode newNode = new ConfigurableNode(this.getDescriptor(), dispatchTable, element);
            return newNode;
        }
        return super.getHandlerFor(element);
    }

    public boolean handlesElement(XMLElement element) {
        if ("relationship-role-source".equals(element.getQName())) {
            return true;
        }
        if ("cmr-field".equals(element.getQName())) {
            return true;
        }
        return super.handlesElement(element);
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (RelationRoleDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-relationship-role-name", "setName");
        table.put("cmr-field-name", "setCMRField");
        table.put("cmr-field-type", "setCMRFieldType");
        return table;
    }

    public boolean endElement(XMLElement element) {
        if ("cascade-delete".equals(element.getQName())) {
            this.descriptor.setCascadeDelete(true);
        }
        return super.endElement(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElementValue(XMLElement element, String value) {
        if ("multiplicity".equals(element.getQName())) {
            if (value.equals("Many")) {
                this.descriptor.setIsMany(true);
                return;
            } else if (value.equals("One")) {
                this.descriptor.setIsMany(false);
                return;
            } else if (value.equals("many")) {
                this.descriptor.setIsMany(true);
                return;
            } else {
                if (!value.equals("one")) throw new IllegalArgumentException("Error in value of multiplicity element in EJB deployment descriptor XML: the value must be One or Many");
                this.descriptor.setIsMany(false);
            }
            return;
        } else if ("ejb-name".equals(element.getQName())) {
            EjbBundleDescriptor bundleDesc = this.getEjbBundleDescriptor();
            EjbCMPEntityDescriptor desc = (EjbCMPEntityDescriptor)bundleDesc.getEjbByName(value);
            if (desc == null) throw new IllegalArgumentException("Cannot find ejb " + value + " in bundle for relationship " + this.descriptor.getName());
            this.descriptor.setPersistenceDescriptor(desc.getPersistenceDescriptor());
            return;
        } else {
            super.setElementValue(element, value);
        }
    }

    private EjbBundleDescriptor getEjbBundleDescriptor() {
        XMLNode parent = this.getParentNode();
        Object parentDesc = parent.getDescriptor();
        while (parent != null && !(parentDesc instanceof EjbBundleDescriptor)) {
            if ((parent = parent.getParentNode()) == null) continue;
            parentDesc = parent.getDescriptor();
        }
        if (parent != null) {
            return (EjbBundleDescriptor)parentDesc;
        }
        throw new IllegalArgumentException("Cannot find bundle descriptor");
    }

    public Node writeDescriptor(Node parent, String nodeName, RelationRoleDescriptor descriptor) {
        Node roleNode = super.writeDescriptor(parent, nodeName, descriptor);
        LocalizedInfoNode localizedNode = new LocalizedInfoNode();
        localizedNode.writeLocalizedMap(roleNode, "description", descriptor.getLocalizedDescriptions());
        if (descriptor.getRelationRoleName() != null) {
            EjbRelationshipRoleNode.appendTextChild(roleNode, "ejb-relationship-role-name", descriptor.getRelationRoleName());
        }
        if (descriptor.getIsMany()) {
            EjbRelationshipRoleNode.appendTextChild(roleNode, "multiplicity", "Many");
        } else {
            EjbRelationshipRoleNode.appendTextChild(roleNode, "multiplicity", "One");
        }
        if (descriptor.getCascadeDelete()) {
            EjbRelationshipRoleNode.appendChild(roleNode, "cascade-delete");
        }
        Element roleSourceNode = EjbRelationshipRoleNode.appendChild(roleNode, "relationship-role-source");
        EjbRelationshipRoleNode.appendTextChild((Node)roleSourceNode, "description", descriptor.getRoleSourceDescription());
        EjbRelationshipRoleNode.appendTextChild((Node)roleSourceNode, "ejb-name", descriptor.getOwner().getName());
        if (descriptor.getCMRField() != null) {
            Element cmrFieldNode = EjbRelationshipRoleNode.appendChild(roleNode, "cmr-field");
            EjbRelationshipRoleNode.appendTextChild((Node)cmrFieldNode, "description", descriptor.getCMRFieldDescription());
            EjbRelationshipRoleNode.appendTextChild((Node)cmrFieldNode, "cmr-field-name", descriptor.getCMRField());
            EjbRelationshipRoleNode.appendTextChild((Node)cmrFieldNode, "cmr-field-type", descriptor.getCMRFieldType());
        }
        return roleNode;
    }
}

