/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.AppListenerDescriptorImpl;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ErrorPageDescriptor;
import com.sun.enterprise.deployment.JspConfigDescriptor;
import com.sun.enterprise.deployment.LocaleEncodingMappingListDescriptor;
import com.sun.enterprise.deployment.LoginConfigurationImpl;
import com.sun.enterprise.deployment.MimeMappingDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.SessionConfigDescriptor;
import com.sun.enterprise.deployment.TagLibConfigurationDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DataSourceDefinitionNode;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.ServiceReferenceNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.web.ErrorPageNode;
import com.sun.enterprise.deployment.node.web.FilterMappingNode;
import com.sun.enterprise.deployment.node.web.FilterNode;
import com.sun.enterprise.deployment.node.web.InitParamNode;
import com.sun.enterprise.deployment.node.web.JspConfigNode;
import com.sun.enterprise.deployment.node.web.ListenerNode;
import com.sun.enterprise.deployment.node.web.LocaleEncodingMappingListNode;
import com.sun.enterprise.deployment.node.web.LoginConfigNode;
import com.sun.enterprise.deployment.node.web.MimeMappingNode;
import com.sun.enterprise.deployment.node.web.SecurityConstraintNode;
import com.sun.enterprise.deployment.node.web.ServletMappingNode;
import com.sun.enterprise.deployment.node.web.ServletNode;
import com.sun.enterprise.deployment.node.web.SessionConfigNode;
import com.sun.enterprise.deployment.node.web.TagLibNode;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.MimeMapping;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebCommonNode<T extends WebBundleDescriptor>
extends BundleNode<T> {
    public static final String SPEC_VERSION = "3.0";
    protected T descriptor;
    private Map servletMappings;

    protected WebCommonNode() {
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class);
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        this.registerElementHandler(new XMLElement("service-ref"), ServiceReferenceNode.class, "addServiceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addJmsDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class, "addMessageDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-context-ref"), EntityManagerReferenceNode.class, "addEntityManagerReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceNode.class, "addEntityManagerFactoryReferenceDescriptor");
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addRole");
        this.registerElementHandler(new XMLElement("servlet"), ServletNode.class);
        this.registerElementHandler(new XMLElement("servlet-mapping"), ServletMappingNode.class);
        this.registerElementHandler(new XMLElement("session-config"), SessionConfigNode.class, "setSessionConfig");
        this.registerElementHandler(new XMLElement("mime-mapping"), MimeMappingNode.class, "addMimeMapping");
        this.registerElementHandler(new XMLElement("context-param"), InitParamNode.class, "addContextParameter");
        this.registerElementHandler(new XMLElement("security-constraint"), SecurityConstraintNode.class, "addSecurityConstraint");
        this.registerElementHandler(new XMLElement("filter"), FilterNode.class, "addServletFilter");
        this.registerElementHandler(new XMLElement("filter-mapping"), FilterMappingNode.class, "addServletFilterMapping");
        this.registerElementHandler(new XMLElement("listener"), ListenerNode.class, "addAppListenerDescriptor");
        this.registerElementHandler(new XMLElement("error-page"), ErrorPageNode.class, "addErrorPageDescriptor");
        this.registerElementHandler(new XMLElement("login-config"), LoginConfigNode.class);
        this.registerElementHandler(new XMLElement("taglib"), TagLibNode.class);
        this.registerElementHandler(new XMLElement("jsp-config"), JspConfigNode.class);
        this.registerElementHandler(new XMLElement("locale-encoding-mapping-list"), LocaleEncodingMappingListNode.class, "addLocaleEncodingMappingListDescriptor");
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
        this.registerElementHandler(new XMLElement("post-construct"), LifecycleCallbackNode.class, "addPostConstructDescriptor");
        this.registerElementHandler(new XMLElement("pre-destroy"), LifecycleCallbackNode.class, "addPreDestroyDescriptor");
        this.registerElementHandler(new XMLElement("data-source"), DataSourceDefinitionNode.class, "addDataSourceDefinitionDescriptor");
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbReference) {
            ((WebBundleDescriptor)this.descriptor).addEjbReferenceDescriptor((EjbReference)newDescriptor);
        } else if (newDescriptor instanceof EnvironmentProperty) {
            DOLUtils.getDefaultLogger().fine("Adding env entry" + newDescriptor);
            ((WebBundleDescriptor)this.descriptor).addEnvironmentProperty((EnvironmentProperty)newDescriptor);
        } else if (newDescriptor instanceof WebComponentDescriptor) {
            DOLUtils.getDefaultLogger().fine("Adding web component" + newDescriptor);
            ((WebBundleDescriptor)this.descriptor).addWebComponentDescriptor((WebComponentDescriptor)newDescriptor);
        } else if (newDescriptor instanceof TagLibConfigurationDescriptor) {
            DOLUtils.getDefaultLogger().fine("Adding taglib component " + newDescriptor);
            if (((WebBundleDescriptor)this.descriptor).getJspConfigDescriptor() == null) {
                ((WebBundleDescriptor)this.descriptor).setJspConfigDescriptor(new JspConfigDescriptor());
            }
            ((WebBundleDescriptor)this.descriptor).getJspConfigDescriptor().addTagLib((TagLibConfigurationDescriptor)newDescriptor);
        } else if (newDescriptor instanceof JspConfigDescriptor) {
            DOLUtils.getDefaultLogger().fine("Adding JSP Config Descriptor" + newDescriptor);
            if (((WebBundleDescriptor)this.descriptor).getJspConfigDescriptor() != null) {
                throw new RuntimeException("Has more than one jsp-config element!");
            }
            ((WebBundleDescriptor)this.descriptor).setJspConfigDescriptor((JspConfigDescriptor)newDescriptor);
        } else if (newDescriptor instanceof LoginConfiguration) {
            DOLUtils.getDefaultLogger().fine("Adding Login Config Descriptor" + newDescriptor);
            if (((WebBundleDescriptor)this.descriptor).getLoginConfiguration() != null) {
                throw new RuntimeException("Has more than one login-config element!");
            }
            ((WebBundleDescriptor)this.descriptor).setLoginConfiguration((LoginConfiguration)newDescriptor);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("welcome-file".equals(element.getQName())) {
            ((WebBundleDescriptor)this.descriptor).addWelcomeFile(value);
        } else if ("name".equals(element.getQName())) {
            ((RootDeploymentDescriptor)this.descriptor).setName(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    void addServletMapping(String servletName, String urlPattern) {
        if (this.servletMappings == null) {
            this.servletMappings = new HashMap();
        }
        if (this.servletMappings.containsKey(servletName)) {
            ((Vector)this.servletMappings.get(servletName)).add(urlPattern);
        } else {
            Vector<String> mappings = new Vector<String>();
            mappings.add(urlPattern);
            this.servletMappings.put(servletName, mappings);
        }
    }

    @Override
    public boolean endElement(XMLElement element) {
        if ("distributable".equals(element.getQName())) {
            ((WebBundleDescriptor)this.descriptor).setDistributable(true);
            return false;
        }
        boolean allDone = super.endElement(element);
        if (allDone && this.servletMappings != null) {
            for (String servletName : this.servletMappings.keySet()) {
                Vector mappings = (Vector)this.servletMappings.get(servletName);
                WebComponentDescriptor servlet = ((WebBundleDescriptor)this.descriptor).getWebComponentByCanonicalName(servletName);
                if (servlet != null) {
                    Iterator mapping = mappings.iterator();
                    while (mapping.hasNext()) {
                        servlet.addUrlPattern((String)mapping.next());
                    }
                    continue;
                }
                throw new RuntimeException("There is no web component by the name of " + servletName + " here.");
            }
        }
        return allDone;
    }

    @Override
    public Node writeDescriptor(Node parent, T webBundleDesc) {
        Enumeration<SecurityRoleDescriptor> roles;
        LoginConfigurationImpl lci;
        Enumeration<SecurityConstraint> securityConstraints;
        JspConfigDescriptor jspConf;
        Enumeration<ErrorPageDescriptor> errorPages;
        Set<WebComponentDescriptor> servlets;
        Node jarNode = super.writeDescriptor(parent, webBundleDesc);
        if (((WebBundleDescriptor)webBundleDesc).isDistributable().booleanValue()) {
            WebCommonNode.appendChild(jarNode, "distributable");
        }
        WebCommonNode.addInitParam(jarNode, "context-param", ((WebBundleDescriptor)webBundleDesc).getContextParametersSet());
        FilterNode filterNode = new FilterNode();
        Enumeration<ServletFilter> filters = ((WebBundleDescriptor)webBundleDesc).getServletFilters().elements();
        while (filters.hasMoreElements()) {
            filterNode.writeDescriptor(jarNode, "filter", (ServletFilterDescriptor)filters.nextElement());
        }
        FilterMappingNode filterMappingNode = new FilterMappingNode();
        Enumeration<ServletFilterMapping> mappings = ((WebBundleDescriptor)webBundleDesc).getServletFilterMappings().elements();
        while (mappings.hasMoreElements()) {
            filterMappingNode.writeDescriptor(jarNode, "filter-mapping", (ServletFilterMappingDescriptor)mappings.nextElement());
        }
        Vector<AppListenerDescriptor> appListeners = ((WebBundleDescriptor)webBundleDesc).getAppListenerDescriptors();
        if (appListeners != null && !appListeners.isEmpty()) {
            ListenerNode listenerNode = new ListenerNode();
            Enumeration<AppListenerDescriptor> e = appListeners.elements();
            while (e.hasMoreElements()) {
                listenerNode.writeDescriptor(jarNode, "listener", (AppListenerDescriptorImpl)e.nextElement());
            }
        }
        if ((servlets = ((WebBundleDescriptor)webBundleDesc).getWebComponentDescriptors()) != null && !servlets.isEmpty()) {
            ServletNode servletNode = new ServletNode();
            for (WebComponentDescriptor aServlet : servlets) {
                servletNode.writeDescriptor(jarNode, aServlet);
            }
        }
        if (servlets != null && !servlets.isEmpty()) {
            for (WebComponentDescriptor aServlet : servlets) {
                for (String pattern : aServlet.getUrlPatternsSet()) {
                    Element mappingNode = WebCommonNode.appendChild(jarNode, "servlet-mapping");
                    WebCommonNode.appendTextChild((Node)mappingNode, "servlet-name", aServlet.getCanonicalName());
                    if (((RootDeploymentDescriptor)webBundleDesc).getSpecVersion().equals("2.2") && !pattern.startsWith("/") && !pattern.startsWith("*.")) {
                        pattern = "/" + pattern;
                    }
                    WebCommonNode.appendTextChild((Node)mappingNode, "url-pattern", pattern);
                }
            }
        }
        MimeMappingNode mimeNode = new MimeMappingNode();
        Enumeration<MimeMapping> e = ((WebBundleDescriptor)webBundleDesc).getMimeMappings();
        while (e.hasMoreElements()) {
            MimeMappingDescriptor mimeMapping = (MimeMappingDescriptor)e.nextElement();
            mimeNode.writeDescriptor(jarNode, "mime-mapping", mimeMapping);
        }
        Enumeration<String> welcomeFiles = ((WebBundleDescriptor)webBundleDesc).getWelcomeFiles();
        if (welcomeFiles.hasMoreElements()) {
            Element welcomeList = WebCommonNode.appendChild(jarNode, "welcome-file-list");
            while (welcomeFiles.hasMoreElements()) {
                WebCommonNode.appendTextChild((Node)welcomeList, "welcome-file", welcomeFiles.nextElement());
            }
        }
        if ((errorPages = ((WebBundleDescriptor)webBundleDesc).getErrorPageDescriptors()).hasMoreElements()) {
            ErrorPageNode errorPageNode = new ErrorPageNode();
            while (errorPages.hasMoreElements()) {
                errorPageNode.writeDescriptor(jarNode, "error-page", errorPages.nextElement());
            }
        }
        if ((jspConf = ((WebBundleDescriptor)webBundleDesc).getJspConfigDescriptor()) != null) {
            JspConfigNode ln = new JspConfigNode();
            ln.writeDescriptor(jarNode, "jsp-config", jspConf);
        }
        if ((securityConstraints = ((WebBundleDescriptor)webBundleDesc).getSecurityConstraints()).hasMoreElements()) {
            SecurityConstraintNode scNode = new SecurityConstraintNode();
            while (securityConstraints.hasMoreElements()) {
                SecurityConstraintImpl sc = (SecurityConstraintImpl)securityConstraints.nextElement();
                scNode.writeDescriptor(jarNode, "security-constraint", sc);
            }
        }
        if ((lci = (LoginConfigurationImpl)((WebBundleDescriptor)webBundleDesc).getLoginConfiguration()) != null) {
            LoginConfigNode lcn = new LoginConfigNode();
            lcn.writeDescriptor(jarNode, "login-config", lci);
        }
        if ((roles = ((WebBundleDescriptor)webBundleDesc).getSecurityRoles()).hasMoreElements()) {
            SecurityRoleNode srNode = new SecurityRoleNode();
            while (roles.hasMoreElements()) {
                SecurityRoleDescriptor role = roles.nextElement();
                srNode.writeDescriptor(jarNode, "security-role", role);
            }
        }
        this.writeEnvEntryDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getJmsDestinationReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writePostConstructDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getPostConstructDescriptors().iterator());
        this.writePreDestroyDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getPreDestroyDescriptors().iterator());
        this.writeDataSourceDefinitionDescriptors(jarNode, ((WebBundleDescriptor)webBundleDesc).getDataSourceDefinitionDescriptors().iterator());
        this.writeMessageDestinations(jarNode, ((BundleDescriptor)webBundleDesc).getMessageDestinations().iterator());
        LocaleEncodingMappingListDescriptor lemDesc = ((WebBundleDescriptor)webBundleDesc).getLocaleEncodingMappingListDescriptor();
        if (lemDesc != null) {
            LocaleEncodingMappingListNode ln = new LocaleEncodingMappingListNode();
            ln.writeDescriptor(jarNode, "locale-encoding-mapping-list", lemDesc);
        }
        if (((WebBundleDescriptor)webBundleDesc).getSessionConfig() != null) {
            SessionConfigNode scNode = new SessionConfigNode();
            scNode.writeDescriptor(jarNode, "session-config", (SessionConfigDescriptor)((WebBundleDescriptor)webBundleDesc).getSessionConfig());
        }
        return jarNode;
    }

    static void addInitParam(Node parentNode, String nodeName, Set initParams) {
        if (!initParams.isEmpty()) {
            InitParamNode initParamNode = new InitParamNode();
            for (EnvironmentProperty ep : initParams) {
                initParamNode.writeDescriptor(parentNode, nodeName, ep);
            }
        }
    }

    static void addInitParam(Node parentNode, String nodeName, Enumeration initParams) {
        InitParamNode initParamNode = new InitParamNode();
        while (initParams.hasMoreElements()) {
            EnvironmentProperty ep = (EnvironmentProperty)initParams.nextElement();
            initParamNode.writeDescriptor(parentNode, nodeName, ep);
        }
    }

    @Override
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

