/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-password-aliases")
@Scoped(value=PerLookup.class)
@I18n(value="list.password.alias")
public class ListPasswordAlias
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListPasswordAlias.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PasswordAdapter pa;
            Enumeration e;
            String mp = System.getProperty("javax.net.ssl.trustStorePassword");
            if (mp == null) {
                mp = System.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (mp == null) {
                mp = IdentityManager.getMasterPassword();
            }
            if (mp == null) {
                mp = "changeit";
            }
            if (!(e = (pa = new PasswordAdapter(mp.toCharArray())).getAliases()).hasMoreElements()) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                report.setMessage(localStrings.getLocalString("list.password.alias.nothingtolist", "Nothing to list"));
            }
            while (e.hasMoreElements()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage((String)e.nextElement());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report.setMessage(localStrings.getLocalString("list.password.alias.fail", "Listing of Password Alias failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
            return;
        }
    }
}

