/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.AMXStartupServiceMBean;
import org.glassfish.admin.mbeanserver.JMXStartupService;
import org.glassfish.api.amx.BootAMXMBean;
import org.jvnet.hk2.component.Habitat;

final class BootAMX
implements BootAMXMBean {
    private final MBeanServer mMBeanServer;
    private final ObjectName mObjectName;
    private final Habitat mHabitat;
    private ObjectName mDomainRootObjectName;

    private static void debug(String s) {
        System.out.println(s);
    }

    private BootAMX(Habitat habitat, MBeanServer mbeanServer) {
        this.mHabitat = habitat;
        this.mMBeanServer = mbeanServer;
        this.mObjectName = BootAMXMBean.OBJECT_NAME;
        this.mDomainRootObjectName = null;
        if (this.mMBeanServer.isRegistered(this.mObjectName)) {
            throw new IllegalStateException();
        }
    }

    public static synchronized BootAMX create(Habitat habitat, MBeanServer server) {
        BootAMX booter = new BootAMX(habitat, server);
        ObjectName objectName = OBJECT_NAME;
        try {
            StandardMBean mbean = new StandardMBean(booter, BootAMXMBean.class);
            if (!server.registerMBean(mbean, objectName).getObjectName().equals(objectName)) {
                throw new IllegalStateException();
            }
        }
        catch (JMException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        return booter;
    }

    AMXStartupServiceMBean getLoader() {
        try {
            return (AMXStartupServiceMBean)this.mHabitat.getByContract(AMXStartupServiceMBean.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public synchronized ObjectName bootAMX() {
        if (this.mDomainRootObjectName == null) {
            AMXStartupServiceMBean loader = this.getLoader();
            ObjectName startupON = AMXStartupServiceMBean.OBJECT_NAME;
            if (!this.mMBeanServer.isRegistered(startupON)) {
                BootAMX.debug("Booter.bootAMX(): AMX MBean not yet available: " + startupON);
                throw new IllegalStateException("AMX MBean not yet available: " + startupON);
            }
            try {
                this.mDomainRootObjectName = (ObjectName)this.mMBeanServer.invoke(startupON, "loadAMXMBeans", null, null);
            }
            catch (JMException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.mDomainRootObjectName;
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        return JMXStartupService.getJMXServiceURLs(this.mMBeanServer);
    }
}

