/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.BootAMX;
import org.glassfish.admin.mbeanserver.BootAMXListener;
import org.glassfish.admin.mbeanserver.ConnectorStarter;
import org.glassfish.admin.mbeanserver.JMXMPConnectorStarter;
import org.glassfish.admin.mbeanserver.RMIConnectorStarter;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.AdminAccessController;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Async
public final class JMXStartupService
implements Startup,
PostConstruct {
    @Inject
    private MBeanServer mMBeanServer = ManagementFactory.getPlatformMBeanServer();
    @Inject
    private AdminService mAdminService;
    @Inject
    private Habitat mHabitat;
    @Inject
    Events mEvents;
    @Inject
    static volatile AdminAccessController sAuthenticator;
    private volatile BootAMX mBootAMX;
    private volatile JMXConnectorsStarterThread mConnectorsStarterThread;
    public static final String JMX_CONNECTOR_SERVER_PREFIX = "jmxremote:type=jmx-connector-server";

    private static void debug(String s) {
        System.out.println("### " + s);
    }

    public void postConstruct() {
        this.mBootAMX = BootAMX.create(this.mHabitat, this.mMBeanServer);
        List configuredConnectors = this.mAdminService.getJmxConnector();
        this.mConnectorsStarterThread = new JMXConnectorsStarterThread(this.mMBeanServer, configuredConnectors, this.mBootAMX);
        this.mConnectorsStarterThread.start();
        this.mEvents.register((EventListener)new ShutdownListener());
    }

    private void shutdown() {
        Util.getLogger().info("JMXStartupService: shutting down AMX and JMX");
        this.mConnectorsStarterThread.shutdown();
    }

    public static final Set<ObjectName> getJMXConnectorServers(MBeanServer server) {
        try {
            ObjectName queryPattern = new ObjectName("jmxremote:type=jmx-connector-server,*");
            return server.queryNames(queryPattern, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JMXServiceURL[] getJMXServiceURLs(MBeanServer server) {
        Set<ObjectName> objectNames = JMXStartupService.getJMXConnectorServers(server);
        ArrayList<JMXServiceURL> urls = new ArrayList<JMXServiceURL>();
        for (ObjectName objectName : objectNames) {
            try {
                urls.add((JMXServiceURL)server.getAttribute(objectName, "Address"));
            }
            catch (JMException e) {
                e.printStackTrace();
            }
        }
        return urls.toArray(new JMXServiceURL[urls.size()]);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JMXConnectorsStarterThread
    extends Thread {
        private final List<JmxConnector> mConfiguredConnectors;
        private final MBeanServer mMBeanServer;
        private final BootAMX mAMXBooterNew;
        private final List<JMXConnectorServer> mConnectorServers = new ArrayList<JMXConnectorServer>();

        public JMXConnectorsStarterThread(MBeanServer mbs, List<JmxConnector> configuredConnectors, BootAMX amxBooter) {
            this.mMBeanServer = mbs;
            this.mConfiguredConnectors = configuredConnectors;
            this.mAMXBooterNew = amxBooter;
        }

        void shutdown() {
            for (JMXConnectorServer connector : this.mConnectorServers) {
                try {
                    JMXServiceURL address = connector.getAddress();
                    connector.stop();
                    Util.getLogger().info("JMXStartupService: Stopped JMXConnectorServer: " + address);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mConnectorServers.clear();
        }

        private static String toString(JmxConnector c) {
            return "JmxConnector config: { name = " + c.getName() + ", Protocol = " + c.getProtocol() + ", Address = " + c.getAddress() + ", Port = " + c.getPort() + ", AcceptAll = " + c.getAcceptAll() + ", AuthRealmName = " + c.getAuthRealmName() + ", SecurityEnabled = " + c.getSecurityEnabled() + "}";
        }

        private JMXConnectorServer startConnector(JmxConnector connConfig) throws IOException {
            ConnectorStarter starter;
            Util.getLogger().fine("Starting JMXConnector: " + JMXConnectorsStarterThread.toString(connConfig));
            String protocol = connConfig.getProtocol();
            String address = connConfig.getAddress();
            int port = Integer.parseInt(connConfig.getPort());
            String authRealmName = connConfig.getAuthRealmName();
            boolean securityEnabled = Boolean.parseBoolean(connConfig.getSecurityEnabled());
            JMXConnectorServer server = null;
            BootAMXListener listener = new BootAMXListener(server, this.mAMXBooterNew);
            if (protocol.equals("rmi_jrmp")) {
                starter = new RMIConnectorStarter(this.mMBeanServer, address, port, protocol, authRealmName, securityEnabled, sAuthenticator, listener);
                server = ((RMIConnectorStarter)starter).start();
            } else if (protocol.equals("jmxmp")) {
                starter = new JMXMPConnectorStarter(this.mMBeanServer, address, port, authRealmName, securityEnabled, sAuthenticator, listener);
                server = ((JMXMPConnectorStarter)starter).start();
            } else {
                throw new IllegalArgumentException("JMXStartupService.startConnector(): Unknown protocol: " + protocol);
            }
            JMXServiceURL url = server.getAddress();
            Util.getLogger().info("JMXStartupService: Started JMXConnector, JMXService URL = " + url);
            try {
                ObjectName objectName = new ObjectName("jmxremote:type=jmx-connector-server,protocol=" + protocol + ",name=" + connConfig.getName());
                objectName = this.mMBeanServer.registerMBean(server, objectName).getObjectName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return server;
        }

        @Override
        public void run() {
            Util.getLogger().info("JMXStartupService: JMX authenticator is " + sAuthenticator);
            for (JmxConnector c : this.mConfiguredConnectors) {
                if (!Boolean.parseBoolean(c.getEnabled())) {
                    Util.getLogger().info("JMXStartupService: JMXConnector " + c.getName() + " is disabled, skipping.");
                    continue;
                }
                try {
                    JMXConnectorServer server = this.startConnector(c);
                    this.mConnectorServers.add(server);
                }
                catch (Throwable t) {
                    Util.getLogger().warning("Cannot start JMX connector: " + JMXConnectorsStarterThread.toString(c) + ": " + t);
                }
            }
        }
    }

    private final class ShutdownListener
    implements EventListener {
        private ShutdownListener() {
        }

        public void event(EventListener.Event event) {
            if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                JMXStartupService.this.shutdown();
            }
        }
    }
}

