/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.DataSourcePropertyDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;

public class DataSourceDefinitionDescriptor
extends Descriptor
implements Serializable {
    private String name;
    private String description;
    private String className;
    private int portNumber = -1;
    private String databaseName;
    private String serverName = "localhost";
    private String url;
    private String user;
    private String password;
    private long loginTimeout = 0L;
    private boolean transactional = true;
    private int isolationLevel = -1;
    private int initialPoolSize = -1;
    private int maxPoolSize = -1;
    private int minPoolSize = -1;
    private long maxIdleTime = -1L;
    private int maxStatements = -1;
    private Properties properties = new Properties();
    private boolean transactionSet = false;
    private boolean loginTimeoutSet = false;
    private boolean serverNameSet = false;
    private String resourceId;
    private static final String JAVA_URL = "java:";
    private static final String JAVA_COMP_URL = "java:comp/";
    private static final String TRANSACTION_NONE = "TRANSACTION_NONE";
    private static final String TRANSACTION_READ_UNCOMMITTED = "TRANSACTION_READ_UNCOMMITTED";
    private static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    private static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    private static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String Url) {
        this.url = Url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTransactionSet(boolean value) {
        this.transactionSet = value;
    }

    public boolean isTransactionSet() {
        return this.transactionSet;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
        this.setServerNameSet(true);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(String loginTimeout) {
        try {
            this.loginTimeout = Long.parseLong(loginTimeout);
            this.setLoginTimeoutSet(true);
        }
        catch (NumberFormatException nfe) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "invalid loginTimeout value [ " + loginTimeout + " ]," + " required long");
        }
    }

    private void setLoginTimeoutSet(boolean b) {
        this.loginTimeoutSet = b;
    }

    public boolean isLoginTimeoutSet() {
        return this.loginTimeoutSet;
    }

    public boolean isServerNameSet() {
        return this.serverNameSet;
    }

    private void setServerNameSet(boolean b) {
        this.serverNameSet = b;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
        this.setTransactionSet(true);
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(String isolationLevelString) {
        if (!this.isIntegerIsolationLevelSet(isolationLevelString)) {
            if (isolationLevelString.equals(TRANSACTION_READ_COMMITTED)) {
                this.isolationLevel = 2;
            } else if (isolationLevelString.equals(TRANSACTION_READ_UNCOMMITTED)) {
                this.isolationLevel = 1;
            } else if (isolationLevelString.equals(TRANSACTION_REPEATABLE_READ)) {
                this.isolationLevel = 4;
            } else if (isolationLevelString.equals(TRANSACTION_SERIALIZABLE)) {
                this.isolationLevel = 8;
            } else {
                throw new IllegalStateException("Isolation level [ " + isolationLevelString + " ] not of of standard isolation levels.");
            }
        }
    }

    public boolean isIntegerIsolationLevelSet(String isolationLevelString) {
        int isolationLevel;
        try {
            isolationLevel = Integer.parseInt(isolationLevelString);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (isolationLevel == -1) {
            return true;
        }
        switch (isolationLevel) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.isolationLevel = isolationLevel;
                break;
            }
            default: {
                throw new IllegalStateException("Isolation level [ " + isolationLevel + " ] not of of standard isolation levels.");
            }
        }
        return true;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(String maxIdleTime) {
        try {
            this.maxIdleTime = Long.parseLong(maxIdleTime);
        }
        catch (NumberFormatException nfe) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "invalid maxIdleTime value [ " + maxIdleTime + " ]," + " required long");
        }
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean equals(Object object) {
        if (object instanceof DataSourceDefinitionDescriptor) {
            DataSourceDefinitionDescriptor reference = (DataSourceDefinitionDescriptor)object;
            return DataSourceDefinitionDescriptor.getJavaName(this.getName()).equals(DataSourceDefinitionDescriptor.getJavaName(reference.getName()));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getName().hashCode();
        return result;
    }

    public static String getJavaName(String thisName) {
        if (!thisName.contains(JAVA_URL)) {
            thisName = JAVA_COMP_URL + thisName;
        }
        return thisName;
    }

    public void addDataSourcePropertyDescriptor(DataSourcePropertyDescriptor propertyDescriptor) {
        this.properties.put(propertyDescriptor.getName(), propertyDescriptor.getValue());
    }
}

