/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModulesRegistry;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import org.glassfish.admin.monitor.StatsProviderManagerDelegateImpl;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.api.amx.MBeanListener;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.StatsProviderManagerDelegate;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.internal.api.Init;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
public class MonitoringBootstrap
implements Init,
PostConstruct,
EventListener,
ModuleLifecycleListener,
ConfigListener {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private Domain domain;
    @Inject
    ModulesRegistry registry;
    @Inject
    protected ProbeProviderFactory probeProviderFactory;
    @Inject
    protected ProbeClientMediator pcm;
    @Inject
    Events events;
    @Inject(optional=true)
    ModuleMonitoringLevels config = null;
    @Inject(optional=true)
    MonitoringService monitoringService = null;
    @Inject
    private ProbeRegistry probeRegistry;
    Map<String, Module> map = Collections.synchronizedMap(new WeakHashMap());
    private static final String INSTALL_ROOT_URI_PROPERTY_NAME = "com.sun.aas.installRootURI";
    private final boolean debug = false;
    private final String PROBE_PROVIDER_CLASS_NAMES = "probe-provider-class-names";
    private final String PROBE_PROVIDER_XML_FILE_NAMES = "probe-provider-xml-file-names";
    private final String DELIMITER = ",";
    private StatsProviderManagerDelegateImpl spmd;
    private boolean ddebug = false;

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.registry.register((ModuleLifecycleListener)this);
        for (Module m : this.registry.getModules()) {
            this.printd(" In startup, calling moduleStarted");
            this.moduleStarted(m);
        }
        this.setStatsProviderManagerDelegate();
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.mprint("***************************************");
            this.mprint("**** SERVER_READY event received *****");
            this.mprint("***************************************");
            this.discoverXMLProviders();
        }
    }

    public void setStatsProviderManagerDelegate() {
        this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.monitoringService);
        StatsProviderManager.setStatsProviderManagerDelegate((StatsProviderManagerDelegate)this.spmd);
        this.mprint(" StatsProviderManagerDelegate is assigned ********************");
        MBeanListener.listenForDomainRoot((MBeanServerConnection)ManagementFactory.getPlatformMBeanServer(), (MBeanListener.Callback)this.spmd);
    }

    public void moduleResolved(Module module) {
        this.printd(" In module resolved, but not registering, module = " + module.getName());
    }

    public synchronized void moduleStarted(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
        this.printd(" moduleStarted : " + str);
        if (!this.map.containsKey(str)) {
            this.map.put(str, module);
            this.addProvider(module);
        }
    }

    public synchronized void moduleStopped(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
        if (this.map.containsKey(str)) {
            this.map.remove(str);
            this.removeProvider(module);
        }
    }

    private void addProvider(Module module) {
        String mname = module.getName();
        ClassLoader mcl = module.getClassLoader();
        ModuleDefinition md = module.getModuleDefinition();
        Manifest mf = null;
        if (md != null) {
            mf = md.getManifest();
        }
        if (mf != null) {
            Attributes attrs = mf.getMainAttributes();
            String cnames = null;
            String xnames = null;
            if (attrs != null) {
                StringTokenizer st;
                cnames = attrs.getValue("probe-provider-class-names");
                if (cnames != null) {
                    this.printd("**************probe providers = " + cnames);
                }
                if (cnames != null) {
                    st = new StringTokenizer(cnames, ",");
                    while (st.hasMoreTokens()) {
                        try {
                            this.processProbeProviderClass(mcl.loadClass(st.nextToken()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if ((xnames = attrs.getValue("probe-provider-xml-file-names")) != null) {
                    this.mprint("xnames = " + xnames);
                    st = new StringTokenizer(xnames, ",");
                    while (st.hasMoreTokens()) {
                        this.processProbeProviderXML(mcl, st.nextToken(), true);
                    }
                }
            }
        }
    }

    private void discoverXMLProviders() {
        try {
            URI xmlProviderDirStr = new URI(System.getProperty(INSTALL_ROOT_URI_PROPERTY_NAME) + "/" + "lib" + "/" + "monitor");
            this.printd("ProviderXML's Dir = " + xmlProviderDirStr.getPath());
            File xmlProviderDir = new File(xmlProviderDirStr.getPath());
            this.printd("ProviderXML's Dir exists = " + xmlProviderDir.exists());
            this.printd("ProviderXML's Dir path - " + xmlProviderDir.getAbsolutePath());
            this.loadXMLProviders(xmlProviderDir);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadXMLProviders(File xmlProvidersDir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        File[] files = xmlProvidersDir.listFiles(filter);
        if (files == null) {
            return;
        }
        HashMap<String, File> providerMap = new HashMap<String, File>();
        for (File file : files) {
            this.printd("Found the provider xml - " + file.getAbsolutePath());
            int index = file.getName().indexOf("-:");
            this.mprint("index = " + index);
            if (index == -1) continue;
            String moduleName = file.getName().substring(0, index);
            providerMap.put(moduleName, file);
            this.mprint(" The provider xml belongs to - \"" + moduleName + "\"");
            for (Module module : this.map.values()) {
                if (!module.getName().contains("grizzly")) continue;
                this.mprint(" module = \"" + module.getName() + "\"");
            }
            if (!this.map.containsKey(moduleName)) {
                Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, "Couldn't find the module, when loading the monitoring providers from XML directory : " + moduleName);
                continue;
            }
            this.mprint(" Module found (containsKey)");
            Module module = this.map.get(moduleName);
            if (module == null) {
                Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, "Couldn't find the module, when loading the monitoring providers from XML directory : " + moduleName);
                continue;
            }
            ClassLoader mcl = module.getClassLoader();
            this.mprint("ModuleClassLoader = " + mcl);
            this.mprint("XML File path = " + file.getAbsolutePath());
            this.processProbeProviderXML(mcl, file.getAbsolutePath(), false);
        }
    }

    private void printd(String pstring) {
        if (this.ddebug) {
            System.out.println(" APK : " + pstring);
        }
    }

    private void removeProvider(Module module) {
        this.mprint("removeProvider ...");
    }

    private void processProbeProviderClass(Class cls) {
        this.mprint("processProbeProviderClass for " + cls);
        try {
            this.probeProviderFactory.getProbeProvider(cls);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void processProbeProviderXML(ClassLoader mcl, String xname, boolean inBundle) {
        this.probeProviderFactory.processXMLProbeProviders(mcl, xname, inBundle);
    }

    private void mprint(String str) {
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        StatsProviderRegistry spr = this.spmd.getStatsProviderRegistry();
        for (PropertyChangeEvent event : propertyChangeEvents) {
            boolean oldEnabled;
            boolean newEnabled;
            if (event == null) continue;
            String propName = event.getPropertyName();
            Object oldVal = event.getOldValue();
            Object newVal = event.getNewValue();
            if (newVal == null || newVal.equals(oldVal) || !this.ok(propName)) continue;
            if (event.getSource() instanceof ModuleMonitoringLevels) {
                newEnabled = this.parseLevelsBoolean(newVal.toString());
                boolean bl = oldVal == null ? !newEnabled : (oldEnabled = this.parseLevelsBoolean(oldVal.toString()));
                if (newEnabled == oldEnabled || spr == null) continue;
                this.handleLevelChange(propName, newEnabled);
                continue;
            }
            if (!(event.getSource() instanceof MonitoringService)) continue;
            newEnabled = Boolean.parseBoolean(newVal.toString());
            boolean bl = oldVal == null ? !newEnabled : (oldEnabled = Boolean.parseBoolean(oldVal.toString()));
            if (newEnabled == oldEnabled) continue;
            this.handleServiceChange(spr, propName, newEnabled);
        }
        return null;
    }

    private void handleLevelChange(String propName, boolean enabled) {
        if (!this.ok(propName)) {
            return;
        }
        StatsProviderRegistry spr = this.spmd.getStatsProviderRegistry();
        if (spr == null) {
            return;
        }
        spr.setConfigEnabled(propName, enabled);
        if (enabled) {
            spr.enableStatsProvider(propName);
        } else {
            spr.disableStatsProvider(propName);
        }
    }

    private void handleServiceChange(StatsProviderRegistry spr, String propName, boolean enabled) {
        if (!this.ok(propName)) {
            return;
        }
        if (propName.equals("mbean-enabled")) {
            if (spr == null) {
                return;
            }
            if (enabled) {
                spr.registerAllGmbal();
            } else {
                spr.unregisterAllGmbal();
            }
        } else if (propName.equals("dtrace-enabled")) {
            this.probeProviderFactory.dtraceEnabledChanged(enabled);
        } else if (propName.equals("monitoring-enabled")) {
            this.probeProviderFactory.monitoringEnabledChanged(enabled);
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private boolean parseLevelsBoolean(String s) {
        return !this.ok(s) || !s.equals("OFF");
    }
}

