/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.container.common.LocalPassword;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityLifecycle;
import com.sun.enterprise.security.SecuritySniffer;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.security.common.Group;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

@Service
public class GenericAdminAuthenticator
implements AdminAccessController,
JMXAuthenticator {
    @Inject
    Habitat habitat;
    @Inject
    SecuritySniffer snif;
    @Inject
    volatile SecurityService ss;
    private final String defaultAdminUser = "anonymous";
    @Inject
    volatile AdminService as;
    @Inject
    LocalPassword localPassword;
    @Inject
    ClassLoaderHierarchy clh;
    private static LocalStringManagerImpl lsm = new LocalStringManagerImpl(GenericAdminAuthenticator.class);
    private final Logger logger = Logger.getAnonymousLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginAsAdmin(String user, String password, String realm) throws LoginException {
        if (this.as.usesFileRealm()) {
            return this.handleFileRealm(user, password);
        }
        ClassLoader pc = null;
        boolean hack = false;
        boolean authenticated = false;
        try {
            pc = Thread.currentThread().getContextClassLoader();
            if (!this.clh.getCommonClassLoader().equals(pc)) {
                Thread.currentThread().setContextClassLoader(this.clh.getCommonClassLoader());
                hack = true;
            }
            Inhabitant sl = this.habitat.getInhabitantByType(SecurityLifecycle.class);
            sl.get();
            this.snif.setup(System.getProperty("com.sun.aas.installRoot") + "/modules/security", Logger.getAnonymousLogger());
            LoginContextDriver.login((String)user, (String)password, (String)realm);
            authenticated = true;
            boolean bl = this.ensureGroupMembership(user, realm);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (hack) {
                Thread.currentThread().setContextClassLoader(pc);
            }
        }
    }

    private boolean ensureGroupMembership(String user, String realm) {
        String ADMIN_GROUP = "asadmin";
        try {
            SecurityContext sc = SecurityContext.getCurrent();
            Set ps = sc.getPrincipalSet();
            for (Object principal : ps) {
                Group group;
                if (!(principal instanceof Group) || !"asadmin".equals((group = (Group)principal).getName())) continue;
                return true;
            }
            this.logger.fine("User is not the member of the special admin group");
            return false;
        }
        catch (Exception e) {
            this.logger.fine("User is not the member of the special admin group: " + e.getMessage());
            return false;
        }
    }

    private boolean handleFileRealm(String user, String password) throws LoginException {
        boolean anonok = this.serverAllowsAnonymousFileRealmLogin();
        if (anonok) {
            return anonok;
        }
        boolean isLocal = this.isLocalPassword(user, password);
        if (isLocal) {
            return true;
        }
        try {
            AuthRealm ar = this.as.getAssociatedAuthRealm();
            if (FileRealm.class.getName().equals(ar.getClassname())) {
                String adminKeyFilePath = ar.getPropertyValue("file");
                FileRealm fr = new FileRealm(adminKeyFilePath);
                FileRealmUser fru = (FileRealmUser)fr.getUser(user);
                for (String group : fru.getGroups()) {
                    if (!group.equals("asadmin")) continue;
                    return fr.authenticate(user, password) != null;
                }
                return false;
            }
        }
        catch (NoSuchUserException ue) {
            return false;
        }
        catch (Exception e) {
            LoginException le = new LoginException(e.getMessage());
            le.initCause(e);
            throw le;
        }
        return false;
    }

    private boolean serverAllowsAnonymousFileRealmLogin() {
        AuthRealm realm = this.as.getAssociatedAuthRealm();
        if (realm == null) {
            throw new RuntimeException("Warning: Configuration is bad, realm: " + this.as.getAuthRealmName() + " does not exist!");
        }
        if (!FileRealm.class.getName().equals(realm.getClassname())) {
            this.logger.fine("NOT ALLOWING ANONYMOUS ADMIN LOGIN, SINCE IT's NOT A FILE");
            return false;
        }
        String pv = realm.getPropertyValue("file");
        File rf = null;
        if (pv == null || !(rf = new File(pv)).exists()) {
            this.logger.fine("ALLOWING ANONYMOUS ADMIN LOGIN AS THE KEYFILE DOES NOT EXIST");
            return true;
        }
        try {
            String au;
            FileRealm fr = new FileRealm(rf.getAbsolutePath());
            Enumeration users = fr.getUserNames();
            if (users.hasMoreElements() && "anonymous".equals(au = (String)users.nextElement()) && !users.hasMoreElements()) {
                this.logger.fine("Allowing anonymous access");
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean isLocalPassword(String user, String password) {
        if (!this.localPassword.isLocalPassword(password)) {
            this.logger.finest("Password is not the local password");
            return false;
        }
        this.logger.fine("Allowing access using local password");
        return true;
    }

    public Subject authenticate(Object credentials) {
        if (this.serverAllowsAnonymousFileRealmLogin()) {
            this.logger.fine("Allowing anonymous login for JMX Access");
            return null;
        }
        if (!(credentials instanceof String[])) {
            String msg = lsm.getLocalString("two.elem.array", "The JMX Connector should access with a two-element string array containing user name and password");
            throw new SecurityException(msg);
        }
        Object[] up = (String[])credentials;
        if (up.length < 2) {
            String msg = lsm.getLocalString("invalid.array", "JMX Connector (client) provided an invalid array {0}, access denied", new Object[]{Arrays.toString(up)});
            throw new SecurityException(msg);
        }
        String u = up[0];
        String p = up[1];
        String realm = this.as.getSystemJmxConnector().getAuthRealmName();
        if (realm == null) {
            realm = this.as.getAuthRealmName();
        }
        try {
            boolean ok = this.loginAsAdmin(u, p, realm);
            if (!ok) {
                String msg = lsm.getLocalString("authentication.failed", "User [{0}] does not have administration access", new Object[]{u});
                throw new SecurityException(msg);
            }
            return null;
        }
        catch (LoginException e) {
            throw new SecurityException(e);
        }
    }
}

