/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import javax.resource.spi.Activation;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ActivationHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractHandler.class);

    public Class<? extends Annotation> getAnnotationType() {
        return Activation.class;
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        Activation activation = (Activation)element.getAnnotation();
        if (aeHandler instanceof RarBundleContext) {
            RarBundleContext rarContext = (RarBundleContext)aeHandler;
            ConnectorDescriptor desc = rarContext.getDescriptor();
            if (activation.messageListeners().length > 0) {
                if (!desc.getInBoundDefined()) {
                    desc.setInboundResourceAdapter(new InboundResourceAdapter());
                }
                InboundResourceAdapter ira = desc.getInboundResourceAdapter();
                Class c = (Class)element.getAnnotatedElement();
                String activationSpecClass = c.getName();
                for (Class mlClass : activation.messageListeners()) {
                    MessageListener ml = new MessageListener();
                    ml.setActivationSpecClass(activationSpecClass);
                    ml.setMessageListenerType(mlClass.getName());
                    if (ira.hasMessageListenerType(mlClass.getName())) continue;
                    ira.addMessageListener(ml);
                }
            }
        } else {
            this.getFailureResult(element, "Not a rar bundle context", true);
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return null;
    }

    @Override
    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            Class c = (Class)element.getAnnotatedElement();
            String className = c.getName();
            Object[] args = new Object[]{element.getAnnotation(), className, message};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.connectorannotationfailure", "failed to handle annotation [ {0} ] on class [ {1} ], reason : {2}", args);
            this.logger.log(Level.WARNING, localString);
        }
        return result;
    }
}

