/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.annotation.handlers.ConfigPropertyHandler;
import com.sun.enterprise.deployment.annotation.handlers.ConnectorAnnotationHandler;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.Connector;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;

public class ConnectorValidator
implements ConnectorVisitor {
    private Logger _logger = LogDomains.getLogger(DOLUtils.class, (String)"javax.enterprise.system.tools.deployment");

    public void accept(ConnectorDescriptor descriptor) {
        if (!descriptor.getValidConnectorAnnotationProcessed()) {
            Set<AnnotationInfo> annotations = descriptor.getConnectorAnnotations();
            String raClass = descriptor.getResourceAdapterClass();
            if (annotations.size() == 0) {
                return;
            }
            if (annotations.size() == 1) {
                Iterator<AnnotationInfo> it = annotations.iterator();
                AnnotationInfo annotationInfo = it.next();
                Class claz = (Class)annotationInfo.getAnnotatedElement();
                Connector connector = (Connector)annotationInfo.getAnnotation();
                ConnectorAnnotationHandler.processDescriptor(claz, connector, descriptor);
                Collection<AnnotationInfo> configProperties = descriptor.getConfigPropertyAnnotations(claz.getName());
                if (configProperties != null) {
                    for (AnnotationInfo ai : configProperties) {
                        ConfigPropertyHandler handler = new ConfigPropertyHandler();
                        try {
                            handler.processAnnotation(ai);
                        }
                        catch (AnnotationProcessorException e) {
                            RuntimeException re = new RuntimeException("Unable to process ConfigProperty annotation in class [" + claz.getName() + "] : " + e.getMessage());
                            re.initCause(e);
                            throw re;
                        }
                    }
                }
            } else if ((raClass == null || raClass.equals("")) && annotations.size() > 1) {
                throw new RuntimeException("cannot determine appropriate @Connector annotation as multiple annotations are present");
            }
        }
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, descriptor.toString());
        }
        descriptor.getConnectorAnnotations().clear();
        descriptor.getAllConfigPropertyAnnotations().clear();
    }
}

