/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.ext;

import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.Realms;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.intf.config.AuthRealm;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admin.amx.intf.config.Configs;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.Property;
import org.glassfish.admin.amx.intf.config.SecurityService;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.internal.api.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RealmsImpl
extends AMXImplBase {
    private final RealmsManager mRealmsManager = (RealmsManager)Globals.getDefaultHabitat().getComponent(RealmsManager.class);
    private volatile boolean realmsLoaded = false;
    private static final String ADMIN_REALM = "admin-realm";
    private static final String ANONYMOUS_USER = "anonymous";
    private static final String FILE_REALM_CLASSNAME = "com.sun.enterprise.security.auth.realm.file.FileRealm";

    public RealmsImpl(ObjectName containerObjectName) {
        super(containerObjectName, Realms.class);
    }

    private void loadRealms() {
        if (this.realmsLoaded) {
            return;
        }
        this._loadRealms();
    }

    private synchronized void _loadRealms() {
        if (this.realmsLoaded) {
            throw new IllegalStateException();
        }
        Domain domainConfig = (Domain)this.getDomainRootProxy().child(Domain.class);
        if (domainConfig == null) {
            throw new IllegalStateException("Null Domain config");
        }
        Config config = (Config)domainConfig.getConfigs().getConfig().values().iterator().next();
        SecurityService ss = config.getSecurityService();
        Map authRealmConfigs = ss.childrenMap(AuthRealm.class);
        ArrayList<String> goodRealms = new ArrayList<String>();
        for (AuthRealm authRealm : authRealmConfigs.values()) {
            Map propConfigs = authRealm.childrenMap(Property.class);
            Properties props = new Properties();
            for (Property p : propConfigs.values()) {
                String value = p.resolveAttribute("Value");
                props.setProperty(p.getName(), value);
            }
            try {
                Realm.instantiate((String)authRealm.getName(), (String)authRealm.getClassname(), (Properties)props);
                goodRealms.add(authRealm.getName());
            }
            catch (Exception e) {
                ImplUtil.getLogger().log(Level.WARNING, "Can't instantiate realm: " + authRealm, e);
            }
        }
        if (goodRealms.size() != 0) {
            String goodRealm = (String)goodRealms.iterator().next();
            try {
                String defaultRealm = ss.getDefaultRealm();
                Realm r = Realm.getInstance((String)defaultRealm);
                Realm.setDefaultRealm((String)defaultRealm);
            }
            catch (Exception e) {
                ImplUtil.getLogger().log(Level.WARNING, "Can't get realm ", e);
                Realm.setDefaultRealm((String)((String)goodRealms.iterator().next()));
            }
        }
        this.realmsLoaded = true;
    }

    public String[] getRealmNames() {
        this.loadRealms();
        List items = ListUtil.newList((Enumeration)this.mRealmsManager.getRealmNames());
        return (String[])CollectionUtil.toArray((Collection)items, String.class);
    }

    public String[] getPredefinedAuthRealmClassNames() {
        List items = this.mRealmsManager.getPredefinedAuthRealmClassNames();
        return (String[])CollectionUtil.toArray((Collection)items, String.class);
    }

    public String getDefaultRealmName() {
        return this.mRealmsManager.getDefaultRealmName();
    }

    public void setDefaultRealmName(String realmName) {
        this.mRealmsManager.setDefaultRealmName(realmName);
    }

    private Realm getRealm(String realmName) {
        this.loadRealms();
        Realm realm = this.mRealmsManager.getFromLoadedRealms(realmName);
        if (realm == null) {
            throw new IllegalArgumentException("No such realm: " + realmName);
        }
        return realm;
    }

    public void addUser(String realmName, String user, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.addUser(user, password, groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateUser(String realmName, String existingUser, String newUser, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.updateUser(existingUser, newUser, password, groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUser(String realmName, String user) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.removeUser(user);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsUserManagement(String realmName) {
        return this.getRealm(realmName).supportsUserManagement();
    }

    private void checkSupportsUserManagement(String realmName) {
        if (!this.supportsUserManagement(realmName)) {
            throw new IllegalStateException("Realm " + realmName + " does not support user management");
        }
    }

    public String[] getUserNames(String realmName) {
        try {
            List names = ListUtil.newList((Enumeration)this.getRealm(realmName).getUserNames());
            return (String[])CollectionUtil.toArray((Collection)names, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getGroupNames(String realmName) {
        try {
            List names = ListUtil.newList((Enumeration)this.getRealm(realmName).getGroupNames());
            return (String[])CollectionUtil.toArray((Collection)names, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getGroupNames(String realmName, String user) {
        try {
            return (String[])CollectionUtil.toArray((Collection)ListUtil.newList((Enumeration)this.getRealm(realmName).getGroupNames(user)), String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> getUserAttributes(String realmName, String username) {
        try {
            User user = this.getRealm(realmName).getUser(username);
            HashMap<String, Object> m = new HashMap<String, Object>();
            List attrNames = ListUtil.newList((Enumeration)user.getAttributeNames());
            for (String attrName : attrNames) {
                m.put(attrName, user.getAttribute(attrName));
            }
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void debug(String s) {
        System.out.println("##### " + s);
    }

    public boolean getAnonymousLogin() {
        DomainRoot domainRoot = this.getDomainRootProxy();
        Domain domainConfig = (Domain)domainRoot.child(Domain.class);
        Configs cc = domainConfig.getConfigs();
        Map configs = cc.childrenMap(Config.class);
        AuthRealm adminFileAuthRealm = null;
        block0: for (Config config : configs.values()) {
            if (config.getSecurityService() == null) continue;
            for (AuthRealm auth : config.getSecurityService().childrenMap(AuthRealm.class).values()) {
                if (!auth.getName().equals(ADMIN_REALM)) continue;
                adminFileAuthRealm = auth;
                continue block0;
            }
        }
        if (adminFileAuthRealm == null) {
            throw new IllegalStateException("Cannot find admin realm");
        }
        String fileRealmClassName = adminFileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals(FILE_REALM_CLASSNAME)) {
            return false;
        }
        Map props = adminFileAuthRealm.childrenMap(Property.class);
        Property keyfileProp = (Property)props.get("file");
        if (keyfileProp == null) {
            throw new IllegalStateException("Cannot find property 'file'");
        }
        String keyFile = keyfileProp.resolveAttribute("Value");
        if (keyFile == null) {
            throw new IllegalStateException("Cannot find key file");
        }
        String[] usernames = this.getUserNames(adminFileAuthRealm.getName());
        return usernames.length == 1 && usernames[0].equals(ANONYMOUS_USER);
    }
}

