/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.ldap.LDAPRealm;
import com.sun.enterprise.util.i18n.StringManager;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="configure-ldap-for-admin")
public class LDAPAdminAccessConfigurator
implements AdminCommand {
    @Param(name="basedn", shortName="b", optional=false)
    public volatile String basedn;
    @Param(name="url", shortName="u", optional=true)
    public volatile String url = "ldap://localhost:389";
    @Param(name="ping", shortName="p", optional=true, defaultValue="false")
    public volatile Boolean ping = Boolean.FALSE;
    @Param(name="ldap-group", shortName="g", optional=false)
    public volatile String ldapGroupName;
    @Inject
    Configs allConfigs;
    private static final String ADMIN_SERVER = "server";
    private static final StringManager lsm = StringManager.getManager(LDAPAdminAccessConfigurator.class);
    private static final String DIR_P = "directory";
    private static final String BASEDN_P = "base-dn";
    private static final String JAAS_P = "jaas-context";
    private static final String JAAS_V = "ldapRealm";
    public static final String FIXED_ADMIN_REALM_NAME = "admin-realm";
    public static final String ORIG_ADMIN_REALM_NAME = "admin-realm-original";

    public void execute(AdminCommandContext context) {
        ActionReport rep = context.getActionReport();
        StringBuilder sb = new StringBuilder();
        if (this.url != null && !this.url.startsWith("ldap://") && !this.url.startsWith("ldaps://")) {
            this.url = this.url + "ldap://" + this.url;
        }
        this.pingLDAP(sb);
        try {
            this.configure(sb);
            rep.setMessage(sb.toString());
            rep.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tf) {
            rep.setMessage(tf.getMessage());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (PropertyVetoException e) {
            rep.setMessage(e.getMessage());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void configure(StringBuilder sb) throws TransactionFailure, PropertyVetoException {
        Server s = ConfigBeansUtilities.getServerNamed((String)ADMIN_SERVER);
        String ac = s.getConfigRef();
        Config asc = null;
        for (Config cfg : this.allConfigs.getConfig()) {
            if (!cfg.getName().equals(ac)) continue;
            asc = cfg;
            break;
        }
        this.renameRealm(sb, this.getAdminRealm(asc.getSecurityService()), this.getNewRealmName(asc.getSecurityService()));
        this.createRealm(asc.getSecurityService(), sb);
        this.configureAdminService(asc.getAdminService());
    }

    private String getNewRealmName(SecurityService ss) {
        List realms = ss.getAuthRealm();
        String pref = "admin-realm-original-";
        int index = 0;
        for (AuthRealm realm : realms) {
            if (realm.getName().indexOf(pref) < 0) continue;
            index = Integer.parseInt(realm.getName().substring(pref.length()));
        }
        return pref + (index + 1);
    }

    private AuthRealm getAdminRealm(SecurityService ss) {
        List realms = ss.getAuthRealm();
        for (AuthRealm realm : realms) {
            if (!FIXED_ADMIN_REALM_NAME.equals(realm.getName())) continue;
            return realm;
        }
        return null;
    }

    private void configureAdminService(AdminService as) throws PropertyVetoException, TransactionFailure {
        SingleConfigCode<AdminService> scc = new SingleConfigCode<AdminService>(){

            public Object run(AdminService as) {
                try {
                    as.setAuthRealmName(LDAPAdminAccessConfigurator.FIXED_ADMIN_REALM_NAME);
                    return as;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        ConfigSupport.apply((SingleConfigCode)scc, (ConfigBeanProxy)as);
    }

    private void createRealm(SecurityService ss, final StringBuilder sb) throws TransactionFailure {
        SingleConfigCode<SecurityService> scc = new SingleConfigCode<SecurityService>(){

            public Object run(SecurityService ss) throws PropertyVetoException, TransactionFailure {
                AuthRealm ldapr = LDAPAdminAccessConfigurator.this.createLDAPRealm(ss);
                ss.getAuthRealm().add(ldapr);
                LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.realm.setup", (Object)LDAPAdminAccessConfigurator.FIXED_ADMIN_REALM_NAME));
                return true;
            }
        };
        ConfigSupport.apply((SingleConfigCode)scc, (ConfigBeanProxy)ss);
    }

    private void renameRealm(final StringBuilder sb, AuthRealm realm, final String to) throws PropertyVetoException, TransactionFailure {
        SingleConfigCode<AuthRealm> scc = new SingleConfigCode<AuthRealm>(){

            public Object run(AuthRealm realm) throws PropertyVetoException, TransactionFailure {
                LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("config.to.ldap", (Object)LDAPAdminAccessConfigurator.FIXED_ADMIN_REALM_NAME, (Object)to));
                realm.setName(to);
                return realm;
            }
        };
        ConfigSupport.apply((SingleConfigCode)scc, (ConfigBeanProxy)realm);
    }

    private AuthRealm createLDAPRealm(SecurityService ss) throws TransactionFailure, PropertyVetoException {
        AuthRealm ar = (AuthRealm)ss.createChild(AuthRealm.class);
        ar.setClassname(LDAPRealm.class.getName());
        ar.setName(FIXED_ADMIN_REALM_NAME);
        List props = ar.getProperty();
        Property p = (Property)ar.createChild(Property.class);
        p.setName(DIR_P);
        p.setValue(this.url);
        props.add(p);
        p = (Property)ar.createChild(Property.class);
        p.setName(BASEDN_P);
        p.setValue(this.basedn);
        props.add(p);
        p = (Property)ar.createChild(Property.class);
        p.setName(JAAS_P);
        p.setValue(JAAS_V);
        props.add(p);
        p = (Property)ar.createChild(Property.class);
        p.setName("group-mapping");
        p.setValue(this.ldapGroupName + "->asadmin");
        props.add(p);
        return ar;
    }

    private void pingLDAP(StringBuilder sb) {
        if (!this.ping.booleanValue()) {
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.noping", (Object)this.url));
            return;
        }
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        try {
            new InitialContext(env);
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.ok", (Object)this.url));
        }
        catch (Exception e) {
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.na", (Object)this.url, (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
    }

    private static void appendNL(StringBuilder sb, String s) {
        sb.append(s).append("%%%EOL%%%");
    }
}

