/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class MonitoringUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject(optional=true)
    MonitoringService ms;
    @Inject
    Logger logger;

    public void postConstruct() {
        try {
            if (this.ms == null) {
                this.logger.log(Level.INFO, "No upgrade necessary, monitoring-service does not exist in domain.xml");
                return;
            }
            final ModuleMonitoringLevels mmls = this.ms.getModuleMonitoringLevels();
            if (mmls == null) {
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getOrb())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "orb", mmls.getOrb());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getEjbContainer())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "ejb-container", mmls.getEjbContainer());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getJmsService())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "jms-service", mmls.getJmsService());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getConnectorConnectionPool())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "connector-connection-pool", mmls.getConnectorConnectionPool());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getConnectorService())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "connector-service", mmls.getConnectorService());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getHttpService())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "http-service", mmls.getHttpService());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getJdbcConnectionPool())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "jdbc-connection-pool", mmls.getJdbcConnectionPool());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getJvm())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "jvm", mmls.getJvm());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getThreadPool())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "thread-pool", mmls.getThreadPool());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getTransactionService())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "transaction-service", mmls.getTransactionService());
                    }
                    if (MonitoringUpgrade.this.isNonDefault(mmls.getWebContainer())) {
                        MonitoringUpgrade.this.addContainerMonitoring(param, "web-container", mmls.getWebContainer());
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.ms);
        }
        catch (TransactionFailure tf) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading domain.xml monitoring-service", tf);
            throw new RuntimeException(tf);
        }
    }

    private boolean isNonDefault(String name) {
        return name != null && name.length() > 0 && !name.equals("OFF");
    }

    private void addContainerMonitoring(MonitoringService ms, String name, String level) throws TransactionFailure, PropertyVetoException {
        if (ms.getContainerMonitoring(name) == null) {
            ContainerMonitoring newItem = (ContainerMonitoring)ms.createChild(ContainerMonitoring.class);
            newItem.setName(name);
            newItem.setLevel(level);
            ms.getContainerMonitoring().add(newItem);
        }
    }
}

