/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="JVM Garbage Collectors Statistics")
public class JVMGCStatsProvider {
    private List<GarbageCollectorMXBean> gcBeanList = ManagementFactory.getGarbageCollectorMXBeans();
    private String gcName = null;

    public JVMGCStatsProvider(String gcName) {
        this.gcName = gcName;
    }

    @ManagedAttribute(id="collectioncount-count")
    @Description(value="total number of collections that have occurred")
    public long getCollectionCount() {
        long counts = -1L;
        for (GarbageCollectorMXBean gcBean : this.gcBeanList) {
            if (!gcBean.getName().equals(this.gcName)) continue;
            counts = gcBean.getCollectionCount();
        }
        return counts;
    }

    @ManagedAttribute(id="collectiontime-count")
    @Description(value="approximate accumulated collection elapsed time in milliseconds")
    public long getCollectionTime() {
        long times = -1L;
        boolean i = false;
        for (GarbageCollectorMXBean gcBean : this.gcBeanList) {
            if (!gcBean.getName().equals(this.gcName)) continue;
            times = gcBean.getCollectionTime();
        }
        return times;
    }
}

