/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.javaee.services.ResourcesBinder;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="ResourceManager")
public class ResourceManager
implements Startup,
PostConstruct,
PreDestroy,
ConfigListener {
    private static final Logger logger = LogDomains.getLogger(ResourceManager.class, (String)"LogStrings");
    @Inject
    private ResourcesBinder resourcesBinder;
    @Inject
    private Habitat connectorRuntimeHabitat;
    @Inject
    private Resources allResources;
    @Inject
    private Habitat deployerHabitat;
    private ConnectorRuntime runtime;
    @Inject
    private ResourceRef[] resourceRefs;

    public void postConstruct() {
        this.deployResources(this.allResources.getResources());
        this.addListenerToResourceRefs();
    }

    public void deployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            if (resource instanceof BindableResource) {
                BindableResource bindableResource = (BindableResource)resource;
                this.resourcesBinder.deployResource(bindableResource.getJndiName(), resource);
                continue;
            }
            if (resource instanceof ResourcePool) continue;
            try {
                this.getResourceDeployer(resource).deployResource((Object)resource);
            }
            catch (Exception e) {
                Object[] params = new Object[]{ConnectorsUtil.getResourceName((Resource)resource), e};
                logger.log(Level.WARNING, "resources.resource-manager.deploy-resource-failed", params);
            }
        }
        this.addListenerToResources(resources);
    }

    public Resources getAllResources() {
        return this.allResources;
    }

    public void preDestroy() {
        if (this.isConnectorRuntimeInitialized()) {
            Collection resources = ConnectorsUtil.getAllSystemRAResourcesAndPools((Resources)this.allResources);
            this.undeployResources(resources);
            ConnectorRuntime cr = this.getConnectorRuntime();
            if (cr != null) {
                cr.cleanUpResourcesAndShutdownAllActiveRAs();
            }
        } else {
            logger.finest("ConnectorRuntime not initialized, hence skipping resource-adapters shutdown, resources, pools cleanup");
        }
        this.removeListenerFromResources();
        this.removeListenerFromResourceRefs();
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class, null);
        }
        return this.runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            try {
                this.getResourceDeployer(resource).undeployResource((Object)resource);
            }
            catch (Exception e) {
                Object[] params = new Object[]{ConnectorsUtil.getResourceName((Resource)resource), e};
                logger.log(Level.WARNING, "resources.resource-manager.undeploy-resource-failed", params);
            }
            finally {
                this.removeListenerFromResource(resource);
            }
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new PropertyChangeHandler(events), (Logger)logger);
    }

    public boolean isConnectorRuntimeInitialized() {
        Collection inhabitants = this.connectorRuntimeHabitat.getInhabitants(ConnectorRuntime.class);
        Iterator i$ = inhabitants.iterator();
        if (i$.hasNext()) {
            Inhabitant inhabitant = (Inhabitant)i$.next();
            return inhabitant.isInstantiated();
        }
        return true;
    }

    private void addListenerToResources(Collection<Resource> resources) {
        for (Resource configuredResource : resources) {
            this.addListenerToResource(configuredResource);
        }
    }

    private void addListenerToResourceRefs() {
        for (ResourceRef ref : this.resourceRefs) {
            this.addListenerToResource(ref);
        }
    }

    private void addListenerToResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.addListener((ConfigListener)this);
        } else if (instance instanceof ResourceRef) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.addListener((ConfigListener)this);
        }
    }

    private void removeListenerFromResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.removeListener((ConfigListener)this);
        } else if (instance instanceof ResourceRef) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.removeListener((ConfigListener)this);
        }
    }

    private void removeListenerFromResourceRefs() {
        for (ResourceRef ref : this.resourceRefs) {
            this.removeListenerFromResource(ref);
        }
    }

    private void removeListenerFromResources() {
        for (Resource configuredResource : this.allResources.getResources()) {
            this.removeListenerFromResource(configuredResource);
        }
    }

    private ResourceDeployer getResourceDeployer(Object resource) {
        Collection deployers = this.deployerHabitat.getAllByContract(ResourceDeployer.class);
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            return deployer;
        }
        return null;
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyChangeHandler
    implements Changed {
        PropertyChangeEvent[] events;

        private PropertyChangeHandler(PropertyChangeEvent[] events) {
            this.events = events;
        }

        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            switch (type) {
                case ADD: {
                    logger.fine("A new " + changedType.getName() + " was added : " + changedInstance);
                    np = this.handleAddEvent(changedInstance);
                    break;
                }
                case CHANGE: {
                    logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                    np = this.handleChangeEvent(changedInstance);
                    break;
                }
                case REMOVE: {
                    logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                    np = this.handleRemoveEvent(changedInstance);
                    break;
                }
                default: {
                    np = new NotProcessed("Unrecognized type of change: " + type);
                }
            }
            return np;
        }

        private void checkAndPingPool(Object instance, boolean deployedStatus) {
            boolean ping = false;
            ResourcePool pool = (ResourcePool)instance;
            if (ResourceManager.this.getConnectorRuntime().getPingDuringPoolCreation(pool.getName())) {
                if (!deployedStatus) {
                    try {
                        ResourceManager.this.getResourceDeployer(instance).deployResource(instance);
                    }
                    catch (Exception ex) {
                        String resourceName = ConnectorsUtil.getResourceName((Resource)((Resource)instance));
                        Object[] params = new Object[]{resourceName, ex};
                        logger.log(Level.WARNING, "resources.resource-manager.deploy-resource-failed", params);
                    }
                }
                try {
                    logger.fine("Pinging pool " + pool.getName() + " during creation");
                    ping = ResourceManager.this.getConnectorRuntime().pingConnectionPool(pool.getName());
                }
                catch (Exception ex) {
                    Object[] params = new Object[]{pool.getName(), ex};
                    logger.log(Level.WARNING, "ping_during_creation_exception", params);
                }
                if (!ping) {
                    logger.log(Level.WARNING, "ping_during_creation_failure", pool.getName());
                }
            }
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            NotProcessed np = null;
            try {
                if (ConnectorsUtil.isValidEventType(instance)) {
                    ResourceManager.this.getResourceDeployer(instance).redeployResource(instance);
                    if (instance instanceof ResourcePool) {
                        this.checkAndPingPool(instance, true);
                    }
                } else if (ConnectorsUtil.isValidEventType((Object)instance.getParent())) {
                    ResourceManager.this.getResourceDeployer(instance.getParent()).redeployResource((Object)instance.getParent());
                    if (instance.getParent() instanceof ResourcePool) {
                        this.checkAndPingPool(instance, true);
                    }
                } else if (instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    ResourceDeployer deployer = null;
                    String refName = ref.getRef();
                    BindableResource bindableResource = null;
                    for (PropertyChangeEvent event : this.events) {
                        String propertyName = event.getPropertyName();
                        if (!"enabled".equalsIgnoreCase(propertyName)) continue;
                        boolean newValue = ConnectorsUtil.parseBoolean((String)event.getNewValue().toString());
                        boolean oldValue = ConnectorsUtil.parseBoolean((String)event.getOldValue().toString());
                        for (Resource resource : ResourceManager.this.allResources.getResources()) {
                            if (!(resource instanceof BindableResource)) continue;
                            bindableResource = (BindableResource)resource;
                            if (refName == null || !refName.equals(bindableResource.getJndiName())) continue;
                            deployer = ResourceManager.this.getResourceDeployer(bindableResource);
                            break;
                        }
                        if (deployer == null || newValue && oldValue) continue;
                        if (newValue) {
                            deployer.enableResource(bindableResource);
                            continue;
                        }
                        deployer.disableResource(bindableResource);
                    }
                }
            }
            catch (Exception ex) {
                String msg = ResourceManager.class.getName() + " : Error while handling change Event";
                logger.severe(msg);
                np = new NotProcessed(msg);
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
            NotProcessed np = null;
            ResourceManager.this.addListenerToResource(instance);
            if (instance instanceof BindableResource) {
                ResourceManager.this.resourcesBinder.deployResource(((BindableResource)instance).getJndiName(), (Resource)instance);
            } else if (instance instanceof ResourcePool) {
                this.checkAndPingPool(instance, false);
            } else if (instance instanceof Resource) {
                try {
                    ResourceManager.this.getResourceDeployer(instance).deployResource(instance);
                }
                catch (Exception e) {
                    String resourceName = ConnectorsUtil.getResourceName((Resource)((Resource)instance));
                    Object[] params = new Object[]{resourceName, e};
                    logger.log(Level.WARNING, "resources.resource-manager.deploy-resource-failed", params);
                }
            } else if (instance instanceof Property || instance instanceof ResourceRef) {
                // empty if block
            }
            return np;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
            ArrayList<T> instancesToDestroy = new ArrayList<T>();
            NotProcessed np = null;
            try {
                if (ConnectorsUtil.isValidEventType(instance)) {
                    instancesToDestroy.add(instance);
                    ResourceManager.this.removeListenerFromResource(instance);
                    ResourceManager.this.getResourceDeployer(instance).undeployResource(instance);
                    return np;
                }
                if (ConnectorsUtil.isValidEventType((Object)instance.getParent())) {
                    ResourceManager.this.getResourceDeployer(instance).redeployResource((Object)instance.getParent());
                    return np;
                }
                if (!(instance instanceof ResourceRef)) return np;
            }
            catch (Exception ex) {
                String msg = ResourceManager.class.getName() + " : Error while handling remove Event";
                logger.severe(msg);
                return new NotProcessed(msg);
            }
            return np;
        }
    }
}

