/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParentChildren {
    final AMXProxy mParent;
    final List<ParentChildren> mChildren;

    public ParentChildren(AMXProxy parent, List<ParentChildren> children) {
        this.mParent = parent;
        this.mChildren = children;
    }

    public AMXProxy parent() {
        return this.mParent;
    }

    public List<ParentChildren> children() {
        return this.mChildren;
    }

    public List<String> toLines(boolean details) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ParentChildren.descriptionFor(this.mParent));
        for (ParentChildren child : this.mChildren) {
            List<String> moreLines = ParentChildren.indentAll(child.toLines(details));
            lines.addAll(moreLines);
        }
        return lines;
    }

    public List<AMXProxy> asList() {
        ArrayList<AMXProxy> items = new ArrayList<AMXProxy>();
        items.add(this.mParent);
        for (ParentChildren child : this.mChildren) {
            items.addAll(child.asList());
        }
        return items;
    }

    public static ParentChildren hierarchy(AMXProxy top) {
        ArrayList<AMXProxy> children = new ArrayList<AMXProxy>();
        Map childrenMaps = top.childrenMaps();
        for (Map childrenOfType : childrenMaps.values()) {
            for (AMXProxy amx : childrenOfType.values()) {
                children.add(amx);
            }
        }
        ArrayList<ParentChildren> pcList = new ArrayList<ParentChildren>();
        for (AMXProxy child : children) {
            ParentChildren pc = ParentChildren.hierarchy(child);
            pcList.add(pc);
        }
        return new ParentChildren(top, pcList);
    }

    public static String descriptionFor(AMXProxy proxy) {
        String desc = proxy.type();
        String name = proxy.nameProp();
        if (name != null) {
            desc = desc + "=" + name;
        }
        return desc;
    }

    private static List<String> indentAll(List<String> lines) {
        ArrayList<String> linesIndented = new ArrayList<String>();
        String INDENT = "   ";
        for (String line : lines) {
            linesIndented.add("   " + line);
        }
        return linesIndented;
    }

    public static String getHierarchyString(AMXProxy top) {
        ParentChildren pc = ParentChildren.hierarchy(top);
        return StringUtil.toLines(pc.toLines(true));
    }
}

