/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.internal.api.JAXRPCCodeGenFacade;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaEEDeployer<T extends Container, U extends ApplicationContainer>
implements Deployer<T, U> {
    @Inject
    protected ServerEnvironment env;
    @Inject
    protected ApplicationRegistry appRegistry;
    @Inject
    protected Habitat habitat;
    @Inject(name="application_undeploy", optional=true)
    protected ApplicationVisitor undeploymentVisitor = null;
    private static final String APPLICATION_TYPE = "Application-Type";

    public MetaData getMetaData() {
        return new MetaData(false, null, null);
    }

    protected String getModuleClassPath(DeploymentContext ctx) {
        StringBuilder classpath = new StringBuilder(ASClassLoaderUtil.getModuleClassPath((Habitat)this.habitat, (DeploymentContext)ctx));
        try {
            classpath.append(ctx.getSourceDir().toURI().getPath());
            classpath.append(File.pathSeparator);
            classpath.append(ctx.getScratchDir("ejb").toURI().getPath());
            classpath.append(File.pathSeparator);
            Application app = (Application)ctx.getModuleMetaData(Application.class);
            if (!app.isVirtual()) {
                ReadableArchive parentArchive = ctx.getSource().getParentArchive();
                String compatProp = ctx.getAppProps().getProperty("compatibility");
                List earLibURLs = ASClassLoaderUtil.getAppLibDirLibrariesAsList((File)new File(parentArchive.getURI()), (String)app.getLibraryDirectory(), (String)compatProp);
                for (URL url : earLibURLs) {
                    classpath.append(url.toURI().getPath());
                    classpath.append(File.pathSeparator);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classpath.toString();
    }

    protected String getCommonClassPath() {
        StringBuffer sb = new StringBuffer();
        File libDir = this.env.getLibPath();
        String libDirPath = libDir.getAbsolutePath();
        sb.append(libDirPath + File.separator + "classes");
        sb.append(File.pathSeparator);
        String[] files = libDir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".jar") && !files[i].endsWith(".zip")) continue;
                sb.append(libDirPath + File.separator + files[i]);
                sb.append(File.pathSeparator);
            }
        }
        return sb.toString();
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext dc) {
        return null;
    }

    public boolean prepare(DeploymentContext dc) {
        try {
            JAXRPCCodeGenFacade jaxrpcCodeGenFacade;
            this.prepareScratchDirs(dc);
            BundleDescriptor bundleDesc = (BundleDescriptor)dc.getModuleMetaData(BundleDescriptor.class);
            if (bundleDesc.hasWebServiceClients() && (jaxrpcCodeGenFacade = (JAXRPCCodeGenFacade)this.habitat.getByContract(JAXRPCCodeGenFacade.class)) != null) {
                jaxrpcCodeGenFacade.run(this.habitat, dc, this.getModuleClassPath(dc));
            }
            this.generateArtifacts(dc);
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public U load(T container, DeploymentContext context) {
        Application app = (Application)context.getModuleMetaData(Application.class);
        if (app != null) {
            app.setClassLoader(context.getClassLoader());
        }
        for (BundleDescriptor bundleDesc : app.getBundleDescriptors()) {
            bundleDesc.setClassLoader(context.getClassLoader());
        }
        return null;
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    public void clean(DeploymentContext context) {
        String appName;
        Application app;
        if (this.undeploymentVisitor != null && (app = this.getApplicationFromApplicationInfo(appName = context.getCommandParameters(OpsParams.class).name())) != null) {
            context.addModuleMetaData((Object)app);
            this.undeploymentVisitor.accept(app);
        }
    }

    protected void prepareScratchDirs(DeploymentContext context) throws IOException {
        context.getScratchDir("ejb").mkdirs();
        context.getScratchDir("xml").mkdirs();
        context.getScratchDir("jsp").mkdirs();
    }

    protected String getObjectType(DeploymentContext context) {
        try {
            Manifest manifest = context.getSource().getManifest();
            if (manifest == null) {
                return null;
            }
            Attributes attrs = manifest.getMainAttributes();
            return attrs.getValue(APPLICATION_TYPE);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected Application getApplicationFromApplicationInfo(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            return null;
        }
        return (Application)appInfo.getMetaData(Application.class);
    }

    protected abstract String getModuleType();
}

