/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="compilation-system-mon", group="monitoring")
@ManagedObject
@Description(value="JVM Compilation Statistics")
public class JVMCompilationStatsProvider {
    private CompilationMXBean compBean = ManagementFactory.getCompilationMXBean();
    private StringStatisticImpl compilerName = new StringStatisticImpl("Name", "String", "Name of the Just-in-time (JIT) compiler");
    private CountStatisticImpl totalCompilationTime = new CountStatisticImpl("TotalCompilationTime", "millisecond", "Approximate accumlated elapsed time (in milliseconds) spent in compilation");

    @ManagedAttribute(id="name-current")
    @Description(value="name of the Just-in-time (JIT) compiler")
    public StringStatistic getCompilerName() {
        this.compilerName.setCurrent(this.compBean.getName());
        this.compilerName.setLastSampleTime(System.currentTimeMillis());
        return this.compilerName;
    }

    @ManagedAttribute(id="totalcompilationtime-current")
    @Description(value="approximate accumlated elapsed time (in milliseconds) spent in compilation")
    public CountStatistic getTotalCompilationTime() {
        this.totalCompilationTime.setCount(this.compBean.getTotalCompilationTime());
        this.totalCompilationTime.setLastSampleTime(System.currentTimeMillis());
        return this.totalCompilationTime;
    }
}

