/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-domain")
@Scoped(value=PerLookup.class)
public final class DeleteDomainCommand
extends LocalDomainCommand {
    private static final String DOMAINDIR = "domaindir";
    private static final LocalStringsImpl strings = new LocalStringsImpl(DeleteDomainCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet opts = new LinkedHashSet();
        DeleteDomainCommand.addOption(opts, (String)DOMAINDIR, (char)'\u0000', (String)"STRING", (boolean)false, null);
        DeleteDomainCommand.addOption(opts, (String)"terse", (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        DeleteDomainCommand.addOption(opts, (String)"echo", (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        DeleteDomainCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 1;
        this.operandMax = 1;
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        if (this.options.containsKey("echo")) {
            this.programOpts.setEcho(this.getBooleanOption("echo"));
        }
        if (this.options.containsKey("terse")) {
            this.programOpts.setTerse(this.getBooleanOption("terse"));
        }
        this.initializeLogger();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            DomainConfig domainConfig = new DomainConfig(this.domainName, this.domainsDir.getPath());
            PEDomainsManager manager = new PEDomainsManager();
            manager.deleteDomain(domainConfig);
            this.deleteLoginInfo();
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage());
        }
        logger.printDetailMessage(strings.get("DomainDeleted", new Object[]{this.domainName}));
        return 0;
    }

    private void deleteLoginInfo() throws CommandValidationException {
    }
}

