/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.BootAMXListener;
import org.glassfish.admin.mbeanserver.ConnectorStarter;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.internal.api.AdminAccessController;

final class RMIConnectorStarter
extends ConnectorStarter {
    private final Registry mRegistry;

    public RMIConnectorStarter(MBeanServer mbeanServer, String address, int port, String protocol, String authRealmName, boolean securityEnabled, AdminAccessController authenticator, BootAMXListener bootListener) {
        super(mbeanServer, address, port, authRealmName, securityEnabled, authenticator, bootListener);
        if (!"rmi_jrmp".equals(protocol)) {
            throw new IllegalArgumentException("JMXConnectorServer not yet supporting protocol: " + protocol);
        }
        this.mRegistry = RMIConnectorStarter.startRegistry(this.mPort);
    }

    private static Registry startRegistry(int port) {
        System.setProperty("java.rmi.server.randomIDs", "true");
        try {
            return LocateRegistry.createRegistry(port);
        }
        catch (Exception e) {
            throw new RuntimeException("Port " + port + " is not available for the internal rmi registry. " + "This means that a call was made with the same port, without closing earlier " + "registry instance. This has to do with the system jmx connector configuration " + "in admin-service element of the configuration associated with this instance");
        }
    }

    public JMXConnectorServer start() throws MalformedURLException, IOException {
        String name = "jmxrmi";
        String hostname = Util.localhost();
        HashMap<String, AdminAccessController> env = new HashMap<String, AdminAccessController>();
        if (this.mAuthenticator != null) {
            env.put("jmx.remote.authenticator", this.mAuthenticator);
        }
        String hostPort = hostname + ":" + this.mPort;
        String urlStr = "service:jmx:rmi://" + hostPort + "/jndi/rmi://" + hostPort + "/" + "jmxrmi";
        this.mJMXServiceURL = new JMXServiceURL(urlStr);
        this.mConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.mJMXServiceURL, env, this.mMBeanServer);
        if (this.mBootListener != null) {
            this.mConnectorServer.addNotificationListener(this.mBootListener, null, this.mJMXServiceURL.toString());
        }
        this.mConnectorServer.start();
        return this.mConnectorServer;
    }
}

