/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.Pathnames;
import org.glassfish.admin.amx.base.Tools;
import org.glassfish.admin.amx.core.AMXValidator;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.mbean.ParentChildren;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.MBeanInterfaceGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsImpl
extends AMXImplBase {
    private static final String NL = StringUtil.NEWLINE();
    private static final String WILD_SUFFIX = ",*";
    private static final String WILD_ALL = "*";

    public ToolsImpl(ObjectName parent) {
        super(parent, Tools.class);
    }

    private static ObjectName newObjectName(String s) {
        try {
            return new ObjectName(s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getInfo() {
        return this.info(WILD_ALL);
    }

    public String infoPP(String parentPath, boolean recursive) {
        Pathnames paths = this.getDomainRootProxy().getPathnames();
        ObjectName[] objectNames = paths.listObjectNames(parentPath, recursive);
        Set<ObjectName> s = SetUtil.newSet(objectNames);
        return this.info(s);
    }

    public String infoType(String type) {
        return this.info("*:type=" + type + WILD_SUFFIX);
    }

    public String infoPath(String path) {
        ObjectName objectName = this.getDomainRootProxy().getPathnames().resolvePath(path);
        ArrayList<ObjectName> c = objectName == null ? new ArrayList() : Collections.singleton(objectName);
        return this.info(c);
    }

    public String java(ObjectName objectName) {
        MBeanInfo mbeanInfo = this.getProxyFactory().getMBeanInfo(objectName);
        MBeanInterfaceGenerator gen = new MBeanInterfaceGenerator();
        String out = gen.generate(mbeanInfo, true);
        return out;
    }

    public String info(Collection<ObjectName> objectNames) {
        HashSet<String> alreadyDone = new HashSet<String>();
        StringBuffer buf = new StringBuffer();
        if (objectNames.size() != 0) {
            String NL = StringUtil.NEWLINE();
            for (ObjectName objectName : objectNames) {
                MBeanInfo mbeanInfo = this.getProxyFactory().getMBeanInfo(objectName);
                String type = Util.getTypeProp(objectName);
                String classname = mbeanInfo.getClassName();
                if (alreadyDone.contains(type) && alreadyDone.contains(classname)) continue;
                alreadyDone.add(type);
                alreadyDone.add(classname);
                buf.append("MBeanInfo for " + objectName + NL);
                buf.append(this.java(objectName));
                buf.append(NL + NL + NL + NL);
            }
        }
        buf.append("Matched " + objectNames.size() + " mbean(s).");
        return buf.toString();
    }

    public String info(String searchStringIn) {
        String domain = this.getObjectName().getDomain();
        ObjectName pattern = ToolsImpl.newObjectName(searchStringIn);
        if (pattern == null && (searchStringIn.length() == 0 || searchStringIn.equals(WILD_ALL))) {
            pattern = ToolsImpl.newObjectName("*:*");
        }
        if (pattern == null) {
            String temp = searchStringIn;
            boolean hasProps = temp.indexOf("=") > 0;
            boolean hasDomain = temp.indexOf(":") >= 0;
            boolean isPattern = temp.endsWith(WILD_SUFFIX);
            if (!(hasProps || hasDomain || isPattern)) {
                pattern = ToolsImpl.newObjectName("*:type=" + temp + WILD_SUFFIX);
                if (pattern == null) {
                    pattern = ToolsImpl.newObjectName("*:j2eeType=" + temp + WILD_SUFFIX);
                }
                if (pattern == null) {
                    pattern = ToolsImpl.newObjectName("*:name=" + temp + WILD_SUFFIX);
                }
            }
            if (pattern == null) {
                return "No MBeans found for: " + searchStringIn;
            }
        }
        Set<ObjectName> objectNames = this.getMBeanServer().queryNames(pattern, null);
        return this.info(objectNames);
    }

    public String validate(ObjectName[] targets) {
        HashSet<ObjectName> all = new HashSet<ObjectName>();
        for (ObjectName objectName : targets) {
            if (objectName.isPattern()) {
                Set<ObjectName> found = this.getMBeanServer().queryNames(objectName, null);
                all.addAll(found);
                continue;
            }
            all.add(objectName);
        }
        ObjectName[] allArray = CollectionUtil.toArray(all, ObjectName.class);
        AMXValidator validator = new AMXValidator(this.getMBeanServer(), "high", false);
        AMXValidator.ValidationResult result = validator.validate(allArray);
        return result.toString();
    }

    public String validate(ObjectName objectName) {
        return this.validate(new ObjectName[]{objectName});
    }

    public String validate() {
        List<ObjectName> all = Util.toObjectNameList(this.getDomainRootProxy().getQueryMgr().queryAll());
        return this.validate(CollectionUtil.toArray(all, ObjectName.class));
    }

    public String getHierarchy() {
        try {
            ParentChildren pc = ParentChildren.hierarchy(this.getDomainRootProxy());
            List<String> lines = pc.toLines(false);
            return StringUtil.toLines(lines);
        }
        catch (Exception e) {
            return "";
        }
    }
}

