/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm.statistics;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.MethodInvoker;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.j2ee.statistics.Statistic;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class JVMStatsImpl
implements MonitorContract {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    Logger logger;
    @Inject(optional=true)
    MonitoringService monitoringService = null;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JVMStatsImpl.class);
    private final String name = "jvm";

    public String getName() {
        return "jvm";
    }

    public ActionReport process(ActionReport report, String filter) {
        String level;
        if (this.monitoringService != null && (level = this.monitoringService.getMonitoringLevel("jvm")) != null && level.equals("OFF")) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("level.off", "Monitoring level for jvm is off"));
            return report;
        }
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry is null"));
            return report;
        }
        TreeNode serverNode = this.mrdr.get("server");
        if (serverNode == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry server node is null"));
            return report;
        }
        return this.v2JVM(report, serverNode);
    }

    private ActionReport heapMemory(ActionReport report, TreeNode serverNode) {
        long init = 0L;
        long used = 0L;
        long committed = 0L;
        long max = 0L;
        MethodInvoker tn = (MethodInvoker)serverNode.getNode("jvm").getNode("committedHeapSize");
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("JVMStatsImpl: tn name = " + tn.getName());
            this.logger.finest("JVMStatsImpl: tn class name = " + tn.getClass().getName());
            this.logger.finest("JVMStatsImpl: tn value = " + tn.getValue());
            this.logger.finest("JVMStatsImpl: tn value class name = " + tn.getValue().getClass().getName());
            this.logger.finest("JVMStatsImpl: tn instance = " + tn.getInstance());
            this.logger.finest("JVMStatsImpl: tn instance class name = " + tn.getInstance().getClass().getName());
        }
        MemoryUsage mu = (MemoryUsage)tn.getInstance();
        String displayFormat = "%1$-10s %2$-10s %3$-10s %4$-10s";
        report.setMessage(String.format(displayFormat, mu.getInit(), mu.getUsed(), mu.getCommitted(), mu.getMax()));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    private ActionReport nonHeapMemory(ActionReport report, TreeNode serverNode) {
        long init = 0L;
        long used = 0L;
        long committed = 0L;
        long max = 0L;
        MethodInvoker tn = (MethodInvoker)serverNode.getNode("jvm").getNode("non-heap-memory");
        MemoryUsage mu = (MemoryUsage)tn.getInstance();
        String displayFormat = "%1$-10s %2$-10s %3$-10s %4$-10s";
        report.setMessage(String.format(displayFormat, mu.getInit(), mu.getUsed(), mu.getCommitted(), mu.getMax()));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    private long getFirstTreeNodeAsLong(TreeNode parent, String name) {
        TreeNode node;
        Object val;
        long ret = 0L;
        List nodes = parent.getNodes(name);
        if (!nodes.isEmpty() && (val = (node = (TreeNode)nodes.get(0)).getValue()) != null) {
            ret = (Long)val;
        }
        return ret;
    }

    private ActionReport v2JVM(ActionReport report, TreeNode serverNode) {
        long uptime = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.runtime.uptime");
        long min = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.initNonHeapSize");
        long max = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.maxHeapSize");
        long count = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.committedHeapSize");
        String displayFormat = "%1$-25s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s";
        report.setMessage(String.format(displayFormat, uptime, min += this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.initHeapSize"), max += this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.maxNonHeapSize"), 0, 0, count += this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.committedNonHeapSize")));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    public Statistic[] getStatistics() {
        return null;
    }

    public String[] getStatisticNames() {
        return null;
    }

    public Statistic getStatistic(String statisticName) {
        return null;
    }
}

