/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.amx.MBeanListener;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderInfo;
import org.glassfish.external.probe.provider.StatsProviderManagerDelegate;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.glassfish.external.statistics.impl.StatsImpl;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scoped(value=Singleton.class)
public class StatsProviderManagerDelegateImpl
extends MBeanListener.CallbackImpl
implements StatsProviderManagerDelegate {
    protected ProbeClientMediator pcm;
    MonitoringService monitoringService = null;
    private final MonitoringRuntimeDataRegistry mrdr;
    private final ProbeRegistry probeRegistry;
    private final Domain domain;
    private final TreeNode serverNode;
    private static final ObjectName MONITORING_ROOT = AMXGlassfish.DEFAULT.monitoringRoot();
    static final ObjectName MONITORING_SERVER = AMXGlassfish.DEFAULT.serverMon(AMXGlassfish.DEFAULT.dasName());
    private static final String DOMAIN = MONITORING_SERVER.getDomain();
    private static final String PP = MONITORING_SERVER.getKeyProperty("pp");
    private static final String TYPE = MONITORING_SERVER.getKeyProperty("type");
    private static final String NAME = MONITORING_SERVER.getKeyProperty("name");
    private static final String PARENT_PATH = PP + "/" + TYPE + "[" + NAME + "]";
    private boolean AMXReady = false;
    private StatsProviderRegistry statsProviderRegistry;
    private static final Logger logger = LogDomains.getLogger(StatsProviderManagerDelegateImpl.class, (String)"javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(StatsProviderManagerDelegateImpl.class);
    boolean ddebug = false;

    StatsProviderManagerDelegateImpl(ProbeClientMediator pcm, ProbeRegistry probeRegistry, MonitoringRuntimeDataRegistry mrdr, Domain domain, MonitoringService monitoringService) {
        this.pcm = pcm;
        this.mrdr = mrdr;
        this.domain = domain;
        this.monitoringService = monitoringService;
        this.probeRegistry = probeRegistry;
        this.serverNode = this.constructServerPP();
        this.statsProviderRegistry = new StatsProviderRegistry(mrdr);
    }

    public void register(String configElement, PluginPoint pp, String subTreePath, Object statsProvider) {
        StatsProviderInfo spInfo = new StatsProviderInfo(configElement, pp, subTreePath, statsProvider);
        this.register(spInfo);
    }

    public void register(StatsProviderInfo spInfo) {
        StatsProviderRegistry.StatsProviderRegistryElement spre;
        String configElement = spInfo.getConfigElement();
        Object statsProvider = spInfo.getStatsProvider();
        this.printd("registering a statsProvider ");
        if (this.getMonitoringEnabled() && this.getEnabledValue(configElement)) {
            this.printd(" enabled is true ");
            spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
            if (spre == null) {
                this.statsProviderRegistry.registerStatsProvider(spInfo);
                spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
            }
            if (spre.isEnableAllowed(this.getMonitoringLevel(configElement))) {
                this.enableStatsProvider(spre);
            }
        } else {
            this.printd(" enabled is false ");
            this.statsProviderRegistry.registerStatsProvider(spInfo);
            spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
        }
        this.printd(spre.toString());
        this.printd("=========================================================");
    }

    public void unregister(Object statsProvider) {
        try {
            Collection<ProbeClientMethodHandle> handles;
            List nodeList;
            StatsProviderRegistry.StatsProviderRegistryElement spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
            if (spre == null) {
                logger.log(Level.INFO, localStrings.getLocalString("invalidStatsProvider", "Invalid statsProvider (very likely a duplicate request), cannot unregister : {0}", new Object[]{statsProvider.getClass().getName()}));
                return;
            }
            String parentNodePath = spre.getParentTreeNodePath();
            List<String> childNodeNames = spre.getChildTreeNodeNames();
            TreeNode rootNode = this.mrdr.get("server");
            if (rootNode != null && parentNodePath != null && (nodeList = rootNode.getNodes(parentNodePath, false, true)).size() > 0) {
                TreeNode parentNode = (TreeNode)nodeList.get(0);
                Collection childNodes = parentNode.getChildNodes();
                for (TreeNode childNode : childNodes) {
                    if (!childNodeNames.contains(childNode.getName())) continue;
                    parentNode.removeChild(childNode);
                }
                if (!parentNode.hasChildNodes()) {
                    this.removeParentNode(parentNode);
                }
            }
            if ((handles = spre.getHandles()) != null) {
                for (ProbeClientMethodHandle handle : handles) {
                    handle.disable();
                }
            }
            if (spre.getManagedObjectManager() != null) {
                this.unregisterGmbal(spre);
            }
            this.statsProviderRegistry.unregisterStatsProvider(statsProvider);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void removeParentNode(TreeNode parentNode) {
        TreeNode superParentNode = parentNode.getParent();
        if (superParentNode != null) {
            superParentNode.removeChild(parentNode);
            if (!superParentNode.hasChildNodes()) {
                this.removeParentNode(superParentNode);
            }
        }
    }

    public void updateAllStatsProviders() {
        for (String configElement : this.statsProviderRegistry.getConfigElementList()) {
            List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
            boolean isConfigEnabled = this.getEnabledValue(configElement);
            if (!isConfigEnabled) continue;
            for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
                boolean isEnableAllowed = spre.isEnableAllowed(this.getMonitoringLevel(configElement));
                if (!isEnableAllowed) continue;
                this.enableStatsProvider(spre);
            }
        }
    }

    public void disableAllStatsProviders() {
        for (String configElement : this.statsProviderRegistry.getConfigElementList()) {
            List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
            for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
                if (!spre.isEnabled) continue;
                this.disableStatsProvider(spre);
            }
        }
    }

    public void enableStatsProviders(String configElement) {
        if (!this.getMonitoringEnabled()) {
            return;
        }
        String configLevel = this.getMonitoringLevel(configElement);
        this.printd("Enabling all the statsProviders for - " + configElement);
        List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
            boolean isEnableAllowed = spre.isEnableAllowed(configLevel);
            if (!spre.isEnabled()) {
                if (!isEnableAllowed) continue;
                this.enableStatsProvider(spre);
                continue;
            }
            if (isEnableAllowed) continue;
            this.disableStatsProvider(spre);
        }
    }

    public void disableStatsProviders(String configElement) {
        this.printd("Disabling all the statsProviders for - " + configElement);
        List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
            if (!spre.isEnabled()) continue;
            this.disableStatsProvider(spre);
        }
    }

    private boolean getMonitoringEnabled() {
        return Boolean.parseBoolean(this.monitoringService.getMonitoringEnabled());
    }

    private void enableStatsProvider(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        String subTreePath;
        Object statsProvider = spre.getStatsProvider();
        this.printd("Enabling the statsProvider - " + statsProvider.getClass().getName());
        if (spre.getParentTreeNodePath() == null) {
            PluginPoint pp = spre.getPluginPoint();
            subTreePath = spre.getSubTreePath();
            TreeNode ppNode = this.getPluginPointNode(pp, this.serverNode);
            TreeNode parentNode = this.createSubTree(ppNode, subTreePath);
            List<String> childNodeNames = this.createTreeForStatsProvider(parentNode, statsProvider);
            spre.setParentTreeNodePath(parentNode.getCompletePathName());
            spre.setChildNodeNames(childNodeNames);
        } else {
            this.updateTreeNodes(spre, true);
        }
        this.resetStatistics(spre);
        if (spre.getHandles() == null) {
            Collection<ProbeClientMethodHandle> handles = this.registerStatsProviderToFlashlight(statsProvider);
            spre.setHandles(handles);
        } else {
            for (ProbeClientMethodHandle handle : spre.getHandles()) {
                if (handle.isEnabled()) continue;
                handle.enable();
            }
        }
        ManagedObjectManager mom = null;
        if (this.AMXReady && this.getMbeanEnabledValue()) {
            subTreePath = spre.getSubTreePath();
            mom = this.registerGmbal(statsProvider, subTreePath);
            spre.setManagedObjectManager(mom);
        }
        spre.setEnabled(true);
    }

    private void disableStatsProvider(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        this.printd("Disabling the statsProvider - " + spre.getStatsProvider().getClass().getName());
        this.updateTreeNodes(spre, false);
        for (ProbeClientMethodHandle handle : spre.getHandles()) {
            if (!handle.isEnabled()) continue;
            handle.disable();
        }
        this.unregisterGmbal(spre);
        spre.setEnabled(false);
    }

    public void registerAllGmbal() {
        this.printd("Registering all the statsProviders whose enabled flag is 'on' with Gmbal");
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
            if (!spre.isEnabled()) continue;
            ManagedObjectManager mom = this.registerGmbal(spre.getStatsProvider(), spre.getMBeanName());
            spre.setManagedObjectManager(mom);
        }
    }

    public void unregisterAllGmbal() {
        this.printd("Unregistering all the statsProviders whose enabled flag is 'off' with Gmbal");
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
            if (!spre.isEnabled()) continue;
            this.unregisterGmbal(spre);
        }
    }

    private void updateTreeNodes(StatsProviderRegistry.StatsProviderRegistryElement spre, boolean enable) {
        String parentNodePath = spre.getParentTreeNodePath();
        List<String> childNodeNames = spre.getChildTreeNodeNames();
        TreeNode rootNode = this.mrdr.get("server");
        if (rootNode != null) {
            List nodeList = rootNode.getNodes(parentNodePath, false, true);
            TreeNode parentNode = (TreeNode)nodeList.get(0);
            Collection childNodes = parentNode.getChildNodes();
            boolean hasUpdatedNode = false;
            for (TreeNode childNode : childNodes) {
                if (!childNodeNames.contains(childNode.getName()) || childNode.isEnabled() == enable) continue;
                childNode.setEnabled(enable);
                hasUpdatedNode = true;
            }
            if (!hasUpdatedNode) {
                return;
            }
            if (enable) {
                this.enableTreeNode(parentNode);
            } else {
                this.disableTreeNode(parentNode);
            }
        }
    }

    private void enableTreeNode(TreeNode treeNode) {
        if (!treeNode.isEnabled()) {
            treeNode.setEnabled(true);
            if (treeNode.getParent() != null) {
                this.enableTreeNode(treeNode.getParent());
            }
        }
    }

    private void disableTreeNode(TreeNode treeNode) {
        if (treeNode.isEnabled()) {
            boolean isAnyChildEnabled = false;
            Collection childNodes = treeNode.getChildNodes();
            if (childNodes != null) {
                for (TreeNode childNode : childNodes) {
                    if (!childNode.isEnabled()) continue;
                    isAnyChildEnabled = true;
                    break;
                }
            }
            if (!isAnyChildEnabled) {
                treeNode.setEnabled(false);
                if (treeNode.getParent() != null) {
                    this.disableTreeNode(treeNode.getParent());
                }
            }
        }
    }

    private void resetStatistics(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        if (spre.getResetMethod() == null) {
            String parentNodePath = spre.getParentTreeNodePath();
            List<String> childNodeNames = spre.getChildTreeNodeNames();
            String statsProviderName = spre.getStatsProvider().getClass().getName();
            this.resetChildNodeStatistics(parentNodePath, childNodeNames, statsProviderName);
        } else {
            this.invokeStatsProviderResetMethod(spre.getResetMethod(), spre.getStatsProvider());
        }
    }

    private void resetChildNodeStatistics(String parentNodePath, List<String> childNodeNames, String statsProviderName) {
        TreeNode rootNode = this.mrdr.get("server");
        if (rootNode != null) {
            List nodeList = rootNode.getNodes(parentNodePath, false, true);
            if (nodeList.size() > 0) {
                TreeNode parentNode = (TreeNode)nodeList.get(0);
                Collection childNodes = parentNode.getChildNodes();
                for (TreeNode childNode : childNodes) {
                    if (!childNodeNames.contains(childNode.getName())) continue;
                    this.invokeStatisticResetMethod(childNode.getValue());
                }
            } else {
                logger.log(Level.WARNING, localStrings.getLocalString("nodeNotFound", "Cannot find node " + parentNodePath + " for statsProvider " + statsProviderName, new Object[]{parentNodePath, statsProviderName}));
            }
        }
    }

    private void invokeStatisticResetMethod(Object value) {
        if (value instanceof Statistic) {
            if (Proxy.isProxyClass(value.getClass())) {
                ((StatisticImpl)Proxy.getInvocationHandler(value)).reset();
            } else {
                ((StatisticImpl)value).reset();
            }
        } else if (value instanceof StatsImpl) {
            ((StatsImpl)value).reset();
        }
    }

    private void invokeStatsProviderResetMethod(Method m, Object statsProvider) {
        if (m != null) {
            try {
                m.invoke(statsProvider, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private List<String> createTreeForStatsProvider(TreeNode parentNode, Object statsProvider) {
        ArrayList<String> childNodeNames = new ArrayList<String>();
        for (Method m : statsProvider.getClass().getMethods()) {
            String methodNameLower;
            ManagedAttribute ma = m.getAnnotation(ManagedAttribute.class);
            Reset resetMeth = m.getAnnotation(Reset.class);
            if (resetMeth != null) {
                StatsProviderRegistry.StatsProviderRegistryElement spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
                spre.setResetMethod(m);
            }
            if (ma == null) continue;
            String methodName = m.getName();
            String id = ma.id();
            if ((id == null || id.isEmpty()) && (methodNameLower = methodName.toLowerCase()).startsWith("get") && methodNameLower.length() > 3) {
                id = methodNameLower.substring(3);
            }
            TreeNode attrNode = TreeNodeFactory.createMethodInvoker(id, statsProvider, id, m);
            parentNode.addChild(attrNode);
            childNodeNames.add(attrNode.getName());
        }
        return childNodeNames;
    }

    private Collection<ProbeClientMethodHandle> registerStatsProviderToFlashlight(Object statsProvider) {
        Collection handles = null;
        try {
            handles = this.pcm.registerListener(statsProvider);
        }
        catch (Exception e) {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, "Flashlight listener registration failed", e);
        }
        return handles;
    }

    private TreeNode createSubTree(TreeNode parent, String subTreePath) {
        StringTokenizer st = new StringTokenizer(subTreePath, "/");
        TreeNode parentNode = parent;
        this.enableTreeNode(parentNode);
        while (st.hasMoreTokens()) {
            TreeNode subTreeNode;
            parentNode = subTreeNode = this.createSubTreeNode(parentNode, st.nextToken());
        }
        return parentNode;
    }

    private TreeNode createSubTreeNode(TreeNode parent, String child) {
        TreeNode childNode = parent.getChild(child);
        if (childNode == null) {
            childNode = TreeNodeFactory.createTreeNode(child, null, child);
            parent.addChild(childNode);
        } else {
            this.enableTreeNode(childNode);
        }
        return childNode;
    }

    public boolean hasListeners(String probeStr) {
        boolean hasListeners = false;
        FlashlightProbe probe = this.probeRegistry.getProbe(probeStr);
        if (probe != null) {
            return probe.isEnabled();
        }
        return hasListeners;
    }

    public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
        super.mbeanRegistered(objectName, listener);
        this.AMXReady = true;
        this.statsProviderRegistry.setAMXReady(true);
        if (this.getMbeanEnabledValue()) {
            for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
                if (!spre.isEnabled()) continue;
                ManagedObjectManager mom = this.registerGmbal(spre.getStatsProvider(), spre.getMBeanName());
                spre.setManagedObjectManager(mom);
            }
        }
    }

    StatsProviderRegistry getStatsProviderRegistry() {
        return this.statsProviderRegistry;
    }

    private ManagedObjectManager registerGmbal(Object statsProvider, String mbeanName) {
        ManagedObjectManager mom;
        block6: {
            mom = null;
            if (this.isManagedObject(statsProvider)) {
                try {
                    mom = ManagedObjectManagerFactory.createFederated((ObjectName)MONITORING_SERVER);
                    if (mom == null) break block6;
                    mom.stripPackagePrefix();
                    if (mbeanName != null && !mbeanName.isEmpty()) {
                        if (mbeanName.indexOf(92) > 0) {
                            mbeanName = StringUtils.removeChar((String)mbeanName, (char)'\\');
                        }
                        mom.createRoot(statsProvider, mbeanName);
                        break block6;
                    }
                    mom.createRoot(statsProvider);
                }
                catch (Exception e) {
                    mom = null;
                    Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, "Gmbal registration failed", e);
                }
            } else {
                String spName = statsProvider.getClass().getName();
                Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.INFO, localStrings.getLocalString("notaManagedObject", spName + " is not a ManagedObject and will not be registered with Gmbal to create an MBean", new Object[]{spName}));
            }
        }
        return mom;
    }

    private boolean isManagedObject(Object statsProvider) {
        boolean isManagedObject = true;
        ManagedObject mo = statsProvider.getClass().getAnnotation(ManagedObject.class);
        if (mo == null) {
            isManagedObject = false;
        }
        return isManagedObject;
    }

    private void unregisterGmbal(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        ManagedObjectManager mom = spre.getManagedObjectManager();
        if (mom != null) {
            mom.unregister(spre.getStatsProvider());
            try {
                mom.close();
            }
            catch (IOException ioe) {
                Logger.getLogger(StatsProviderRegistry.class.getName()).log(Level.SEVERE, "Gmbal unregister failed", ioe);
            }
            spre.setManagedObjectManager(null);
        }
    }

    private TreeNode getPluginPointNode(PluginPoint pp, TreeNode serverNode) {
        if (pp.getName().equals(serverNode.getName())) {
            return serverNode;
        }
        String subTreePath = pp.getPath();
        if (subTreePath.startsWith("server")) {
            subTreePath = subTreePath.substring(subTreePath.indexOf("/") + 1, subTreePath.length());
        }
        return this.createSubTree(serverNode, subTreePath);
    }

    private TreeNode constructServerPP() {
        TreeNode srvrNode = this.mrdr.get("server");
        if (srvrNode != null) {
            return srvrNode;
        }
        Server srvr = null;
        List ls = this.domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        srvrNode = TreeNodeFactory.createTreeNode("server", null, "server");
        srvrNode.setEnabled(false);
        this.mrdr.add("server", srvrNode);
        return srvrNode;
    }

    private boolean getEnabledValue(String configElement) {
        boolean enabled = true;
        String level = this.getMonitoringLevel(configElement);
        if (level != null) {
            if (level.equals("OFF")) {
                enabled = false;
            }
        } else {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.WARNING, "module-monitoring-level or container-monitoring config element for " + configElement + " does not exist.");
        }
        return enabled;
    }

    private String getMonitoringLevel(String configElement) {
        return this.monitoringService.getMonitoringLevel(configElement);
    }

    private boolean getMbeanEnabledValue() {
        return Boolean.parseBoolean(this.monitoringService.getMbeanEnabled());
    }

    public boolean isStatsProviderRegistered(Object statsProvider, String subTreePath) {
        boolean isStatsProviderRegistered = false;
        Collection<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getSpreList();
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
            if (!spre.getStatsProvider().equals(statsProvider) || !spre.getMBeanName().equals(statsProvider)) continue;
            isStatsProviderRegistered = true;
        }
        return isStatsProviderRegistered;
    }

    public ObjectName getObjectName(Object statsProvider, String subTreePath) {
        String typeValue = this.getTypeValue(statsProvider);
        String nameValue = this.getNameValue(subTreePath);
        return AMXGlassfish.DEFAULT.newObjectName(PARENT_PATH, typeValue, nameValue);
    }

    public String getTypeValue(Object statsProvider) {
        return statsProvider.getClass().getSimpleName();
    }

    public String getNameValue(String subTreePath) {
        return subTreePath;
    }

    private void printd(String pstring) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, pstring);
        }
    }
}

