/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="change-master-password")
@Scoped(value=PerLookup.class)
public class ChangeMasterPasswordCommand
extends LocalDomainCommand {
    private String savemp = "savemasterpassword";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeMasterPasswordCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet opts = new LinkedHashSet();
        ChangeMasterPasswordCommand.addOption(opts, (String)this.savemp, (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        ChangeMasterPasswordCommand.addOption(opts, (String)"domaindir", (char)'\u0000', (String)"STRING", (boolean)false, null);
        ChangeMasterPasswordCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandName = "domain_name";
        this.operandMin = 0;
        this.operandMax = 1;
        super.processProgramOptions();
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            if (super.isRunning(super.getAdminPort(super.getDomainXml()))) {
                throw new CommandException(strings.get("domain.is.running", new Object[]{this.domainName, this.domainRootDir}));
            }
            DomainConfig domainConfig = new DomainConfig(this.domainName, this.domainsDir.getAbsolutePath());
            PEDomainsManager manager = new PEDomainsManager();
            String mp = super.readFromMasterPasswordFile();
            if (mp == null && (mp = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD")) == null) {
                mp = super.readPassword(strings.get("current.mp"));
            }
            if (mp == null) {
                throw new CommandException(strings.get("no.console"));
            }
            if (!super.verifyMasterPassword(mp)) {
                throw new CommandException(strings.get("incorrect.mp"));
            }
            ValidOption nmpo = new ValidOption("New_Master_Password", "PASSWORD", 1, null);
            String nmp = super.getPassword(nmpo, null, true);
            if (nmp == null) {
                throw new CommandException(strings.get("no.console"));
            }
            domainConfig.put((Object)"domain.masterPassword", (Object)mp);
            domainConfig.put((Object)"domain.newMasterPassword", (Object)nmp);
            domainConfig.put((Object)"domain.saveMasterPassword", (Object)this.saveIt());
            manager.changeMasterPassword(domainConfig);
            return 0;
        }
        catch (Exception e) {
            throw new CommandException((Throwable)e);
        }
    }

    private Boolean saveIt() {
        String value = super.getOption(this.savemp);
        if (value == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(value);
    }
}

