/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.EARBasedPersistenceHelper;
import com.sun.enterprise.deployment.archivist.PersistenceArchivist;
import com.sun.enterprise.deployment.util.XModuleType;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ACCPersistenceArchivist
extends PersistenceArchivist {
    @Inject
    private ProcessEnvironment env;
    @Inject
    private ArchiveFactory archiveFactory;

    @Override
    public boolean supportsModuleType(XModuleType moduleType) {
        return XModuleType.CAR == moduleType && this.env.getProcessType() == ProcessEnvironment.ProcessType.ACC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object open(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, "ACCPersistencerArchivist", "readPersistenceDeploymentDescriptors", "archive = {0}", archive.getURI());
        }
        HashMap<String, ReadableArchive> candidatePersistenceArchives = new HashMap<String, ReadableArchive>();
        if (!(descriptor instanceof ApplicationClientDescriptor)) {
            return null;
        }
        ApplicationClientDescriptor acDescr = (ApplicationClientDescriptor)ApplicationClientDescriptor.class.cast(descriptor);
        try {
            candidatePersistenceArchives.put(archive.getURI().toASCIIString(), archive);
            Manifest mf = archive.getManifest();
            if (this.isDeployed(mf)) {
                if (!this.isStandAlone(mf)) {
                    this.addOtherDeployedScanTargets(archive, mf, candidatePersistenceArchives);
                }
            } else if (!this.isStandAlone(acDescr)) {
                this.addOtherNondeployedScanTargets(archive, acDescr, candidatePersistenceArchives);
            }
            for (Map.Entry pathToArchiveEntry : candidatePersistenceArchives.entrySet()) {
                this.readPersistenceDeploymentDescriptor(main, (ReadableArchive)pathToArchiveEntry.getValue(), (String)pathToArchiveEntry.getKey(), descriptor);
            }
        }
        finally {
            for (Map.Entry pathToArchiveEntry : candidatePersistenceArchives.entrySet()) {
            }
        }
        return null;
    }

    private boolean isStandAlone(Manifest mf) {
        Attributes mainAttrs = mf.getMainAttributes();
        String relativePathToGroupFacade = mainAttrs.getValue(AppClientArchivist.GLASSFISH_GROUP_FACADE);
        return relativePathToGroupFacade == null;
    }

    private boolean isStandAlone(ApplicationClientDescriptor ac) {
        return ac.getApplication() == null || ac.isStandalone();
    }

    private boolean isDeployed(Manifest mf) throws IOException {
        Attributes mainAttrs = mf.getMainAttributes();
        String gfClient = mainAttrs.getValue(AppClientArchivist.GLASSFISH_APPCLIENT);
        return gfClient != null;
    }

    private void addOtherDeployedScanTargets(ReadableArchive archive, Manifest mf, Map<String, ReadableArchive> candidates) throws IOException {
        Attributes mainAttrs = mf.getMainAttributes();
        String otherPUScanTargets = mainAttrs.getValue(AppClientArchivist.GLASSFISH_CLIENT_PU_SCAN_TARGETS_NAME);
        this.addScanTargetsFromURIList(archive, otherPUScanTargets, candidates);
    }

    private void addOtherNondeployedScanTargets(ReadableArchive clientArchive, ApplicationClientDescriptor acDescr, Map<String, ReadableArchive> candidates) {
        ReadableArchive earArchive = clientArchive.getParentArchive();
        EARBasedPersistenceHelper.addLibraryAndTopLevelCandidates(earArchive, acDescr.getApplication(), true, candidates);
    }

    private void addScanTargetsFromURIList(ReadableArchive archive, String relativeURIList, Map<String, ReadableArchive> candidates) throws IOException {
        String[] relativeURIs;
        if (relativeURIList == null) {
            return;
        }
        for (String uriText : relativeURIs = relativeURIList.split(" ")) {
            URI scanTargetURI = archive.getURI().resolve(uriText);
            candidates.put(uriText, this.archiveFactory.openArchive(scanTargetURI));
        }
    }

    private class AppClientPURootScanner
    extends PersistenceArchivist.SubArchivePURootScanner {
        private final ReadableArchive clientArchive;

        private AppClientPURootScanner(ReadableArchive clientArchive) {
            this.clientArchive = clientArchive;
        }

        ReadableArchive getSubArchiveToScan(ReadableArchive parentArchive) {
            return this.clientArchive;
        }

        String getPathOfSubArchiveToScan() {
            return null;
        }
    }
}

