/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.security.auth.Subject;
import org.glassfish.security.common.Group;
import org.jvnet.hk2.annotations.Service;
import sun.security.x509.X500Name;

@Service
public final class CertificateRealm
extends IASRealm {
    public static final String AUTH_TYPE = "certificate";
    private Vector defaultGroups = new Vector();

    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String[] groups = this.addAssignGroups(null);
        if (groups != null && groups.length > 0) {
            for (String gp : groups) {
                this.defaultGroups.add(gp);
            }
        }
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames(String username) throws NoSuchUserException, InvalidOperationException {
        return this.defaultGroups.elements();
    }

    public String getJAASContext() {
        _logger.warning("certrealm.nojaas");
        return null;
    }

    public void authenticate(Subject subject, X500Name x500name) {
        String name = x500name.getName();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Certificate realm setting up security context for: " + name);
        }
        if (this.defaultGroups != null) {
            Set<Principal> principalSet = subject.getPrincipals();
            Enumeration e = this.defaultGroups.elements();
            while (e.hasMoreElements()) {
                principalSet.add((Principal)new Group((String)e.nextElement()));
            }
        }
        AppServSecurityContext secContext = (AppServSecurityContext)Util.getDefaultHabitat().getByContract(AppServSecurityContext.class);
        AppServSecurityContext securityContext = secContext.newInstance(name, subject);
        securityContext.setCurrentSecurityContext(securityContext);
    }
}

