/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.annotation.handlers.AdministeredObjectHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.resource.spi.Activation;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.AdministeredObject;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionDefinitions;
import javax.resource.spi.Connector;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConfigPropertyHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractHandler.class);

    public Class<? extends Annotation> getAnnotationType() {
        return ConfigProperty.class;
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        ConfigProperty configProperty = (ConfigProperty)element.getAnnotation();
        if (aeHandler instanceof RarBundleContext) {
            RarBundleContext rbc = (RarBundleContext)aeHandler;
            ConnectorDescriptor desc = rbc.getDescriptor();
            String defaultValue = configProperty.defaultValue();
            String[] description = configProperty.description();
            boolean ignore = configProperty.ignore();
            boolean supportsDynamicUpdates = configProperty.supportsDynamicUpdates();
            boolean confidential = configProperty.confidential();
            Class type = configProperty.type();
            if (element.getElementType().equals((Object)ElementType.METHOD)) {
                Method m = (Method)element.getAnnotatedElement();
                Class<?>[] parameters = m.getParameterTypes();
                if (parameters != null) {
                    if (parameters.length != 1) {
                        return this.getFailureResult(element, "more than one parameter for JavaBean setter method : [" + m.getName() + " ] ", true);
                    }
                } else {
                    return this.getFailureResult(element, "no parameters for JavaBean setter method : [" + m.getName() + " ] ", true);
                }
                Class propertyType = parameters[0];
                if (type.equals(Object.class)) {
                    type = propertyType;
                } else if (!propertyType.isAssignableFrom(type)) {
                    if (type.isPrimitive()) {
                        type = ConfigPropertyHandler.getWrapperClass(type.getName());
                    } else if (propertyType.isPrimitive()) {
                        propertyType = ConfigPropertyHandler.getWrapperClass(propertyType.getName());
                    }
                    if (!propertyType.isAssignableFrom(type)) {
                        return this.getFailureResult(element, "annotation type [" + type + "] and property-type" + " [" + propertyType + "] " + "are not assignment compatible", true);
                    }
                }
                String firstDesc = "";
                if (description.length > 0) {
                    firstDesc = description[0];
                }
                ConnectorConfigProperty ep = this.getConfigProperty(defaultValue, firstDesc, ignore, supportsDynamicUpdates, confidential, type, m.getName().substring(3));
                Class<?> declaringClass = m.getDeclaringClass();
                this.handleConfigPropertyAnnotation(element, desc, ep, declaringClass);
            } else if (element.getElementType().equals((Object)ElementType.FIELD)) {
                Field f = (Field)element.getAnnotatedElement();
                Class<?> c = f.getDeclaringClass();
                Class returnType = f.getType();
                if (type.equals(Object.class)) {
                    type = returnType;
                } else if (!returnType.isAssignableFrom(type)) {
                    return this.getFailureResult(element, "annotation type [" + type + "] " + "and return-type [" + returnType + "] " + "are not assignment compatible", true);
                }
                if (defaultValue == null || defaultValue.equals("")) {
                    defaultValue = this.deriveDefaultValueOfField(f);
                }
                String firstDesc = "";
                if (description.length > 0) {
                    firstDesc = description[0];
                }
                ConnectorConfigProperty ep = this.getConfigProperty(defaultValue, firstDesc, ignore, supportsDynamicUpdates, confidential, type, f.getName());
                this.handleConfigPropertyAnnotation(element, desc, ep, c);
            }
        } else {
            return this.getFailureResult(element, "not a rar bundle context", true);
        }
        return this.getDefaultProcessedResult();
    }

    private static Class getWrapperClass(String primitive) {
        if (primitive.equalsIgnoreCase("int")) {
            return Integer.class;
        }
        if (primitive.equalsIgnoreCase("long")) {
            return Long.class;
        }
        if (primitive.equalsIgnoreCase("short")) {
            return Short.class;
        }
        if (primitive.equalsIgnoreCase("char")) {
            return Character.class;
        }
        if (primitive.equalsIgnoreCase("byte")) {
            return Byte.class;
        }
        if (primitive.equalsIgnoreCase("boolean")) {
            return Boolean.class;
        }
        if (primitive.equalsIgnoreCase("float")) {
            return Float.class;
        }
        if (primitive.equalsIgnoreCase("double")) {
            return Double.class;
        }
        throw new IllegalArgumentException("Could not determine Wrapper class for primitive type [" + primitive + "]");
    }

    private String deriveDefaultValueOfField(Field f) {
        Class<?> declaringClass = f.getDeclaringClass();
        String fieldName = f.getName();
        String value = null;
        try {
            Object o = declaringClass.newInstance();
            String getterMethod = "get" + this.getCamelCasedPropertyName(fieldName);
            if (Boolean.class.isAssignableFrom(f.getType())) {
                getterMethod = "is" + this.getCamelCasedPropertyName(fieldName);
            }
            Method m = declaringClass.getDeclaredMethod(getterMethod, new Class[0]);
            m.setAccessible(true);
            Object result = m.invoke(o, new Object[0]);
            if (result != null) {
                value = result.toString();
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{fieldName, declaringClass.getName(), e.getMessage()};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.configpropertyfieldreadfailure", "failed to read the value of field [{0}] on class [{1}], reason : {2}", args);
            this.logger.log(Level.WARNING, localString, e);
        }
        return value;
    }

    private String getCamelCasedPropertyName(String propertyName) {
        return propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    private ConnectorConfigProperty getConfigProperty(String defaultValue, String description, boolean ignore, boolean supportsDynamicUpdates, boolean confidential, Class type, String propertyName) {
        ConnectorConfigProperty ep = new ConnectorConfigProperty();
        if (!description.equals("")) {
            ep.setDescription(description);
        }
        if (defaultValue != null && !defaultValue.equals("")) {
            ep.setValue(defaultValue);
        }
        ep.setType(type.getName());
        ep.setName(propertyName);
        if (!ep.isSetIgnoreCalled()) {
            ep.setIgnore(ignore);
        }
        if (!ep.isSetConfidentialCalled()) {
            ep.setConfidential(confidential);
        }
        if (!ep.isSupportsDynamicUpdates()) {
            ep.setSupportsDynamicUpdates(supportsDynamicUpdates);
        }
        return ep;
    }

    private void handleConfigPropertyAnnotation(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        if (ResourceAdapter.class.isAssignableFrom(declaringClass)) {
            if (!ConfigPropertyHandler.processConnector(desc, ep, declaringClass)) {
                desc.addConfigPropertyAnnotation(declaringClass.getName(), element);
            }
        } else if (ManagedConnectionFactory.class.isAssignableFrom(declaringClass)) {
            this.processConnectionDefinition(element, desc, ep, declaringClass);
        } else if (ActivationSpec.class.isAssignableFrom(declaringClass) || declaringClass.getAnnotation(Activation.class) != null) {
            this.processActivation(element, desc, ep, declaringClass);
        } else if (declaringClass.getAnnotation(AdministeredObject.class) != null || this.isAdminObjectJavaBean(declaringClass, desc)) {
            this.processAdministeredObject(element, desc, ep, declaringClass);
        }
    }

    private boolean isAdminObjectJavaBean(Class adminObjectClass, ConnectorDescriptor desc) {
        boolean isAdminObject = false;
        Set adminObjects = desc.getAdminObjects();
        for (AdminObject adminObject : adminObjects) {
            if (!adminObject.getAdminObjectClass().equals(adminObjectClass.getName())) continue;
            isAdminObject = true;
            break;
        }
        return isAdminObject;
    }

    private void processAdministeredObject(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        block4: {
            block2: {
                block3: {
                    if (declaringClass.getAnnotation(AdministeredObject.class) == null) break block2;
                    AdministeredObject ao = declaringClass.getAnnotation(AdministeredObject.class);
                    Class[] adminObjectInterfaces = ao.adminObjectInterfaces();
                    if (adminObjectInterfaces.length <= 0) break block3;
                    for (Class adminObjectInterface : adminObjectInterfaces) {
                        this.handleAdministeredObject(element, desc, ep, declaringClass, adminObjectInterface);
                    }
                    break block4;
                }
                List<Class> interfacesList = AdministeredObjectHandler.deriveAdminObjectInterfacesFromHierarchy(declaringClass);
                if (interfacesList.size() != 1) break block4;
                Class intf = interfacesList.get(0);
                this.handleAdministeredObject(element, desc, ep, declaringClass, intf);
                break block4;
            }
            Set adminObjects = desc.getAdminObjects();
            for (AdminObject adminObject : adminObjects) {
                if (!adminObject.getAdminObjectClass().equals(declaringClass.getName()) || ConfigPropertyHandler.isConfigDefined(adminObject.getConfigProperties(), ep)) continue;
                adminObject.addConfigProperty(ep);
            }
        }
    }

    private void handleAdministeredObject(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class adminObjectClass, Class adminObjectIntf) {
        AdminObject adminObject = desc.getAdminObject(adminObjectIntf.getName(), adminObjectClass.getName());
        if (adminObject != null) {
            if (!ConfigPropertyHandler.isConfigDefined(adminObject.getConfigProperties(), ep)) {
                adminObject.addConfigProperty(ep);
            }
        } else {
            this.getFailureResult(element, "could not get adminobject of interface [ " + adminObjectIntf.getName() + " ]" + " and class [ " + adminObjectClass.getName() + " ]", true);
        }
    }

    private void processActivation(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        block3: {
            block2: {
                Class[] messageListeners;
                InboundResourceAdapter ira = desc.getInboundResourceAdapter();
                if (declaringClass.getAnnotation(Activation.class) == null) break block2;
                Activation activation = declaringClass.getAnnotation(Activation.class);
                for (Class clz : messageListeners = activation.messageListeners()) {
                    MessageListener ml;
                    if (!ira.hasMessageListenerType(clz.getName()) || !(ml = ira.getMessageListener(clz.getName())).getActivationSpecClass().equals(declaringClass.getName()) || ConfigPropertyHandler.isConfigDefined(ml.getConfigProperties(), ep)) continue;
                    ml.addConfigProperty(ep);
                }
                break block3;
            }
            if (!desc.getInBoundDefined()) break block3;
            Set messageListeners = desc.getInboundResourceAdapter().getMessageListeners();
            for (MessageListener ml : messageListeners) {
                if (!ml.getActivationSpecClass().equals(declaringClass.getName()) || ConfigPropertyHandler.isConfigDefined(ml.getConfigProperties(), ep)) continue;
                ml.addConfigProperty(ep);
            }
        }
    }

    private void processConnectionDefinition(AnnotationInfo element, ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        if (desc.getOutBoundDefined()) {
            OutboundResourceAdapter ora = desc.getOutboundResourceAdapter();
            Set connectionDefinitions = ora.getConnectionDefs();
            for (Object o : connectionDefinitions) {
                ConnectionDefDescriptor cd = (ConnectionDefDescriptor)o;
                if (!cd.getManagedConnectionFactoryImpl().equals(declaringClass.getName()) || ConfigPropertyHandler.isConfigDefined(cd.getConfigProperties(), ep)) continue;
                cd.addConfigProperty(ep);
            }
        } else {
            this.getFailureResult(element, "Outbound RA is not yet defined", true);
        }
    }

    public static boolean processConnector(ConnectorDescriptor desc, ConnectorConfigProperty ep, Class declaringClass) {
        if (desc.getResourceAdapterClass().equals(declaringClass.getName())) {
            if (!ConfigPropertyHandler.isConfigDefined(desc.getConfigProperties(), ep)) {
                desc.addConfigProperty(ep);
            }
            return true;
        }
        return false;
    }

    private static boolean isConfigDefined(Set configProperties, ConnectorConfigProperty ep) {
        boolean result = false;
        for (Object o : configProperties) {
            ConnectorConfigProperty ddEnvProperty = (ConnectorConfigProperty)o;
            if (!ddEnvProperty.getName().equals(ep.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Connector.class, ConnectionDefinition.class, ConnectionDefinitions.class, Activation.class, AdministeredObject.class};
    }

    private void debug(String s) {
        this.logger.log(Level.INFO, "[ConfigPropertyHandler] " + s);
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            AnnotatedElement o = element.getAnnotatedElement();
            String className = null;
            className = o instanceof Field ? ((Field)o).getDeclaringClass().getName() : ((Method)o).getDeclaringClass().getName();
            Object[] args = new Object[]{element.getAnnotation(), className, message};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.connectorannotationfailure", "failed to handle annotation [ {0} ] on class [ {1} ], reason : {2}", args);
            this.logger.log(Level.WARNING, localString);
        }
        return result;
    }
}

