/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.UserDataConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractWebHandler;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ServletSecurityHandler
extends AbstractWebHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return ServletSecurity.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        WebComponentContext webCompContext;
        HandlerProcessingResult result = null;
        WebComponentContext[] arr$ = webCompContexts;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (result = this.processAnnotation(ainfo, (webCompContext = arr$[i$]).getDescriptor())).getOverallResult() != ResultType.FAILED; ++i$) {
        }
        return result;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.getInvalidAnnotatedElementHandlerResult(ainfo.getProcessingContext().getHandler(), ainfo);
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{WebServlet.class};
    }

    private HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentDescriptor webCompDesc) throws AnnotationProcessorException {
        Class webCompClass = (Class)ainfo.getAnnotatedElement();
        if (!HttpServlet.class.isAssignableFrom(webCompClass)) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.needtoextend", "The Class {0} having annotation {1} need to be a derived class of {2}.", new Object[]{webCompClass.getName(), SecurityConstraint.class.getName(), HttpServlet.class.getName()}));
            return this.getDefaultFailedResult();
        }
        Set<String> urlPatterns = this.getNonOverridedUrlPatterns(webCompDesc);
        if (urlPatterns != null && urlPatterns.size() > 0) {
            HttpMethodConstraint[] httpMethodConstraints;
            WebBundleDescriptor webBundleDesc = webCompDesc.getWebBundleDescriptor();
            ServletSecurity servletSecurityAn = (ServletSecurity)ainfo.getAnnotation();
            HttpConstraint httpConstraint = servletSecurityAn.value();
            SecurityConstraint securityConstraint = ServletSecurityHandler.createSecurityConstraint(webBundleDesc, urlPatterns, httpConstraint.rolesAllowed(), httpConstraint.value(), httpConstraint.transportGuarantee(), null, MetadataSource.ANNOTATION);
            WebResourceCollection webResColl = securityConstraint.getWebResourceCollections().iterator().next();
            for (HttpMethodConstraint httpMethodConstraint : httpMethodConstraints = servletSecurityAn.httpMethodConstraints()) {
                String httpMethod = httpMethodConstraint.value();
                if (httpMethod == null || httpMethod.length() == 0) {
                    return this.getDefaultFailedResult();
                }
                ServletSecurityHandler.createSecurityConstraint(webBundleDesc, urlPatterns, httpMethodConstraint.rolesAllowed(), httpMethodConstraint.emptyRoleSemantic(), httpMethodConstraint.transportGuarantee(), httpMethod, MetadataSource.ANNOTATION);
                webResColl.addHttpMethodOmission(httpMethod);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private Set<String> getNonOverridedUrlPatterns(WebComponentDescriptor webCompDesc) {
        HashSet<String> nonOverridedUrlPatterns = new HashSet<String>(webCompDesc.getUrlPatternsSet());
        WebBundleDescriptor webBundleDesc = webCompDesc.getWebBundleDescriptor();
        Set<String> urlPatterns = webCompDesc.getUrlPatternsSet();
        Enumeration<SecurityConstraint> eSecConstr = webBundleDesc.getSecurityConstraints();
        while (eSecConstr.hasMoreElements()) {
            SecurityConstraint sc = eSecConstr.nextElement();
            for (WebResourceCollection wrc : sc.getWebResourceCollections()) {
                nonOverridedUrlPatterns.removeAll(wrc.getUrlPatterns());
            }
        }
        return nonOverridedUrlPatterns;
    }

    public static SecurityConstraint createSecurityConstraint(WebBundleDescriptor webBundleDesc, Set<String> urlPatterns, String[] rolesAllowed, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, ServletSecurity.TransportGuarantee transportGuarantee, String httpMethod, MetadataSource metadataSource) {
        SecurityConstraintImpl securityConstraint = new SecurityConstraintImpl();
        securityConstraint.setMetadataSource(metadataSource);
        WebResourceCollectionImpl webResourceColl = new WebResourceCollectionImpl();
        securityConstraint.addWebResourceCollection((WebResourceCollection)webResourceColl);
        for (String urlPattern : urlPatterns) {
            webResourceColl.addUrlPattern(urlPattern);
        }
        AuthorizationConstraintImpl ac = null;
        if (rolesAllowed != null && rolesAllowed.length > 0) {
            if (emptyRoleSemantic == ServletSecurity.EmptyRoleSemantic.DENY) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.denyWithRolesAllowed", "One cannot specify DENY with an non-empty array of rolesAllowed in @ServletSecurity / ServletSecurityElement"));
            }
            ac = new AuthorizationConstraintImpl();
            for (String roleName : rolesAllowed) {
                Role role = new Role(roleName);
                webBundleDesc.addRole(role);
                ac.addSecurityRole(roleName);
            }
        } else if (emptyRoleSemantic != ServletSecurity.EmptyRoleSemantic.PERMIT) {
            ac = new AuthorizationConstraintImpl();
        }
        securityConstraint.setAuthorizationConstraint((AuthorizationConstraint)ac);
        UserDataConstraintImpl udc = new UserDataConstraintImpl();
        udc.setTransportGuarantee(transportGuarantee == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? "CONFIDENTIAL" : "NONE");
        securityConstraint.setUserDataConstraint((UserDataConstraint)udc);
        if (httpMethod != null) {
            webResourceColl.addHttpMethod(httpMethod);
        }
        webBundleDesc.addSecurityConstraint((SecurityConstraint)securityConstraint);
        return securityConstraint;
    }
}

