/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.base;

import java.util.Map;
import org.glassfish.admin.amx.annotation.Description;
import org.glassfish.admin.amx.annotation.ManagedAttribute;
import org.glassfish.admin.amx.annotation.ManagedOperation;
import org.glassfish.admin.amx.annotation.Param;
import org.glassfish.admin.amx.base.Singleton;
import org.glassfish.admin.amx.base.Utility;
import org.glassfish.admin.amx.core.AMXMBeanMetadata;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.UNCOMMITTED)
@AMXMBeanMetadata(singleton=true, globalSingleton=true, leaf=true)
public interface ConnectorRuntimeAPIProvider
extends AMXProxy,
Utility,
Singleton {
    public static final String CONN_DEFINITION_PROPS_KEY = "ConnDefinitionPropsKey";
    public static final String PING_CONNECTION_POOL_KEY = "PingConnectionPoolKey";
    public static final String FLUSH_CONNECTION_POOL_KEY = "FlushConnectionPoolKey";
    public static final String VALIDATION_CLASS_NAMES_KEY = "ValidationClassNamesKey";
    public static final String JDBC_DRIVER_CLASS_NAMES_KEY = "JdbcDriverClassNamesKey";
    public static final String VALIDATION_TABLE_NAMES_KEY = "ValidationTableNamesKey";
    public static final String DATABASE_VENDOR_NAMES_KEY = "DatabaseVendorNamesKey";
    public static final String REASON_FAILED_KEY = "ReasonFailedKey";
    public static final String SYSTEM_CONNECTORS_KEY = "SystemConnectorsKey";
    public static final String BUILT_IN_CUSTOM_RESOURCES_KEY = "BuiltInCustomResourcesKey";
    public static final String CONNECTION_DEFINITION_NAMES_KEY = "ConnectionDefinitionNamesKey";
    public static final String MCF_CONFIG_PROPS_KEY = "McfConfigPropsKey";
    public static final String ADMIN_OBJECT_INTERFACES_KEY = "AdminObjectInterfacesKey";
    public static final String ADMIN_OBJECT_CLASSES_KEY = "AdminObjectClassesKey";
    public static final String RESOURCE_ADAPTER_CONFIG_PROPS_KEY = "ResourceAdapterConfigPropsKey";
    public static final String ADMIN_OBJECT_CONFIG_PROPS_KEY = "AdminObjectConfigPropsKey";
    public static final String CONNECTOR_CONFIG_JAVA_BEANS_KEY = "ConnectorConfigJavaBeansKey";
    public static final String ACTIVATION_SPEC_CLASS_KEY = "ActivationSpecClassKey";
    public static final String MESSAGE_LISTENER_TYPES_KEY = "MessageListenerTypesKey";
    public static final String MESSAGE_LISTENER_CONFIG_PROPS_KEY = "MessageListenerConfigPropsKey";
    public static final String MESSAGE_LISTENER_CONFIG_PROP_TYPES_KEY = "MessageListenerConfigPropTypesKey";

    @ManagedOperation(impact=0)
    @Description(value="Returns the connection definition properties and their default values of a datasource class")
    public Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(@Param(name="datasourceClassName") String var1, @Param(name="resType") String var2);

    @ManagedAttribute
    @Description(value="List of built in custom resource factory classes")
    public Map<String, Object> getBuiltInCustomResources();

    @ManagedAttribute
    @Description(value="List of system resource-adapters that allow connector-connection-pool creation")
    public Map<String, Object> getSystemConnectorsAllowingPoolCreation();

    @ManagedOperation(impact=0)
    @Description(value="List of connection definition names for the given resource-adapter")
    public Map<String, Object> getConnectionDefinitionNames(@Param(name="rarName") String var1);

    @ManagedOperation(impact=0)
    @Description(value="get the MCF config properties of the connection definition")
    public Map<String, Object> getMCFConfigProps(@Param(name="rarName") String var1, @Param(name="connectionDefName") String var2);

    @ManagedOperation(impact=0)
    @Description(value="List of administered object interfaces for the given resource-adapter")
    public Map<String, Object> getAdminObjectInterfaceNames(@Param(name="rarName") String var1);

    @ManagedOperation(impact=0)
    @Description(value="List of administered object class names for the given resource-adapter and administered object interface name")
    public Map<String, Object> getAdminObjectClassNames(@Param(name="rarName") String var1, @Param(name="intfName") String var2);

    @ManagedOperation(impact=0)
    @Description(value="List of resource adapter configuration properties of a resource-adapter")
    public Map<String, Object> getResourceAdapterConfigProps(@Param(name="rarName") String var1);

    @ManagedOperation(impact=0)
    @Description(value="List of administered object configuration properties")
    public Map<String, Object> getAdminObjectConfigProps(@Param(name="rarName") String var1, @Param(name="adminObjectIntf") String var2);

    @ManagedOperation(impact=0)
    @Description(value="List of administered object configuration properties")
    public Map<String, Object> getAdminObjectConfigProps(@Param(name="rarName") String var1, @Param(name="adminObjectIntf") String var2, @Param(name="adminObjectClass") String var3);

    @ManagedOperation(impact=0)
    @Description(value="List of java bean properties and their default values for a connection definition")
    public Map<String, Object> getConnectorConfigJavaBeans(@Param(name="rarName") String var1, @Param(name="connectionDefName") String var2, @Param(name="type") String var3);

    @ManagedOperation(impact=0)
    @Description(value="get the activation spec class for the given message-listener type of a resource-adapter")
    public Map<String, Object> getActivationSpecClass(@Param(name="rarName") String var1, @Param(name="messageListenerType") String var2);

    @ManagedOperation(impact=0)
    @Description(value="get message listener types of a resource-adapter")
    public Map<String, Object> getMessageListenerTypes(@Param(name="rarName") String var1);

    @ManagedOperation(impact=0)
    @Description(value="get message listener config properties for the given message-listener-type of a resource-adapter")
    public Map<String, Object> getMessageListenerConfigProps(@Param(name="rarName") String var1, @Param(name="messageListenerType") String var2);

    @ManagedOperation(impact=0)
    @Description(value="get message listener config property types for the given message-listener-type of a resource-adapter")
    public Map<String, Object> getMessageListenerConfigPropTypes(@Param(name="rarName") String var1, @Param(name="messageListenerType") String var2);

    @ManagedOperation(impact=0)
    @Description(value="Flush connection pool by reinitializing all connections established in the pool")
    public Map<String, Object> flushConnectionPool(@Param(name="poolName") String var1);

    @ManagedOperation(impact=0)
    @Description(value="Get Connection validation table names for display in GUI")
    public Map<String, Object> getValidationTableNames(@Param(name="poolName") String var1);

    @ManagedOperation(impact=0)
    @Description(value="Get Jdbc driver implementation class names")
    public Map<String, Object> getJdbcDriverClassNames(@Param(name="dbVendor") String var1, @Param(name="resType") String var2);

    @ManagedOperation(impact=0)
    @Description(value="Ping Connection Pool and return status")
    public Map<String, Object> pingJDBCConnectionPool(String var1);

    @ManagedOperation(impact=0)
    @Description(value="Get connection validation class names for custom validation")
    public Map<String, Object> getValidationClassNames(String var1);

    @ManagedAttribute
    @Description(value="Get database vendor names")
    public Map<String, Object> getDatabaseVendorNames();
}

