/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_create-instance-filesystem")
@Scoped(value=PerLookup.class)
public class CreateLocalInstanceFilesystemCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true)
    private String instanceName0;
    String DASHost;
    int DASPort = -1;
    String DASProtocol;
    boolean dasIsSecure;
    public static final String K_DAS_HOST = "agent.das.host";
    public static final String K_DAS_PROTOCOL = "agent.das.protocol";
    public static final String K_DAS_PORT = "agent.das.port";
    public static final String K_DAS_IS_SECURE = "agent.das.isSecure";
    public static final String K_MASTER_PASSWORD = "agent.masterpassword";
    public static final String K_SAVE_MASTER_PASSWORD = "agent.saveMasterPassword";
    public static final String NODEAGENT_DEFAULT_DAS_IS_SECURE = "false";
    public static final String NODEAGENT_DEFAULT_DAS_PORT = String.valueOf(4848);
    private File agentConfigDir;
    private File applicationsDir;
    private File configDir;
    private File generatedDir;
    private File libDir;
    private File docrootDir;
    private File dasPropsFile;
    private Properties dasProperties;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateLocalInstanceFilesystemCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        if (!CreateLocalInstanceFilesystemCommand.ok((String)this.instanceName0)) {
            throw new CommandValidationException(strings.get("Instance.badInstanceName"));
        }
        this.instanceName = this.instanceName0;
        super.validate();
        String agentPath = "agent" + File.separator + "config";
        this.agentConfigDir = new File(this.nodeAgentDir, agentPath);
        this.dasPropsFile = new File(this.agentConfigDir, "das.properties");
        this.applicationsDir = new File(this.instanceDir, "applications");
        this.configDir = new File(this.instanceDir, "config");
        this.generatedDir = new File(this.instanceDir, "generated");
        this.libDir = new File(this.instanceDir, "lib");
        this.docrootDir = new File(this.instanceDir, "docroot");
        this.DASHost = this.programOpts.getHost();
        this.DASPort = this.programOpts.getPort();
        this.dasIsSecure = this.programOpts.isSecure();
        if (!CreateLocalInstanceFilesystemCommand.ok((String)this.DASHost)) {
            try {
                this.DASHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                logger.getLogger().warning(strings.get("Instance.unknownHost"));
                logger.getLogger().warning(ex.getLocalizedMessage());
                this.DASHost = "localhost";
            }
        }
        if (this.DASPort == -1) {
            this.DASPort = this.dasIsSecure ? 4849 : 4848;
        }
        this.DASProtocol = this.dasIsSecure ? "https" : "http";
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        return this.createDirectories();
    }

    private int createDirectories() throws CommandException {
        boolean createDirsComplete = false;
        File badfile = null;
        while (badfile == null && !createDirsComplete) {
            if (!this.agentConfigDir.isDirectory() && !this.agentConfigDir.mkdirs()) {
                badfile = this.agentConfigDir;
            }
            if (!this.applicationsDir.isDirectory() && !this.applicationsDir.mkdir()) {
                badfile = this.applicationsDir;
            }
            if (!this.configDir.isDirectory() && !this.configDir.mkdir()) {
                badfile = this.configDir;
            }
            if (!this.generatedDir.isDirectory() && !this.generatedDir.mkdir()) {
                badfile = this.generatedDir;
            }
            if (!this.libDir.isDirectory() && !this.libDir.mkdir()) {
                badfile = this.libDir;
            }
            if (!this.docrootDir.isDirectory() && !this.docrootDir.mkdir()) {
                badfile = this.docrootDir;
            }
            createDirsComplete = true;
        }
        try {
            this.writeDasProperties();
        }
        catch (IOException ex) {
            throw new CommandException(strings.get("Instance.cantWriteDasProperties", new Object[]{this.dasPropsFile.getName()}), (Throwable)ex);
        }
        if (badfile != null) {
            throw new CommandException(strings.get("Instance.cannotMkDir", new Object[]{badfile}));
        }
        return 0;
    }

    private void writeDasProperties() throws IOException {
        if (!this.dasPropsFile.isFile()) {
            this.dasPropsFile.createNewFile();
        }
        this.dasProperties = new Properties();
        this.dasProperties.setProperty(K_DAS_HOST, this.DASHost);
        this.dasProperties.setProperty(K_DAS_PORT, String.valueOf(this.DASPort));
        this.dasProperties.setProperty(K_DAS_IS_SECURE, String.valueOf(this.dasIsSecure));
        this.dasProperties.setProperty(K_DAS_PROTOCOL, this.DASProtocol);
        FileOutputStream fos = new FileOutputStream(this.dasPropsFile);
        this.dasProperties.store(fos, strings.get("Instance.dasPropertyComment"));
        fos.close();
    }
}

