/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.LocalServerCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.InstanceDirs;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;

public abstract class LocalInstanceCommand
extends LocalServerCommand {
    @Param(name="nodeagent", optional=true)
    protected String nodeAgent;
    @Param(name="agentdir", optional=true)
    protected String agentDir;
    protected String instanceName;
    protected File agentsDir;
    protected File nodeAgentDir;
    protected File instanceDir;
    private InstanceDirs instanceDirs;
    private static final LocalStringsImpl strings = new LocalStringsImpl(LocalInstanceCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        this.initInstance();
    }

    protected void initInstance() throws CommandException {
        String agentsDirPath = null;
        agentsDirPath = LocalInstanceCommand.ok((String)this.agentDir) ? this.agentDir : this.getAgentsDirPath();
        this.agentsDir = new File(agentsDirPath);
        this.agentsDir.mkdirs();
        if (!this.agentsDir.isDirectory()) {
            throw new CommandException(strings.get("Instance.badAgentDir", new Object[]{this.agentsDir}));
        }
        if (this.nodeAgent != null) {
            this.nodeAgentDir = new File(this.agentsDir, this.nodeAgent);
        } else {
            this.nodeAgentDir = this.getTheOneAndOnlyAgent(this.agentsDir);
            this.nodeAgent = this.nodeAgentDir.getName();
        }
        if (this.instanceName != null) {
            this.instanceDir = new File(this.nodeAgentDir, this.instanceName);
            this.instanceDir.mkdirs();
        } else {
            this.instanceDir = this.getTheOneAndOnlyInstance(this.nodeAgentDir);
            this.instanceName = this.instanceDir.getName();
        }
        if (!this.instanceDir.isDirectory()) {
            throw new CommandException(strings.get("Instance.badInstanceDir", new Object[]{this.instanceDir}));
        }
        this.nodeAgentDir = SmartFile.sanitize((File)this.nodeAgentDir);
        this.instanceDir = SmartFile.sanitize((File)this.instanceDir);
        try {
            this.instanceDirs = new InstanceDirs(this.instanceDir);
            this.setServerDirs(this.instanceDirs.getServerDirs());
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        logger.printDebugMessage("nodeAgentDir: " + this.nodeAgentDir);
        logger.printDebugMessage("instanceDir: " + this.instanceDir);
    }

    protected final InstanceDirs getInstanceDirs() {
        return this.instanceDirs;
    }

    private File getTheOneAndOnlyAgent(File parent) throws CommandException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files.length > 1) {
            throw new CommandException(strings.get("Agent.tooManyAgentDirs", new Object[]{parent}));
        }
        if (files.length == 1) {
            return files[0];
        }
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            File f = new File(parent, hostname);
            if (!f.mkdirs() || !f.isDirectory()) {
                throw new CommandException(strings.get("Agent.cantCreateAgentDir", new Object[]{f}));
            }
            return f;
        }
        catch (UnknownHostException ex) {
            throw new CommandException(strings.get("Agent.cantGetHostName", new Object[]{ex}));
        }
    }

    private File getTheOneAndOnlyInstance(File parent) throws CommandException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandException(strings.get("Instance.noInstanceDirs", new Object[]{parent}));
        }
        if (files.length > 2) {
            throw new CommandException(strings.get("Instance.tooManyInstanceDirs", new Object[]{parent}));
        }
        for (File f : files) {
            if (f.getName().equals("agent")) continue;
            return f;
        }
        throw new CommandException(strings.get("Instance.noInstanceDirs", new Object[]{parent}));
    }

    private String getAgentsDirPath() throws CommandException {
        String agentsDirPath = this.getSystemProperty("com.sun.aas.agentRoot");
        if (StringUtils.ok((String)agentsDirPath)) {
            return agentsDirPath;
        }
        String installRootPath = this.getSystemProperty("com.sun.aas.installRoot");
        if (!StringUtils.ok((String)installRootPath)) {
            installRootPath = System.getProperty("com.sun.aas.installRoot");
        }
        if (!StringUtils.ok((String)installRootPath)) {
            throw new CommandException("Agent.noInstallDirPath");
        }
        return installRootPath + "/" + "nodeagents";
    }
}

