/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.cluster.SyncRequest;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_synchronize-instance")
@Scoped(value=PerLookup.class)
public class SynchronizeInstanceCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true, optional=true)
    private String instanceName0;
    @Param(name="syncarchive", optional=true)
    private boolean syncArchive;
    @Param(name="syncallapps", optional=true)
    private boolean syncAllApps;
    private RemoteCommand syncCmd;
    private static final LocalStringsImpl strings = new LocalStringsImpl(SynchronizeInstanceCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.instanceName0;
        super.validate();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        if (this.synchronizeInstance()) {
            return 0;
        }
        return 1;
    }

    protected boolean synchronizeInstance() throws CommandException {
        File dasProperties = this.getServerDirs().getDasPropertiesFile();
        logger.printDebugMessage("das.properties: " + dasProperties);
        if (!dasProperties.exists()) {
            logger.printMessage(strings.get("Sync.noDASConfigured", new Object[]{dasProperties.toString()}));
            return false;
        }
        this.setDasDefaults(dasProperties);
        this.syncCmd = new RemoteCommand("_synchronize-files", this.programOpts, this.env);
        this.syncCmd.setFileOutputDirectory(this.instanceDir);
        File domainXml = new File(new File(this.instanceDir, "config"), "domain.xml");
        long dtime = domainXml.lastModified();
        SyncRequest sr = this.getModTimes("config", SyncLevel.DIRECTORY);
        this.synchronizeFiles(sr);
        if (domainXml.lastModified() == dtime) {
            logger.printDetailMessage(strings.get("Sync.alreadySynced"));
            return true;
        }
        sr = this.getModTimes("applications", SyncLevel.DIRECTORY);
        this.synchronizeFiles(sr);
        File appsDir = new File(this.instanceDir, "applications");
        File archiveDir = new File(appsDir, "__internal");
        for (File adir : FileUtils.listFiles((File)archiveDir)) {
            File[] af = FileUtils.listFiles((File)adir);
            if (af.length != 1) {
                System.out.println("IGNORING " + adir + ", # files " + af.length);
                continue;
            }
            File archive = af[0];
            File appDir = new File(appsDir, adir.getName());
            System.out.println("UNZIP " + archive + " TO " + appDir);
            try {
                SynchronizeInstanceCommand.expand(appDir, archive);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        FileUtils.whack((File)archiveDir);
        sr = this.getModTimes("lib", SyncLevel.RECURSIVE);
        this.synchronizeFiles(sr);
        sr = this.getModTimes("docroot", SyncLevel.DIRECTORY);
        this.synchronizeFiles(sr);
        sr = new SyncRequest();
        sr.instance = this.instanceName;
        sr.dir = "config-specific";
        File configDir = new File(this.instanceDir, "config");
        for (File f : configDir.listFiles()) {
            if (!f.isDirectory()) continue;
            this.getFileModTimes(f, configDir, sr, SyncLevel.DIRECTORY);
        }
        this.synchronizeFiles(sr);
        return true;
    }

    private SyncRequest getModTimes(String dir, SyncLevel level) {
        SyncRequest sr = new SyncRequest();
        sr.instance = this.instanceName;
        sr.dir = dir;
        File fdir = new File(this.instanceDir, dir);
        if (!fdir.exists()) {
            return sr;
        }
        this.getFileModTimes(fdir, fdir, sr, level);
        return sr;
    }

    private void getFileModTimes(File dir, File baseDir, SyncRequest sr, SyncLevel level) {
        if (level == SyncLevel.TOP) {
            long time = dir.lastModified();
            SyncRequest.ModTime mt = new SyncRequest.ModTime(".", time);
            sr.files.add(mt);
            return;
        }
        for (String file : dir.list()) {
            File f = new File(dir, file);
            long time = f.lastModified();
            if (time == 0L) continue;
            if (f.isDirectory() && level == SyncLevel.RECURSIVE) {
                this.getFileModTimes(f, baseDir, sr, level);
                continue;
            }
            String name = baseDir.toURI().relativize(f.toURI()).getPath();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            SyncRequest.ModTime mt = new SyncRequest.ModTime(name, time);
            sr.files.add(mt);
            logger.printDebugMessage(f + ": mod time " + mt.time);
        }
    }

    private void synchronizeFiles(SyncRequest sr) throws CommandException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("mt.", ".xml");
            tempFile.deleteOnExit();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SyncRequest.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)sr, tempFile);
            if (logger.isLoggable(Level.FINER)) {
                marshaller.marshal((Object)sr, (OutputStream)System.out);
            }
            File syncdir = new File(this.instanceDir, sr.dir);
            logger.printDebugMessage("Sync directory: " + syncdir);
            this.syncCmd.execute(new String[]{"_synchronize-files", "--syncarchive", Boolean.toString(this.syncArchive), "--syncallapps", Boolean.toString(this.syncAllApps), tempFile.getPath()});
        }
        catch (IOException ioex) {
            throw new CommandException(strings.get("sync.failed", new Object[]{sr.dir}));
        }
        catch (JAXBException jbex) {
            throw new CommandException(strings.get("sync.failed", new Object[]{sr.dir}));
        }
        catch (CommandException cex) {
            throw new CommandException(strings.get("sync.failed", new Object[]{sr.dir}));
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private static void expand(File dir, File archive) throws Exception {
        dir.mkdir();
        long modtime = archive.lastModified();
        ZipFile zf = new ZipFile(archive);
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            File entry = new File(dir, ze.getName());
            if (ze.isDirectory()) {
                entry.mkdir();
                continue;
            }
            FileUtils.copy((InputStream)zf.getInputStream(ze), (FileOutputStream)new FileOutputStream(entry), (long)0L);
        }
        dir.setLastModified(modtime);
    }

    private void setDasDefaults(File propfile) throws CommandException {
        Properties dasprops = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propfile);
            dasprops.load(fis);
            String p = dasprops.getProperty("agent.das.host");
            if (p != null) {
                this.programOpts.setHost(p);
            }
            if ((p = dasprops.getProperty("agent.das.port")) != null) {
                this.programOpts.setPort(Integer.parseInt(p));
            }
            if ((p = dasprops.getProperty("agent.das.isSecure")) != null) {
                this.programOpts.setSecure(Boolean.parseBoolean(p));
            }
            if ((p = dasprops.getProperty("agent.das.user")) != null) {
                this.programOpts.setUser(p);
            }
        }
        catch (IOException ioex) {
            throw new CommandException(strings.get("Instance.cantReadDasProperties", new Object[]{propfile.getPath()}));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException cex) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SyncLevel {
        TOP,
        DIRECTORY,
        RECURSIVE;

    }
}

