/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-domain")
@Scoped(value=PerLookup.class)
public final class DeleteDomainCommand
extends LocalDomainCommand {
    @Param(name="domain_name", primary=true)
    private String domainName0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(DeleteDomainCommand.class);
    private int adminPort;

    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.domainName0);
        super.validate();
        this.adminPort = super.getAdminPort();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            DomainConfig domainConfig = new DomainConfig(this.getDomainName(), this.getDomainsDir().getPath());
            this.checkRunning();
            PEDomainsManager manager = new PEDomainsManager();
            manager.deleteDomain(domainConfig);
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage());
        }
        logger.printDetailMessage(strings.get("DomainDeleted", new Object[]{this.getDomainName()}));
        return 0;
    }

    private void checkRunning() throws CommandException {
        if (super.isRunning(this.adminPort)) {
            String msg = strings.get("domain.is.running", new Object[]{this.getDomainName(), this.getDomainRootDir()});
            throw new IllegalStateException(msg);
        }
    }

    private void deleteLoginInfo() throws CommandException, StoreException {
        LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
        store.remove("localhost", this.adminPort);
    }
}

