/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.LoginDialog;
import com.sun.enterprise.security.ssl.MasterPasswordImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.MasterPassword;

public final class TextLoginDialog
implements LoginDialog {
    private static Logger _logger = null;
    private String username = null;
    private char[] password = null;
    private static LocalStringManagerImpl localStrings;

    public TextLoginDialog(Callback[] callbacks) {
        try {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    System.err.print(nc.getPrompt());
                    if (nc.getDefaultName() != null) {
                        System.err.print("[" + nc.getDefaultName() + "]: ");
                    } else {
                        System.err.print(": ");
                    }
                    System.err.flush();
                    this.username = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    if (nc.getDefaultName() != null && (this.username == null || this.username.trim().length() == 0)) {
                        this.username = nc.getDefaultName();
                    }
                    nc.setName(this.username);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    char[] passwd = null;
                    Object consoleObj = null;
                    Method readPasswordMethod = null;
                    try {
                        Method consoleMethod = System.class.getMethod("console", new Class[0]);
                        consoleObj = consoleMethod.invoke(null, new Object[0]);
                        readPasswordMethod = consoleObj.getClass().getMethod("readPassword", String.class, Array.newInstance(Object.class, 1).getClass());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (consoleObj != null && readPasswordMethod != null) {
                        passwd = (char[])readPasswordMethod.invoke(consoleObj, "%s", new Object[]{pc.getPrompt()});
                    } else {
                        System.err.print(pc.getPrompt());
                        System.err.flush();
                        passwd = TextLoginDialog.readPassword(System.in);
                    }
                    if (passwd == null) continue;
                    pc.setPassword(passwd);
                    Arrays.fill(passwd, ' ');
                    continue;
                }
                if (!(callbacks[i] instanceof ChoiceCallback)) continue;
                ChoiceCallback cc = (ChoiceCallback)callbacks[i];
                String lbl = localStrings.getLocalString("enterprise.security.keystore", "Enter the KeyStore Password ");
                char[] keystorePass = ((MasterPasswordImpl)Globals.get(MasterPassword.class)).getMasterPassword();
                System.out.println(lbl + " : (max 3 tries)");
                int cnt = 0;
                for (cnt = 0; cnt < 3; ++cnt) {
                    System.out.println(lbl + " : ");
                    char[] kp = new BufferedReader(new InputStreamReader(System.in)).readLine().toCharArray();
                    if (Arrays.equals(kp, keystorePass)) break;
                    String errmessage = localStrings.getLocalString("enterprise.security.IncorrectKeystorePassword", "Incorrect Keystore Password");
                    System.err.println(errmessage);
                    Arrays.fill(kp, ' ');
                }
                Arrays.fill(keystorePass, ' ');
                if (cnt >= 3) {
                    cc.setSelectedIndex(-1);
                    continue;
                }
                System.err.println(cc.getPrompt());
                System.err.flush();
                String[] choices = cc.getChoices();
                for (int j = 0; j < choices.length; ++j) {
                    System.err.print("[" + j + "] ");
                    System.err.println(choices[j]);
                }
                String line = new BufferedReader(new InputStreamReader(System.in)).readLine();
                int sel = new Integer(line);
                cc.setSelectedIndex(sel);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "java_security.name_password_entry_exception", e);
        }
    }

    public String getUserName() {
        return this.username;
    }

    public final char[] getPassword() {
        return this.password == null ? null : Arrays.copyOf(this.password, this.password.length);
    }

    private static char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    static {
        _logger = LogDomains.getLogger(TextLoginDialog.class, (String)"javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(TextLoginDialog.class);
    }
}

