/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.runtime.web.ClassLoader;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.SessionProperties;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WLContainerDescriptorNode
extends RuntimeDescriptorNode {
    public void setElementValue(XMLElement element, String value) {
        String name = element.getQName();
        if (name.equals("save-sessions-enabled")) {
            WebBundleDescriptor descriptor = (WebBundleDescriptor)this.getParentNode().getDescriptor();
            SessionProperties sessionProperties = this.getSessionProperties(descriptor, true);
            WebProperty webProperty = new WebProperty();
            webProperty.setAttributeValue("name", "keepSessions");
            webProperty.setAttributeValue("value", value);
            sessionProperties.addWebProperty(webProperty);
        } else if (name.equals("prefer-web-inf-classes")) {
            WebBundleDescriptor descriptor = (WebBundleDescriptor)this.getParentNode().getDescriptor();
            ClassLoader clBean = descriptor.getSunDescriptor().getClassLoader();
            if (clBean == null) {
                clBean = new ClassLoader();
                descriptor.getSunDescriptor().setClassLoader(clBean);
            }
            clBean.setAttributeValue("Delegate", Boolean.toString(!Boolean.parseBoolean(value)));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Object getDescriptor() {
        return null;
    }

    public Node writeDescriptor(Element root, WebBundleDescriptor webBundleDescriptor) {
        Element containerDescriptorNode = null;
        ClassLoader clBean = webBundleDescriptor.getSunDescriptor().getClassLoader();
        SessionProperties sessionProperties = this.getSessionProperties(webBundleDescriptor, false);
        if (clBean != null || sessionProperties != null) {
            containerDescriptorNode = WLContainerDescriptorNode.appendChild(root, "container-descriptor");
        }
        if (sessionProperties != null && sessionProperties.sizeWebProperty() > 0) {
            for (WebProperty prop : sessionProperties.getWebProperty()) {
                String name = prop.getAttributeValue("name");
                String value = prop.getAttributeValue("value");
                if (!"keepSessions".equals(name)) continue;
                WLContainerDescriptorNode.appendTextChild((Node)containerDescriptorNode, "save-sessions-enabled", value);
                break;
            }
        }
        if (clBean != null) {
            WLContainerDescriptorNode.appendTextChild((Node)containerDescriptorNode, "prefer-web-inf-classes", clBean.getAttributeValue("Delegate"));
        }
        return containerDescriptorNode;
    }

    private SessionProperties getSessionProperties(WebBundleDescriptor webBundleDescriptor, boolean create) {
        SessionProperties sessionProperties = null;
        SessionConfig runtimeSessionConfig = webBundleDescriptor.getSunDescriptor().getSessionConfig();
        if (runtimeSessionConfig == null && create) {
            runtimeSessionConfig = new SessionConfig();
            webBundleDescriptor.getSunDescriptor().setSessionConfig(runtimeSessionConfig);
        }
        if (runtimeSessionConfig != null) {
            sessionProperties = runtimeSessionConfig.getSessionProperties();
        }
        if (sessionProperties == null && create) {
            sessionProperties = new SessionProperties();
            runtimeSessionConfig.setSessionProperties(sessionProperties);
        }
        return sessionProperties;
    }
}

