/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.ServiceAdapter;
import com.sun.enterprise.admin.servermgmt.services.ServicesUtils;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsService
extends ServiceAdapter {
    private static final String TRACE_PREPEND = "TRACE:  ";
    private static final String SOURCE_WIN32_EXE_FILENAME = "winsw.exe";
    private static final String TARGET_DIR = "bin";
    private static final String TEMPLATE_FILE_NAME = "Domain-service-winsw.xml.template";
    private static final String CREDENTIALS_START_TN = "CREDENTIALS_START";
    private static final String CREDENTIALS_STOP_TN = "CREDENTIALS_STOP";
    private String serverName;
    private File sourceWin32Exe;
    private File targetDir;
    private File targetXml;
    private File targetWin32Exe;
    private File installRootDir;
    private File libDir;
    private File templateFile;
    private File serverDir;
    private File serversDir;

    static boolean apropos() {
        return OS.isWindowsForSure();
    }

    WindowsService() {
        if (!WindowsService.apropos()) {
            throw new IllegalArgumentException(Strings.get("internal.error", "Constructor called but Windows Services are not available."));
        }
    }

    @Override
    public boolean isConfigValid() {
        return true;
    }

    @Override
    public void createService(Map<String, String> params) throws RuntimeException {
        try {
            this.init();
            this.trace("**********   Object Dump  **********\n" + this.toString());
            if (this.uninstall() == 0 && !this.isDryRun()) {
                System.out.println(Strings.get("windows.services.uninstall.good"));
            } else {
                this.trace("No preexisting Service with that id and/or name was found");
            }
            this.install();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ProcessManagerException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getSuccessMessage() {
        if (this.isDryRun()) {
            return Strings.get("dryrun");
        }
        return Strings.get("WindowsServiceCreated", this.getName(), this.serverName + " GlassFish Server", this.serverDir, this.targetXml, this.targetWin32Exe);
    }

    @Override
    public void writeReadmeFile(String msg) {
        File f = new File(this.getDomainDirectory(), "PlatformServices.log");
        ServicesUtils.appendTextToFile(f, msg);
    }

    @Override
    public File getDomainDirectory() {
        return new File(this.getLocation());
    }

    public String toString() {
        return ObjectAnalyzer.toString((Object)this);
    }

    private void init() throws IOException {
        this.trace("In init");
        this.setInstallRootDir();
        this.setLibDir();
        this.setTemplateFile();
        this.setSourceWin32Exe();
        this.serverDir = SmartFile.sanitize((File)new File(this.getLocation()));
        this.serverName = this.serverDir.getName();
        this.serversDir = SmartFile.sanitize((File)new File(this.serverDir, ".."));
        this.targetDir = new File(this.serverDir, TARGET_DIR);
        this.targetDir.mkdirs();
        if (!this.targetDir.isDirectory()) {
            throw new RuntimeException(Strings.get("noTargetDir", this.targetDir));
        }
        this.targetWin32Exe = new File(this.targetDir, this.serverName + "Service.exe");
        this.targetXml = new File(this.targetDir, this.serverName + "Service.xml");
        this.handlePreExisting(this.targetWin32Exe, this.targetXml, this.isForce());
        FileUtils.copy((File)this.sourceWin32Exe, (File)this.targetWin32Exe);
        this.trace("Copied from " + this.sourceWin32Exe + " to " + this.targetWin32Exe);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ENTITY_NAME", this.serverName);
        map.put("DATE_CREATED", this.getDate());
        map.put("NAME", this.getName());
        map.put("AS_ADMIN_PATH", this.getAsadminPath().replace('\\', '/'));
        map.put("LOCATION", this.serversDir.getPath().replace('\\', '/'));
        map.put(CREDENTIALS_START_TN, this.getAsadminCredentials("startargument"));
        map.put(CREDENTIALS_STOP_TN, this.getAsadminCredentials("stopargument"));
        this.trace("MAP --> " + ((Object)map).toString());
        ServicesUtils.tokenReplaceTemplateAtDestination(map, this.templateFile.getPath(), this.targetXml.getPath());
        this.trace("Target XML file written: " + this.targetXml);
    }

    private void setSourceWin32Exe() throws IOException {
        this.sourceWin32Exe = new File(this.libDir, SOURCE_WIN32_EXE_FILENAME);
        if (!this.sourceWin32Exe.isFile()) {
            InputStream in = this.getClass().getResourceAsStream("/lib/winsw.exe");
            FileOutputStream out = new FileOutputStream(this.sourceWin32Exe);
            WindowsService.copyStream(in, out);
            this.trace("Copied from inside the jar to " + this.sourceWin32Exe);
        }
        this.trace("Source executable: " + this.sourceWin32Exe);
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    private void setInstallRootDir() {
        String ir = System.getProperty("com.sun.aas.installRoot");
        if (!WindowsService.ok(ir)) {
            throw new RuntimeException(Strings.get("internal.error", "System Property not set: com.sun.aas.installRoot"));
        }
        this.installRootDir = SmartFile.sanitize((File)new File(ir));
        if (!this.installRootDir.isDirectory()) {
            throw new RuntimeException(Strings.get("internal.error", "Not a directory: " + this.installRootDir));
        }
    }

    private void setLibDir() {
        this.libDir = SmartFile.sanitize((File)new File(this.installRootDir, "lib"));
        if (!this.libDir.isDirectory()) {
            throw new RuntimeException(Strings.get("internal.error", "Not a directory: " + this.libDir));
        }
    }

    private void setTemplateFile() {
        this.templateFile = new File(this.libDir, "install/templates/Domain-service-winsw.xml.template");
    }

    private String getAsadminCredentials(String elem) {
        if (!WindowsService.ok(this.getPasswordFilePath())) {
            return " ";
        }
        String user = this.getAppserverUser();
        String begin = "<" + elem + ">";
        String end = "</" + elem + ">\n";
        StringBuilder sb = new StringBuilder();
        if (user != null) {
            sb.append(" " + begin + "--user" + end);
            sb.append("  " + begin + user + end);
        }
        sb.append("  " + begin + "--passwordfile" + end);
        sb.append("  " + begin + this.getPasswordFilePath() + end);
        sb.append("  ");
        return sb.toString();
    }

    private void trace(String s) {
        if (this.isTrace()) {
            System.out.println(TRACE_PREPEND + s);
        }
    }

    private int uninstall() throws ProcessManagerException {
        if (this.isDryRun() || !this.targetWin32Exe.canExecute()) {
            return 0;
        }
        ProcessManager mgr = new ProcessManager(new String[]{this.targetWin32Exe.getPath(), "uninstall"});
        mgr.execute();
        this.trace("Uninstall STDERR: " + mgr.getStderr());
        this.trace("Uninstall STDOUT: " + mgr.getStdout());
        return mgr.getExitValue();
    }

    private void install() throws ProcessManagerException {
        if (this.isDryRun()) {
            this.targetXml.delete();
            this.targetWin32Exe.delete();
        } else {
            ProcessManager mgr = new ProcessManager(new String[]{this.targetWin32Exe.getPath(), "install"});
            mgr.execute();
            int ret = mgr.getExitValue();
            if (ret != 0) {
                throw new RuntimeException(Strings.get("windows.services.install.bad", "" + ret, mgr.getStdout(), mgr.getStderr()));
            }
            this.trace("Install STDERR: " + mgr.getStderr());
            this.trace("Install STDOUT: " + mgr.getStdout());
        }
    }

    private void handlePreExisting(File targetWin32Exe, File targetXml, boolean force) {
        if (targetWin32Exe.exists() || targetXml.exists()) {
            if (force) {
                targetWin32Exe.delete();
                targetXml.delete();
                this.handlePreExisting(targetWin32Exe, targetXml, false);
            } else {
                throw new RuntimeException(Strings.get("windows.services.alreadyCreated", new File(this.targetDir, this.serverName + "Service")));
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

