/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.ext;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import org.glassfish.admin.amx.base.ConnectorRuntimeAPIProvider;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectorRuntimeAPIProviderImpl
extends AMXImplBase {
    private final Habitat mHabitat;

    public ConnectorRuntimeAPIProviderImpl(ObjectName parent, Habitat habitat) {
        super(parent, ConnectorRuntimeAPIProvider.class);
        if (habitat == null) {
            throw new IllegalStateException("Habitat is null");
        }
        this.mHabitat = habitat;
    }

    public Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(String datasourceClassName, String resType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map connProps = this.getConnectorRuntime().getConnectionDefinitionPropertiesAndDefaults(datasourceClassName, resType);
            result.put("ConnDefinitionPropsKey", connProps);
        }
        catch (ComponentException e) {
            result.put("ConnDefinitionPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    private ConnectorRuntime getConnectorRuntime() {
        return (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
    }

    public Map<String, Object> getSystemConnectorsAllowingPoolCreation() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] systemRars = this.getConnectorRuntime().getSystemConnectorsAllowingPoolCreation();
            result.put("SystemConnectorsKey", systemRars);
        }
        catch (ComponentException e) {
            result.put("SystemConnectorsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getBuiltInCustomResources() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map customResources = this.getConnectorRuntime().getBuiltInCustomResources();
            result.put("BuiltInCustomResourcesKey", customResources);
        }
        catch (ComponentException e) {
            result.put("BuiltInCustomResourcesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getConnectionDefinitionNames(String rarName) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] conDefnNames = this.getConnectorRuntime().getConnectionDefinitionNames(rarName);
            result.put("ConnectionDefinitionNamesKey", conDefnNames);
        }
        catch (ConnectorRuntimeException e) {
            result.put("ConnectionDefinitionNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("ConnectionDefinitionNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getMCFConfigProps(String rarName, String connectionDefName) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getMCFConfigProps(rarName, connectionDefName);
            result.put("McfConfigPropsKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("McfConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("McfConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getAdminObjectInterfaceNames(String rarName) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] adminObjectInterfaceNames = this.getConnectorRuntime().getAdminObjectInterfaceNames(rarName);
            result.put("AdminObjectInterfacesKey", adminObjectInterfaceNames);
        }
        catch (ConnectorRuntimeException e) {
            result.put("AdminObjectInterfacesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("AdminObjectInterfacesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getAdminObjectClassNames(String rarName, String intfName) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] adminObjectClassNames = this.getConnectorRuntime().getAdminObjectClassNames(rarName, intfName);
            result.put("AdminObjectClassesKey", adminObjectClassNames);
        }
        catch (ConnectorRuntimeException e) {
            result.put("AdminObjectClassesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("AdminObjectClassesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getResourceAdapterConfigProps(String rarName) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getResourceAdapterConfigProps(rarName);
            result.put("ResourceAdapterConfigPropsKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("ResourceAdapterConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("ResourceAdapterConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getAdminObjectConfigProps(String rarName, String adminObjectIntf, String adminObjectClass) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getAdminObjectConfigProps(rarName, adminObjectIntf, adminObjectClass);
            result.put("AdminObjectConfigPropsKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("AdminObjectConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("AdminObjectConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getAdminObjectConfigProps(String rarName, String adminObjectIntf) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getAdminObjectConfigProps(rarName, adminObjectIntf);
            result.put("AdminObjectConfigPropsKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("AdminObjectConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("AdminObjectConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getConnectorConfigJavaBeans(String rarName, String connectionDefName, String type) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getConnectorConfigJavaBeans(rarName, connectionDefName, type);
            result.put("ConnectorConfigJavaBeansKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("ConnectorConfigJavaBeansKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("ConnectorConfigJavaBeansKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getActivationSpecClass(String rarName, String messageListenerType) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String activationSpec = this.getConnectorRuntime().getActivationSpecClass(rarName, messageListenerType);
            result.put("ActivationSpecClassKey", activationSpec);
        }
        catch (ConnectorRuntimeException e) {
            result.put("ActivationSpecClassKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("ActivationSpecClassKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getMessageListenerTypes(String rarName) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] messageListenerTypes = this.getConnectorRuntime().getMessageListenerTypes(rarName);
            result.put("MessageListenerTypesKey", messageListenerTypes);
        }
        catch (ConnectorRuntimeException e) {
            result.put("MessageListenerTypesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("MessageListenerTypesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getMessageListenerConfigProps(String rarName, String messageListenerType) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getMessageListenerConfigProps(rarName, messageListenerType);
            result.put("MessageListenerConfigPropsKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("MessageListenerConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("MessageListenerConfigPropsKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getMessageListenerConfigPropTypes(String rarName, String messageListenerType) {
        rarName = ConnectorRuntimeAPIProviderImpl.getActualRAName(rarName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map configProperties = this.getConnectorRuntime().getMessageListenerConfigPropTypes(rarName, messageListenerType);
            result.put("MessageListenerConfigPropTypesKey", configProperties);
        }
        catch (ConnectorRuntimeException e) {
            result.put("MessageListenerConfigPropTypesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (ComponentException e) {
            result.put("MessageListenerConfigPropTypesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> flushConnectionPool(String poolName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.mHabitat == null) {
            result.put("FlushConnectionPoolKey", false);
            result.put("ReasonFailedKey", "Habitat is null");
            return result;
        }
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            boolean flushStatus = connRuntime.flushConnectionPool(poolName);
            result.put("FlushConnectionPoolKey", flushStatus);
        }
        catch (ConnectorRuntimeException ex) {
            result.put("FlushConnectionPoolKey", false);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)ex));
        }
        catch (ComponentException e) {
            result.put("FlushConnectionPoolKey", false);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getValidationTableNames(String poolName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            Set tableNames = connRuntime.getValidationTableNames(poolName);
            result.put("ValidationTableNamesKey", tableNames);
        }
        catch (ComponentException e) {
            result.put("ValidationTableNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("ValidationTableNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getJdbcDriverClassNames(String dbVendor, String resType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            Set implClassNames = connRuntime.getJdbcDriverClassNames(dbVendor, resType);
            result.put("JdbcDriverClassNamesKey", implClassNames);
        }
        catch (ComponentException e) {
            result.put("JdbcDriverClassNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("JdbcDriverClassNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getJdbcDriverClassNames(String dbVendor, String resType, boolean introspect) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            Set implClassNames = connRuntime.getJdbcDriverClassNames(dbVendor, resType, introspect);
            result.put("JdbcDriverClassNamesKey", implClassNames);
        }
        catch (ComponentException e) {
            result.put("JdbcDriverClassNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("JdbcDriverClassNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> pingJDBCConnectionPool(String poolName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.mHabitat == null) {
            result.put("PingConnectionPoolKey", false);
            result.put("ReasonFailedKey", "Habitat is null");
            return result;
        }
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            boolean pingStatus = connRuntime.pingConnectionPool(poolName);
            result.put("PingConnectionPoolKey", pingStatus);
        }
        catch (ResourceException ex) {
            result.put("PingConnectionPoolKey", false);
            result.put("ReasonFailedKey", ex.getMessage());
        }
        catch (ComponentException e) {
            result.put("PingConnectionPoolKey", false);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("PingConnectionPoolKey", false);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getValidationClassNames(String dbVendor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.mHabitat == null) {
            result.put("ValidationClassNamesKey", false);
            result.put("ReasonFailedKey", "Habitat is null");
            return result;
        }
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            Set valClassNames = connRuntime.getValidationClassNames(dbVendor);
            result.put("ValidationClassNamesKey", valClassNames);
        }
        catch (ComponentException e) {
            result.put("ValidationClassNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("ValidationClassNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getDatabaseVendorNames() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.mHabitat == null) {
            result.put("DatabaseVendorNamesKey", false);
            result.put("ReasonFailedKey", "Habitat is null");
            return result;
        }
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)this.mHabitat.getComponent(ConnectorRuntime.class, null);
            Set dbVendorNames = connRuntime.getDatabaseVendorNames();
            result.put("DatabaseVendorNamesKey", dbVendorNames);
        }
        catch (ComponentException e) {
            result.put("DatabaseVendorNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        catch (Exception e) {
            result.put("DatabaseVendorNamesKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }

    private static String getActualRAName(String rarName) {
        if (rarName != null && rarName.contains("#") && rarName.endsWith(".rar")) {
            int index = rarName.lastIndexOf(".rar");
            return rarName.substring(0, index);
        }
        return rarName;
    }
}

