/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.embedded;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedSecurityUtil {
    public static void copyConfigFiles(Habitat habitat, String fromInstanceDir, String toInstanceDir) throws IOException {
        ServerEnvironment se = (ServerEnvironment)habitat.getComponent(ServerEnvironment.class);
        if (!EmbeddedSecurityUtil.isEmbedded(se)) {
            return;
        }
        if (fromInstanceDir == null || toInstanceDir == null) {
            throw new IllegalArgumentException("Null inputs");
        }
        File fileFromInstanceDir = new File(fromInstanceDir);
        File fileToInstanceDir = new File(toInstanceDir);
        ArrayList<String> fileNames = new ArrayList<String>();
        SecurityService securityService = (SecurityService)habitat.getComponent(SecurityService.class);
        fileNames.addAll(EmbeddedSecurityUtil.getKeyFileNames(securityService));
        String keyStoreFileName = fromInstanceDir + File.separator + "config" + File.separator + "keystore.jks";
        String trustStoreFileName = fromInstanceDir + File.separator + "config" + File.separator + "cacerts.jks";
        fileNames.add(keyStoreFileName);
        fileNames.add(trustStoreFileName);
        String loginConf = fromInstanceDir + File.separator + "config" + File.separator + "login.conf";
        String secPolicy = fromInstanceDir + File.separator + "config" + File.separator + "security.policy";
        fileNames.add(loginConf);
        fileNames.add(secPolicy);
        File toConfigDir = new File(fileToInstanceDir, "config");
        if (!toConfigDir.exists()) {
            toConfigDir.mkdir();
        }
        for (String fileName : fileNames) {
            FileUtils.copyFile((File)new File(fileName), (File)new File(toConfigDir, EmbeddedSecurityUtil.parseFileName(fileName)));
        }
    }

    public static List<String> getKeyFileNames(SecurityService securityService) {
        List keyFileNames = Collections.EMPTY_LIST;
        List authRealms = securityService.getAuthRealm();
        for (AuthRealm authRealm : authRealms) {
            String className = authRealm.getClassname();
            if (!"com.sun.enterprise.security.auth.realm.file.FileRealm".equals(className)) continue;
            List props = authRealm.getProperty();
            for (Property prop : props) {
                if (!"file".equals(prop.getName())) continue;
                keyFileNames.add(prop.getValue());
            }
        }
        return keyFileNames;
    }

    public static String parseFileName(String fullFilePath) {
        if (fullFilePath == null) {
            return null;
        }
        int beginIndex = fullFilePath.lastIndexOf(File.separator);
        return fullFilePath.substring(beginIndex + 1);
    }

    public static boolean isEmbedded(ServerEnvironment se) {
        return se.getRuntimeType() == RuntimeType.EMBEDDED;
    }
}

