/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-sub-components")
@I18n(value="list.sub.components")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class ListSubComponentsCommand
implements AdminCommand {
    @Param(primary=true)
    private String modulename = null;
    @Param(optional=true)
    private String appname = null;
    @Param(optional=true)
    private String type = null;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    public Deployment deployment;
    @Inject
    public Applications applications;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListSubComponentsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        String applicationName = this.modulename;
        if (this.appname != null) {
            applicationName = this.appname;
        }
        try {
            VersioningService.checkIdentifier((String)applicationName);
        }
        catch (VersioningSyntaxException ex) {
            report.setMessage(ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.deployment.isRegistered(applicationName)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{applicationName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        com.sun.enterprise.config.serverbeans.Application application = this.applications.getApplication(applicationName);
        ApplicationInfo appInfo = this.appRegistry.get(applicationName);
        if (appInfo == null) {
            report.setMessage(localStrings.getLocalString("application.not.enabled", "Application {0} is not in an enabled state", new Object[]{applicationName}));
            return;
        }
        Application app = (Application)appInfo.getMetaData(Application.class);
        List<Object> subComponents = new ArrayList();
        subComponents = this.appname == null ? this.getAppLevelComponents(app, this.type) : this.getModuleLevelComponents(app.getModuleByUri(this.modulename), this.type);
        if (this.type != null && !this.type.equals("servlets") && !this.type.equals("ejbs")) {
            report.setMessage(localStrings.getLocalString("listsubcomponents.invalidtype", "The type option has invalid value {0}. It should have a value of servlets or ejbs.", new Object[]{this.type}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List<Object> subModuleInfos = new ArrayList();
        if (!app.isVirtual()) {
            subModuleInfos = this.getSubModulesForEar(app);
        }
        for (int i = 0; i < subComponents.size(); ++i) {
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage((String)subComponents.get(i));
            if (this.appname != null || app.isVirtual() || subModuleInfos.get(i) == null) continue;
            childPart.addProperty("moduleInfo", (String)subModuleInfos.get(i));
        }
        if (subComponents.size() == 0) {
            part.setMessage(localStrings.getLocalString("listsubcomponents.no.elements.to.list", "Nothing to List."));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private List<String> getSubModulesForEar(Application application) {
        ArrayList<String> moduleInfoList = new ArrayList<String>();
        for (ModuleDescriptor moduleDesc : application.getModules()) {
            String moduleInfo = moduleDesc.getArchiveUri() + ":" + moduleDesc.getModuleType();
            if (moduleDesc.getModuleType().equals((Object)XModuleType.WAR)) {
                moduleInfo = moduleInfo + ":" + moduleDesc.getContextRoot();
            }
            moduleInfoList.add(moduleInfo);
        }
        return moduleInfoList;
    }

    private List<String> getAppLevelComponents(Application application, String type) {
        ArrayList<String> subComponentList = new ArrayList();
        if (application.isVirtual()) {
            BundleDescriptor bundleDescriptor = application.getStandaloneBundleDescriptor();
            subComponentList = this.getModuleLevelComponents(bundleDescriptor, type);
        } else {
            Collection<ModuleDescriptor> modules = new ArrayList();
            if (type == null) {
                modules = application.getModules();
            } else if (type.equals("servlets")) {
                modules = application.getModuleDescriptorsByType(XModuleType.WAR);
            } else if (type.equals("ejbs")) {
                modules = application.getModuleDescriptorsByType(XModuleType.EJB);
                Collection webModules = application.getModuleDescriptorsByType(XModuleType.WAR);
                for (ModuleDescriptor webModule : webModules) {
                    if (webModule.getDescriptor().getExtensionsDescriptors(EjbBundleDescriptor.class).size() <= 0) continue;
                    modules.add(webModule);
                }
            }
            for (ModuleDescriptor module : modules) {
                StringBuffer sb = new StringBuffer();
                sb.append(module.getArchiveUri());
                sb.append(" <");
                sb.append(this.getModuleType(module));
                sb.append(">");
                subComponentList.add(sb.toString());
            }
        }
        return subComponentList;
    }

    private List<String> getModuleLevelComponents(BundleDescriptor bundle, String type) {
        ArrayList<String> moduleSubComponentList;
        block6: {
            block5: {
                moduleSubComponentList = new ArrayList<String>();
                if (!(bundle instanceof WebBundleDescriptor)) break block5;
                WebBundleDescriptor wbd = (WebBundleDescriptor)bundle;
                Collection ejbBundleDescs = wbd.getExtensionsDescriptors(EjbBundleDescriptor.class);
                if (ejbBundleDescs.size() > 0) {
                    EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)ejbBundleDescs.iterator().next();
                    moduleSubComponentList.addAll(this.getModuleLevelComponents((BundleDescriptor)ejbBundle, type));
                }
                if (type != null && type.equals("ejbs")) {
                    return moduleSubComponentList;
                }
                for (WebComponentDescriptor wcd : wbd.getWebComponentDescriptors()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(wcd.getCanonicalName());
                    sb.append(" <");
                    String wcdType = wcd.isServlet() ? "Servlet" : "JSP";
                    sb.append(wcdType);
                    sb.append(">");
                    moduleSubComponentList.add(sb.toString());
                }
                break block6;
            }
            if (!(bundle instanceof EjbBundleDescriptor)) break block6;
            if (type != null && type.equals("servlets")) {
                return moduleSubComponentList;
            }
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)bundle;
            for (EjbDescriptor ejbDesc : ebd.getEjbs()) {
                StringBuffer sb = new StringBuffer();
                sb.append(ejbDesc.getName());
                sb.append(" <");
                sb.append(this.getEjbType(ejbDesc));
                sb.append(">");
                moduleSubComponentList.add(sb.toString());
            }
        }
        return moduleSubComponentList;
    }

    private String getEjbType(EjbDescriptor ejbDesc) {
        String type = null;
        if (ejbDesc.getType().equals("Session")) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejbDesc;
            if (sessionDesc.isStateful()) {
                type = "StatefulSessionBean";
            } else if (sessionDesc.isStateless()) {
                type = "StatelessSessionBean";
            } else if (sessionDesc.isSingleton()) {
                type = "SingletonSessionBean";
            }
        } else if (ejbDesc.getType().equals("Message-driven")) {
            type = "MessageDrivenBean";
        } else if (ejbDesc.getType().equals("Entity")) {
            type = "EntityBean";
        }
        return type;
    }

    private String getModuleType(ModuleDescriptor modDesc) {
        String type = null;
        if (modDesc.getModuleType().equals((Object)XModuleType.EJB)) {
            type = "EJBModule";
        } else if (modDesc.getModuleType().equals((Object)XModuleType.WAR)) {
            type = "WebModule";
        } else if (modDesc.getModuleType().equals((Object)XModuleType.CAR)) {
            type = "AppClientModule";
        } else if (modDesc.getModuleType().equals((Object)XModuleType.RAR)) {
            type = "ConnectorModule";
        }
        return type;
    }
}

