/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.EjbSecurityPolicyProbeProvider;
import com.sun.enterprise.security.SecurityContainer;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContextException;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="Security")
public class SecurityDeployer
extends SimpleDeployer<SecurityContainer, DummyApplication>
implements PostConstruct {
    private static final Logger _logger = LogDomains.getLogger(SecurityDeployer.class, (String)"javax.enterprise.system.core.security");
    @Inject
    private ServerContext serverContext;
    @Inject
    private Habitat habitat;
    @Inject
    private WebSecurityManagerFactory wsmf;
    private EventListener listener = null;
    private static WebSecurityDeployerProbeProvider websecurityProbeProvider = new WebSecurityDeployerProbeProvider();
    private static EjbSecurityPolicyProbeProvider ejbProbeProvider = new EjbSecurityPolicyProbeProvider();

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin != OpsParams.Origin.deploy) {
            return;
        }
        String appName = params.name();
        try {
            Application app = (Application)dc.getModuleMetaData(Application.class);
            Set webDesc = app.getWebBundleDescriptors();
            if (webDesc == null) {
                return;
            }
            for (WebBundleDescriptor webBD : webDesc) {
                this.loadPolicy(webBD, false);
            }
        }
        catch (Exception se) {
            String msg = "Error in generating security policy for " + appName;
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
        this.removePolicy(dc);
        SecurityUtil.removeRoleMapper(dc);
    }

    public DummyApplication load(SecurityContainer container, DeploymentContext context) {
        return new DummyApplication();
    }

    public void unload(DummyApplication container, DeploymentContext context) {
        OpsParams params = context.getCommandParameters(OpsParams.class);
        this.cleanSecurityContext(params.name());
    }

    private void loadPolicy(WebBundleDescriptor webBD, boolean remove) throws DeploymentException {
        try {
            if (webBD != null) {
                String cid;
                WebSecurityManager wsm;
                if (remove && (wsm = this.wsmf.getManager(cid = SecurityUtil.getContextID(webBD), null, true)) != null) {
                    wsm.release();
                }
                this.wsmf.createManager(webBD, true, this.serverContext);
            }
        }
        catch (Exception se) {
            String msg = "Error in generating security policy for " + webBD.getModuleDescriptor().getModuleName();
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    private void commitPolicy(WebBundleDescriptor webBD) throws DeploymentException {
        try {
            if (webBD != null) {
                if (webBD.isPolicyModified()) {
                    this.loadPolicy(webBD, true);
                }
                String cid = SecurityUtil.getContextID(webBD);
                websecurityProbeProvider.policyCreationStartedEvent(webBD.getModuleID());
                SecurityUtil.generatePolicyFile(cid);
                websecurityProbeProvider.policyCreationEndedEvent(webBD.getModuleID());
                websecurityProbeProvider.policyCreationEvent(cid);
            }
        }
        catch (Exception se) {
            String msg = "Error in generating security policy for " + webBD.getModuleDescriptor().getModuleName();
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    private void commitEjbs(Application app) throws DeploymentException {
        Set ejbDescriptors = app.getEjbBundleDescriptors();
        try {
            for (EjbBundleDescriptor ejbBD : ejbDescriptors) {
                String pcid = SecurityUtil.getContextID(ejbBD);
                ejbProbeProvider.policyCreationStartedEvent(ejbBD.getModuleID());
                SecurityUtil.generatePolicyFile(pcid);
                ejbProbeProvider.policyCreationEndedEvent(ejbBD.getModuleID());
                ejbProbeProvider.policyCreationEvent(pcid);
            }
        }
        catch (Exception se) {
            String msg = "Error in committing security policy for ejbs of " + app.getRegistrationName();
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    private void linkPolicies(Application app, Collection<WebBundleDescriptor> webs) throws DeploymentException {
        try {
            String linkName = null;
            boolean lastInService = false;
            for (WebBundleDescriptor wbd : webs) {
                String name = SecurityUtil.getContextID(wbd);
                lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                linkName = name;
            }
            Set ejbs = app.getEjbBundleDescriptors();
            for (EjbBundleDescriptor ejbd : ejbs) {
                String name = SecurityUtil.getContextID(ejbd);
                lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                linkName = name;
            }
        }
        catch (IASSecurityException se) {
            String msg = "Error in linking security policy for " + app.getRegistrationName();
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    private void removePolicy(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin != OpsParams.Origin.undeploy && params.origin != OpsParams.Origin.deploy) {
            return;
        }
        String appName = params.name();
        try {
            String[] webcontexts = this.wsmf.getContextsForApp(appName, false);
            if (webcontexts != null) {
                for (int i = 0; i < webcontexts.length; ++i) {
                    if (webcontexts[i] == null) continue;
                    websecurityProbeProvider.policyDestructionStartedEvent(webcontexts[i]);
                    SecurityUtil.removePolicy(webcontexts[i]);
                    websecurityProbeProvider.policyDestructionEndedEvent(webcontexts[i]);
                    websecurityProbeProvider.policyDestructionEvent(webcontexts[i]);
                }
            }
        }
        catch (IASSecurityException ex) {
            String msg = "Error in removing security policy for " + appName;
            _logger.log(Level.WARNING, msg, ex);
            throw new DeploymentException(msg, (Throwable)ex);
        }
        this.cleanSecurityContext(appName);
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    private boolean cleanSecurityContext(String appName) {
        boolean cleanUpDone = false;
        ArrayList<WebSecurityManager> managers = this.wsmf.getManagersForApp(appName, false);
        for (int i = 0; managers != null && i < managers.size(); ++i) {
            try {
                websecurityProbeProvider.securityManagerDestructionStartedEvent(appName);
                managers.get(i).destroy();
                websecurityProbeProvider.securityManagerDestructionEndedEvent(appName);
                websecurityProbeProvider.securityManagerDestructionEvent(appName);
                cleanUpDone = true;
                continue;
            }
            catch (PolicyContextException pce) {
                _logger.log(Level.WARNING, "Unable to destroy WebSecurityManager", pce);
            }
        }
        return cleanUpDone;
    }

    public static List<EventTypes> getDeploymentEvents() {
        ArrayList<EventTypes> events = new ArrayList<EventTypes>();
        events.add(Deployment.APPLICATION_PREPARED);
        return events;
    }

    public void postConstruct() {
        this.listener = new AppDeployEventListener();
        Events events = (Events)this.habitat.getByContract(Events.class);
        events.register(this.listener);
    }

    private class AppDeployEventListener
    implements EventListener {
        private AppDeployEventListener() {
        }

        public void event(EventListener.Event event) {
            Application app = null;
            if (Deployment.MODULE_LOADED.equals((Object)event.type())) {
                ModuleInfo moduleInfo = (ModuleInfo)event.hook();
                if (moduleInfo instanceof ApplicationInfo) {
                    return;
                }
                WebBundleDescriptor webBD = (WebBundleDescriptor)moduleInfo.getMetaData(WebBundleDescriptor.class);
                SecurityDeployer.this.loadPolicy(webBD, false);
            } else if (Deployment.APPLICATION_LOADED.equals((Object)event.type())) {
                RegisteredComponentInvocationHandler handler;
                ApplicationInfo appInfo = (ApplicationInfo)event.hook();
                app = (Application)appInfo.getMetaData(Application.class);
                if (app == null) {
                    return;
                }
                Set webDesc = app.getWebBundleDescriptors();
                SecurityDeployer.this.linkPolicies(app, webDesc);
                SecurityDeployer.this.commitEjbs(app);
                if (webDesc != null && !webDesc.isEmpty() && (handler = (RegisteredComponentInvocationHandler)SecurityDeployer.this.habitat.getComponent(RegisteredComponentInvocationHandler.class, "webSecurityCIH")) != null) {
                    handler.register();
                }
            } else if (WebBundleDescriptor.AFTER_SERVLET_CONTEXT_INITIALIZED_EVENT.equals((Object)event.type())) {
                SecurityDeployer.this.commitPolicy((WebBundleDescriptor)event.hook());
            }
        }
    }
}

