/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ws;

import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.ws.WLWebServiceEndpointNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Node;

class WLWebServiceNode
extends DisplayableComponentNode {
    private WebService descriptor = null;
    private static final XMLElement tag = new XMLElement("webservice-description");

    public WLWebServiceNode() {
        this.registerElementHandler(new XMLElement("port-component"), WLWebServiceEndpointNode.class);
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("webservice-type", "setType");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("webservice-description-name".equals(element.getQName())) {
            WebServicesDescriptor webServices = (WebServicesDescriptor)this.getParentNode().getDescriptor();
            this.descriptor = webServices.getWebServiceByName(value);
        } else if ("wsdl-publish-file".equals(element.getQName())) {
            if (this.descriptor == null) {
                DOLUtils.getDefaultLogger().info("Warning : WebService descriptor is null for final wsdl url=" + value);
                return;
            }
            try {
                URL url = new URL(value);
                this.descriptor.setClientPublishUrl(url);
            }
            catch (MalformedURLException mue) {
                DOLUtils.getDefaultLogger().log(Level.INFO, "Warning : Invalid final wsdl url=" + value, mue);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    public void addDescriptor(Object descriptor) {
        WebServiceEndpoint endpoint = (WebServiceEndpoint)descriptor;
        WebService webService = (WebService)this.getDescriptor();
        webService.addEndpoint(endpoint);
    }

    public Node writeDescriptor(Node parent, String nodeName, WebService descriptor) {
        Node topNode = super.writeDescriptor(parent, nodeName, descriptor);
        WLWebServiceNode.appendTextChild(topNode, "webservice-description-name", descriptor.getName());
        WLWebServiceNode.appendTextChild(topNode, "webservice-type", descriptor.getType());
        WLWebServiceNode.appendTextChild(topNode, "wsdl-publish-file", descriptor.getClientPublishUrl().toString());
        WLWebServiceEndpointNode endpointNode = new WLWebServiceEndpointNode();
        for (WebServiceEndpoint next : descriptor.getEndpoints()) {
            endpointNode.writeDescriptor(topNode, "port-component", next);
        }
        return topNode;
    }
}

