/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.universal.process.LocalAdminCommand;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="create-instance")
@I18n(value="create.instance")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class CreateInstanceCommand
implements AdminCommand,
PostConstruct {
    private static final String DEFAULT_NODE = "localhost";
    private static final String LOCAL_HOST = "localhost";
    private static final String NL = System.getProperty("line.separator");
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    private Nodes nodes;
    @Param(name="node")
    String node;
    @Param(name="nodeagent", optional=true)
    String nodeAgent;
    @Param(name="config", optional=true)
    String configRef;
    @Param(name="cluster", optional=true)
    String clusterName;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    @Param(name="instance_name", primary=true)
    private String instance;
    private Logger logger;
    private AdminCommandContext ctx;
    private RemoteInstanceCommandHelper helper;
    private RemoteConnectHelper rch;
    private String nodeHost = null;
    private int dasPort;
    private String dasHost;

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.ctx = context;
        this.logger = context.logger;
        if (this.nodes.getNode(this.node) == null) {
            String msg = Strings.get("noSuchNode", this.node);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.nodeHost = this.getHostFromNodeName(this.node);
        if (!StringUtils.ok((String)this.nodeAgent)) {
            this.nodeAgent = this.nodeHost;
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_register-instance", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"node", (Object)this.node);
        if (this.nodeAgent != null) {
            map.add((Object)"nodeagent", (Object)this.nodeAgent);
        }
        map.add((Object)"config", (Object)this.configRef);
        map.add((Object)"cluster", (Object)this.clusterName);
        map.add((Object)"systemproperties", (Object)this.systemProperties);
        map.add((Object)"DEFAULT", (Object)this.instance);
        ci.parameters(map);
        ci.execute();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            return;
        }
        this.dasPort = this.helper.getAdminPort("server");
        this.dasHost = System.getProperty("com.sun.aas.hostName");
        this.rch = new RemoteConnectHelper(this.habitat, this.nodeList, this.logger, this.dasHost, this.dasPort);
        String humanVersionOfCommand = "asadmin  create-local-instance  --node " + this.node + " " + this.instance;
        if (this.rch.isLocalhost(this.nodes.getNode(this.node))) {
            LocalAdminCommand lac = new LocalAdminCommand("_create-instance-filesystem", new String[]{"--node", this.node, this.instance});
            String msg = Strings.get("creatingInstance", this.instance, "localhost");
            this.logger.info(msg);
            try {
                int status = lac.execute();
            }
            catch (ProcessManagerException ex) {
                msg = Strings.get("create.instance.remote.failed", this.instance, this.nodeHost, humanVersionOfCommand);
                this.logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
                return;
            }
        } else if (this.rch.isRemoteConnectRequired(this.node)) {
            String msg = Strings.get("creatingInstance", this.instance, this.node);
            this.logger.info(msg);
            int status = this.createInstanceRemote();
            if (status != 0) {
                return;
            }
        } else {
            String msg = Strings.get("create.instance.remote.failed", this.instance, this.nodeHost, humanVersionOfCommand);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
    }

    private String getHostFromNodeName(String nodeName) {
        Node theNode = this.nodes.getNode(nodeName);
        String hostName = null;
        if (theNode != null) {
            hostName = theNode.getNodeHost();
        }
        if (hostName == null && nodeName.equals("localhost")) {
            return "localhost";
        }
        return hostName;
    }

    private int createInstanceRemote() {
        ActionReport report = this.ctx.getActionReport();
        StringBuilder output = new StringBuilder();
        ParameterMap map = new ParameterMap();
        map.set((Object)"--node", (Object)this.node);
        map.set((Object)"DEFAULT", (Object)this.instance);
        String humanVersionOfCommand = "asadmin --host " + this.dasHost + " --port " + this.dasPort + " create-local-instance" + " --node " + this.node + " " + this.instance;
        int status = this.rch.runCommand(this.node, "_create-instance-filesystem", map, output);
        if (output.length() > 0) {
            this.logger.info(output.toString());
        }
        if (status != 0) {
            String msg = Strings.get("create.instance.remote.failed", this.instance, this.nodeHost, humanVersionOfCommand);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(output.toString() + NL + msg);
            return 1;
        }
        return 0;
    }
}

