/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.InstanceInfo;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cluster(value={RuntimeType.DAS})
@Service(name="list-instances")
@I18n(value="list.instances.command")
@Scoped(value=PerLookup.class)
public class ListInstancesCommand
implements AdminCommand {
    @Inject
    private Habitat habitat;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Servers allServers;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultValue="2000")
    private String timeoutmsec;
    @Param(optional=true, defaultValue="false")
    private boolean standaloneonly;
    @Param(optional=true, defaultValue="false")
    private boolean nostatus;
    @Param(optional=true, primary=true, defaultValue="domain")
    String whichTarget;
    private List<InstanceInfo> infos = new LinkedList<InstanceInfo>();
    private List<Server> serverList;
    private ActionReport report;
    private ActionReport.MessagePart top;
    private static final String EOL = "\n";

    public void execute(AdminCommandContext context) {
        int timeoutInMsec;
        try {
            timeoutInMsec = Integer.parseInt(this.timeoutmsec);
        }
        catch (Exception e) {
            timeoutInMsec = 2000;
        }
        this.report = context.getActionReport();
        this.top = this.report.getTopMessagePart();
        Logger logger = context.getLogger();
        if (!this.validateParams()) {
            return;
        }
        this.serverList = this.createServerList();
        if (this.serverList == null) {
            this.fail(Strings.get("list.instances.badTarget", this.whichTarget));
            return;
        }
        if (!this.env.isDas()) {
            String msg = Strings.get("list.instances.onlyRunsOnDas");
            logger.warning(msg);
            this.fail(msg);
            return;
        }
        if (this.nostatus) {
            this.noStatus(this.serverList);
        } else {
            this.yesStatus(this.serverList, timeoutInMsec, logger);
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void noStatus(List<Server> serverList) {
        if (serverList.size() < 1) {
            this.report.setMessage("Nothing to list.");
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean firstServer = true;
        for (Server server : serverList) {
            String name;
            boolean clustered;
            boolean bl = clustered = server.getCluster() != null;
            if (this.standaloneonly && clustered || !this.notDas(name = server.getName())) continue;
            if (firstServer) {
                firstServer = false;
            } else {
                sb.append(EOL);
            }
            sb.append(name);
            this.top.addProperty(name, "");
        }
    }

    private boolean notDas(String name) {
        return !"server".equals(name);
    }

    private void yesStatus(List<Server> serverList, int timeoutInMsec, Logger logger) {
        RemoteInstanceCommandHelper helper = new RemoteInstanceCommandHelper(this.habitat);
        for (Server server : serverList) {
            String clusterName;
            String name;
            boolean clustered;
            boolean bl = clustered = server.getCluster() != null;
            if (this.standaloneonly && clustered || (name = server.getName()) == null) continue;
            com.sun.enterprise.config.serverbeans.Cluster cluster = this.domain.getClusterForInstance(name);
            String string = clusterName = cluster != null ? cluster.getName() : null;
            if (!this.notDas(name)) continue;
            InstanceInfo ii = new InstanceInfo(name, helper.getAdminPort(server), helper.getHost(server), clusterName, logger, timeoutInMsec);
            this.infos.add(ii);
        }
        if (this.infos.size() < 1) {
            this.report.setMessage("Nothing to list.");
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (InstanceInfo ii : this.infos) {
            if (first) {
                first = false;
            } else {
                sb.append(EOL);
            }
            String name = ii.getName();
            String display = ii.isRunning() ? " running" : " not running";
            String value = ii.isRunning() ? "RUNNING" : "NOT_RUNNING";
            sb.append(name).append(display);
            this.top.addProperty(name, value);
        }
        if (this.verbose) {
            this.report.setMessage(InstanceInfo.format(this.infos));
        } else {
            this.report.setMessage(sb.toString());
        }
    }

    private List<Server> createServerList() {
        if (!StringUtils.ok((String)this.whichTarget)) {
            return this.allServers.getServer();
        }
        ReferenceContainer rc = this.domain.getReferenceContainerNamed(this.whichTarget);
        if (rc == null) {
            return this.getServersForNodeOrConfig();
        }
        if (rc.isServer()) {
            LinkedList<Server> l = new LinkedList<Server>();
            l.add((Server)rc);
            return l;
        }
        if (rc.isCluster()) {
            com.sun.enterprise.config.serverbeans.Cluster cluster = (com.sun.enterprise.config.serverbeans.Cluster)rc;
            return cluster.getInstances();
        }
        return null;
    }

    private List<Server> getServersForNodeOrConfig() {
        if (this.whichTarget == null) {
            throw new NullPointerException("impossible!");
        }
        List<Server> list = this.getServersForNode();
        if (list == null) {
            list = this.getServersForConfig();
        }
        return list;
    }

    private List<Server> getServersForNode() {
        List nodeList;
        boolean foundNode = false;
        Nodes nodes = this.domain.getNodes();
        if (nodes != null && (nodeList = nodes.getNode()) != null) {
            for (Node node : nodeList) {
                if (!this.whichTarget.equals(node.getName())) continue;
                foundNode = true;
                break;
            }
        }
        if (!foundNode) {
            return null;
        }
        return this.domain.getInstancesOnNode(this.whichTarget);
    }

    private List<Server> getServersForConfig() {
        Config config = this.domain.getConfigNamed(this.whichTarget);
        if (config == null) {
            return null;
        }
        List rcs = this.domain.getReferenceContainersOf(config);
        LinkedList<Server> servers = new LinkedList<Server>();
        for (ReferenceContainer rc : rcs) {
            if (!rc.isServer()) continue;
            servers.add((Server)rc);
        }
        return servers;
    }

    private boolean validateParams() {
        if ("domain".equals(this.whichTarget)) {
            this.whichTarget = null;
        }
        if (this.standaloneonly && StringUtils.ok((String)this.whichTarget)) {
            this.fail(Strings.get("list.instances.targetWithStandaloneOnly"));
            return false;
        }
        if (this.verbose && this.nostatus) {
            this.fail(Strings.get("list.instances.verboseAndNoStatus"));
            return false;
        }
        if (!this.notDas(this.whichTarget)) {
            this.fail(Strings.get("list.instances.serverTarget"));
            return false;
        }
        return true;
    }

    private void fail(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(s);
    }
}

