/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.universal.process.LocalAdminCommand;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="start-instance")
@Scoped(value=PerLookup.class)
@I18n(value="start.instance.command")
public class StartInstanceCommand
implements AdminCommand,
PostConstruct {
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    private Nodes nodes;
    @Inject
    private CommandRunner cr;
    @Inject
    private ServerEnvironment env;
    @Param(optional=true, defaultValue="true")
    private Boolean force;
    @Param(optional=true, primary=true)
    private String instanceName;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private AdminCommandContext ctx;
    private String noderef;
    private String nodedir;
    private Server instance;
    private static final String NL = System.getProperty("line.separator");

    public void execute(AdminCommandContext context) {
        this.logger = context.getLogger();
        this.ctx = context;
        if (!StringUtils.ok((String)this.instanceName)) {
            this.logger.severe(Strings.get("start.instance.noInstanceName"));
            return;
        }
        this.instance = this.helper.getServer(this.instanceName);
        if (this.instance == null) {
            this.logger.severe(Strings.get("start.instance.noSuchInstance", this.instanceName));
            return;
        }
        this.noderef = this.helper.getNode(this.instance);
        if (!StringUtils.ok((String)this.noderef)) {
            this.logger.severe(Strings.get("missingNodeRef", this.instanceName));
            return;
        }
        if (this.nodes != null) {
            Node n = this.nodes.getNode(this.noderef);
            if (n != null) {
                this.nodedir = n.getNodeDir();
            } else {
                this.logger.severe(Strings.get("missingNode", this.noderef));
                return;
            }
        }
        if (this.env.isDas()) {
            this.callInstance();
        } else if (this.env.isInstance()) {
            this.startInstance();
        } else {
            String msg = Strings.get("start.instance.notAnInstanceOrDas", this.env.getRuntimeType().toString());
            this.logger.warning(msg);
        }
    }

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    private void startInstance() {
        LocalAdminCommand lac = null;
        lac = this.nodedir == null ? new LocalAdminCommand("start-local-instance", new String[]{"--node", this.noderef, this.instanceName}) : new LocalAdminCommand("start-local-instance", new String[]{"--node", this.noderef, "--nodedir", this.nodedir, this.instanceName});
        try {
            int status = lac.execute();
        }
        catch (ProcessManagerException processManagerException) {
            // empty catch block
        }
    }

    private void callInstance() {
        int dasPort = this.helper.getAdminPort("server");
        String dasHost = System.getProperty("com.sun.aas.hostName");
        RemoteConnectHelper rch = new RemoteConnectHelper(this.habitat, this.nodeList, this.logger, dasHost, dasPort);
        if (rch.isLocalhost(this.nodes.getNode(this.noderef))) {
            this.startInstance();
        } else if (rch.isRemoteConnectRequired(this.noderef)) {
            StringBuilder output = new StringBuilder();
            ParameterMap map = new ParameterMap();
            map.set((Object)"DEFAULT", (Object)this.instanceName);
            map.set((Object)"node", (Object)this.noderef);
            if (this.nodedir != null) {
                map.set((Object)"nodedir", (Object)this.nodedir);
            }
            int status = rch.runCommand(this.noderef, "start-local-instance", map, output);
            if (output.length() > 0) {
                this.logger.info(output.toString());
            }
            if (status != 0) {
                ActionReport report = this.ctx.getActionReport();
                String msg = Strings.get("start.remote.instance.failed", this.instanceName);
                this.logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(output + NL + msg);
            }
        } else {
            ActionReport report = this.ctx.getActionReport();
            String msg = Strings.get("start.remote.instance.failed", this.instanceName);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
        }
    }
}

