/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee.loader;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.j2ee.J2EEDomainImpl;
import org.glassfish.admin.amx.impl.j2ee.MetadataImpl;
import org.glassfish.admin.amx.impl.j2ee.loader.AMXJ2EEStartupServiceMBean;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.j2ee.J2EEDomain;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
public final class AMXJ2EEStartupService
implements PostConstruct,
PreDestroy,
AMXJ2EEStartupServiceMBean {
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    InjectedValues mCore;
    @Inject
    private ApplicationRegistry mAppsRegistry;

    private static void debug(String s) {
        System.out.println(s);
    }

    public InjectedValues getCore() {
        return this.mCore;
    }

    public ApplicationRegistry getApplicationRegistry() {
        return this.mAppsRegistry;
    }

    public void postConstruct() {
        try {
            this.mMBeanServer.registerMBean(this, OBJECT_NAME);
        }
        catch (JMException e) {
            throw new Error(e);
        }
    }

    public void preDestroy() {
        this.unloadAMXMBeans();
    }

    private DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy();
    }

    public ObjectName getJ2EEDomain() {
        return this.getDomainRootProxy().child("J2EEDomain").extra().objectName();
    }

    private J2EEDomain getJ2EEDomainProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getProxy(this.getJ2EEDomain(), J2EEDomain.class);
    }

    public synchronized ObjectName loadAMXMBeans() {
        FeatureAvailability.getInstance().waitForFeature("AMXCoreReady", "" + this);
        FeatureAvailability.getInstance().waitForFeature("AMXConfigReady", "" + this);
        DomainRoot domainRootProxy = ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy(false);
        ObjectName domainRoot = domainRootProxy.objectName();
        ObjectNameBuilder objectNames = new ObjectNameBuilder(this.mMBeanServer, domainRoot);
        String domainName = Util.getNameProp(domainRoot);
        MetadataImpl metadata = new MetadataImpl();
        metadata.add("Config", domainRootProxy.child(Domain.class).objectName());
        J2EEDomainImpl impl = new J2EEDomainImpl(domainRoot, metadata);
        ObjectName objectName = objectNames.buildChildObjectName(J2EEDomain.class);
        try {
            objectName = this.mMBeanServer.registerMBean(impl, objectName).getObjectName();
        }
        catch (JMException e) {
            throw new Error(e);
        }
        ImplUtil.getLogger().info("J2EEDomain registered at " + objectName);
        return objectName;
    }

    public synchronized void unloadAMXMBeans() {
        J2EEDomain j2eeDomain = this.getJ2EEDomainProxy();
        if (j2eeDomain != null) {
            ImplUtil.unregisterAMXMBeans(j2eeDomain);
        }
    }
}

