/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ws;

import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.ws.WLUnSupportedNode;
import com.sun.enterprise.deployment.node.ws.WLWebServiceNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLWebServicesDescriptorNode
extends BundleNode
implements RootXMLNode {
    private static final XMLElement ROOT_ELEMENT = new XMLElement("weblogic-webservices");
    private static final String SCHEMA_ID = "weblogic-webservices.xsd";
    private static final String SPEC_VERSION = "1.0";
    private static final List<String> systemIDs = WLWebServicesDescriptorNode.initSystemIDs();
    private WebServicesDescriptor parentDescriptor;

    public WLWebServicesDescriptorNode(WebServicesDescriptor descriptor) {
        this.parentDescriptor = descriptor;
        this.registerElementHandler(new XMLElement("webservice-description"), WLWebServiceNode.class);
    }

    private static List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        return Collections.unmodifiableList(systemIDs);
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    protected String getSchemaURL() {
        return "http://www.oracle.com/technology/weblogic/weblogic-webservices/1.0/weblogic-webservices.xsd";
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return ROOT_ELEMENT;
    }

    @Override
    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        if (attributeName.getQName().equals("id")) {
            return true;
        }
        return "version".equals(attributeName.getQName()) && SPEC_VERSION.equals(value);
    }

    @Override
    public XMLNode getHandlerFor(XMLElement element) {
        String elementName = element.getQName();
        if ("webservice-security".equals(elementName)) {
            WLUnSupportedNode node = new WLUnSupportedNode(new XMLElement("webservice-security"));
            node.setParentNode(this);
            return node;
        }
        return super.getHandlerFor(element);
    }

    @Override
    public void addDescriptor(Object descriptor) {
        DOLUtils.getDefaultLogger().info("Warning: WLWebServiceDescriptorNode.addDescriptor() should not have been called by" + descriptor.toString());
    }

    @Override
    public WebServicesDescriptor getDescriptor() {
        return this.parentDescriptor;
    }

    @Override
    public Node writeDescriptor(Node parent, RootDeploymentDescriptor descriptor) {
        Element bundleNode;
        if (this.getDocType() == null) {
            bundleNode = WLWebServicesDescriptorNode.appendChildNS(parent, this.getXMLRootTag().getQName(), "http://xmlns.oracle.com/weblogic/weblogic-webservices");
            this.addBundleNodeAttributes(bundleNode, descriptor);
        } else {
            bundleNode = WLWebServicesDescriptorNode.appendChild(parent, this.getXMLRootTag().getQName());
        }
        this.writeDisplayableComponentInfo(bundleNode, descriptor);
        WLWebServiceNode wsNode = new WLWebServiceNode();
        for (WebService next : ((WebServicesDescriptor)descriptor).getWebServices()) {
            wsNode.writeDescriptor((Node)bundleNode, "webservice-description", next);
        }
        return bundleNode;
    }

    @Override
    protected void addBundleNodeAttributes(Element bundleNode, RootDeploymentDescriptor descriptor) {
        bundleNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/weblogic/weblogic-webservices");
        bundleNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:j2ee", "http://java.sun.com/xml/ns/j2ee");
        String schemaLocation = "http://xmlns.oracle.com/weblogic/weblogic-webservices " + this.getSchemaURL();
        schemaLocation = schemaLocation + " " + "http://java.sun.com/xml/ns/j2ee" + " " + "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
        bundleNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.addNamespaceDeclaration(bundleNode, descriptor);
        String clientSchemaLocation = descriptor.getSchemaLocation();
        if (clientSchemaLocation != null) {
            schemaLocation = schemaLocation + " " + clientSchemaLocation;
        }
        bundleNode.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", schemaLocation);
        bundleNode.setAttribute("version", this.getSpecVersion());
    }

    @Override
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

