/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-node-ssh")
@I18n(value="create.node.ssh")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class CreateNodeSshCommand
implements AdminCommand {
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodehost")
    private String nodehost;
    @Param(name="installdir", optional=true)
    private String installdir;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    @Param(name="sshport", optional=true)
    private String sshport;
    @Param(name="sshuser", optional=true)
    private String sshuser;
    @Param(name="sshkeyfile", optional=true)
    private String sshkeyfile;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    private static final String NL = System.getProperty("line.separator");
    private Logger logger = null;
    private TokenResolver resolver = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuilder msg = new StringBuilder();
        this.logger = context.getLogger();
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
        this.setDefaults();
        try {
            this.validate();
        }
        catch (CommandValidationException e) {
            String m1 = Strings.get("create.node.ssh.invalid.params");
            if (!this.force) {
                String m2 = Strings.get("create.node.ssh.not.created");
                msg.append(StringUtils.cat((String)NL, (String[])new String[]{m1, m2, e.getMessage()}));
                report.setMessage(msg.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            String m2 = Strings.get("create.node.ssh.continue.force");
            msg.append(StringUtils.cat((String)NL, (String[])new String[]{m1, e.getMessage(), m2}));
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_create-node", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"DEFAULT", (Object)this.name);
        map.add((Object)"installdir", (Object)this.installdir);
        map.add((Object)"nodehost", (Object)this.nodehost);
        map.add((Object)"nodedir", (Object)this.nodedir);
        map.add((Object)"sshport", (Object)this.sshport);
        map.add((Object)"sshuser", (Object)this.sshuser);
        map.add((Object)"sshkeyfile", (Object)this.sshkeyfile);
        ci.parameters(map);
        ci.execute();
        if (StringUtils.ok((String)report.getMessage())) {
            if (msg.length() > 0) {
                msg.append(NL);
            }
            msg.append(report.getMessage());
        }
        report.setMessage(msg.toString());
    }

    private void setDefaults() {
        if (this.sshport == null) {
            this.sshport = "22";
        }
        if (this.sshuser == null) {
            this.sshuser = "${user.name}";
        }
        if (this.installdir == null) {
            this.installdir = "${com.sun.aas.installRoot}";
        }
    }

    private void validate() throws CommandValidationException {
        if (StringUtils.ok((String)this.sshkeyfile)) {
            File kfile = new File(this.resolver.resolve(this.sshkeyfile));
            if (!kfile.isAbsolute()) {
                throw new CommandValidationException(Strings.get("key.path.not.absolute", kfile.getPath()));
            }
            if (!kfile.exists()) {
                throw new CommandValidationException(Strings.get("key.path.not.found", kfile.getPath()));
            }
            if (!kfile.canRead()) {
                throw new CommandValidationException(Strings.get("key.path.not.readable", kfile.getPath(), System.getProperty("user.name")));
            }
        }
        this.validateSSHConnection();
    }

    private void validateSSHConnection() throws CommandValidationException {
        SSHLauncher sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
        if (!NetUtils.isPortStringValid((String)this.resolver.resolve(this.sshport))) {
            throw new CommandValidationException(Strings.get("Invalid port number {0}", this.sshport));
        }
        int port = Integer.parseInt(this.resolver.resolve(this.sshport));
        try {
            sshL.validate(this.resolver.resolve(this.nodehost), port, this.resolver.resolve(this.sshuser), this.resolver.resolve(this.sshkeyfile), this.resolver.resolve(this.installdir), this.logger);
        }
        catch (IOException e) {
            String m1 = e.getMessage();
            String m2 = "";
            Throwable e2 = e.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            if (e instanceof FileNotFoundException) {
                this.logger.warning(StringUtils.cat((String)": ", (String[])new String[]{m1, m2, sshL.toString()}));
                throw new CommandValidationException(StringUtils.cat((String)NL, (String[])new String[]{m1, m2}));
            }
            String msg = Strings.get("ssh.bad.connect", this.nodehost);
            this.logger.warning(StringUtils.cat((String)": ", (String[])new String[]{msg, m1, m2, sshL.toString()}));
            throw new CommandValidationException(StringUtils.cat((String)NL, (String[])new String[]{msg, m1, m2}));
        }
    }
}

