/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.internal.api.PostStartup;
import org.glassfish.javaee.services.ConnectorDescriptorProxy;
import org.glassfish.javaee.services.ResourcesBinder;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="ResourceManager")
public class ResourceManager
implements PostStartup,
PostConstruct,
PreDestroy,
ConfigListener {
    private static final Logger logger = LogDomains.getLogger(ResourceManager.class, (String)"LogStrings");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceManager.class);
    @Inject
    private ResourcesBinder resourcesBinder;
    @Inject
    private Habitat connectorRuntimeHabitat;
    @Inject
    private Resources allResources;
    @Inject
    private Habitat deployerHabitat;
    @Inject
    private Habitat habitat;
    private ConnectorRuntime runtime;
    @Inject
    private GlassfishNamingManager namingMgr;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private Domain domain;
    @Inject
    private ResourceRef[] resourceRefs;

    public void postConstruct() {
        this.bindConnectorDescriptors();
        this.deployResources(this.allResources.getResources());
        this.addListenerToResourceRefs();
        this.addListenerToServer();
    }

    private void addListenerToServer() {
        Server server = this.domain.getServerNamed(this.environment.getInstanceName());
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)server);
        bean.addListener((ConfigListener)this);
    }

    private void bindConnectorDescriptors() {
        for (String rarName : ConnectorConstants.systemRarNames) {
            this.bindConnectorDescriptorProxies(rarName);
        }
    }

    private void bindConnectorDescriptorProxies(String rarName) {
        String jndiName = ConnectorsUtil.getReservePrefixedJNDINameForDescriptor((String)rarName);
        ConnectorDescriptorProxy proxy = (ConnectorDescriptorProxy)this.habitat.getComponent(ConnectorDescriptorProxy.class);
        proxy.setJndiName(jndiName);
        proxy.setRarName(rarName);
        try {
            this.namingMgr.publishObject(jndiName, (Object)proxy, true);
        }
        catch (NamingException e) {
            Object[] params = new Object[]{rarName, e};
            logger.log(Level.WARNING, "resources.resource-manager.connector-descriptor.bind.failure", params);
        }
    }

    public void deployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            if (resource instanceof BindableResource) {
                BindableResource bindableResource = (BindableResource)resource;
                if (!this.isBindableResourceEnabled(bindableResource.getJndiName())) continue;
                ResourceInfo resourceInfo = new ResourceInfo(bindableResource.getJndiName());
                this.resourcesBinder.deployResource(resourceInfo, resource);
                continue;
            }
            if (resource instanceof ResourcePool) continue;
            try {
                this.getResourceDeployer(resource).deployResource((Object)resource);
            }
            catch (Exception e) {
                Object[] params = new Object[]{ConnectorsUtil.getGenericResourceInfo((Resource)resource), e};
                logger.log(Level.WARNING, "resources.resource-manager.deploy-resource-failed", params);
            }
        }
        this.addListenerToResources(resources);
    }

    private boolean isBindableResourceEnabled(String jndiName) {
        boolean resourceEnabled = Boolean.valueOf(((BindableResource)this.allResources.getResourceByName(BindableResource.class, jndiName)).getEnabled());
        boolean refEnabled = this.domain.getServerNamed(this.environment.getInstanceName()).getResourceRef(jndiName) != null;
        return resourceEnabled && refEnabled;
    }

    public Resources getAllResources() {
        return this.allResources;
    }

    public void preDestroy() {
        if (this.isConnectorRuntimeInitialized()) {
            Collection resources = ConnectorsUtil.getAllSystemRAResourcesAndPools((Resources)this.allResources);
            this.undeployResources(resources);
            ConnectorRuntime cr = this.getConnectorRuntime();
            if (cr != null) {
                cr.cleanUpResourcesAndShutdownAllActiveRAs();
            }
        } else {
            logger.finest("ConnectorRuntime not initialized, hence skipping resource-adapters shutdown, resources, pools cleanup");
        }
        this.removeListenerForResources();
        this.removeListenerForResourceRefs();
        this.removeListenerForServer();
    }

    private void removeListenerForServer() {
        Server server = this.domain.getServerNamed(this.environment.getInstanceName());
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)server);
        bean.removeListener((ConfigListener)this);
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class, null);
        }
        return this.runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            try {
                this.getResourceDeployer(resource).undeployResource((Object)resource);
            }
            catch (Exception e) {
                Object[] params = new Object[]{ConnectorsUtil.getGenericResourceInfo((Resource)resource), e};
                logger.log(Level.WARNING, "resources.resource-manager.undeploy-resource-failed", params);
            }
            finally {
                this.removeListenerForResource(resource);
            }
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new PropertyChangeHandler(events), (Logger)logger);
    }

    public boolean isConnectorRuntimeInitialized() {
        Collection inhabitants = this.connectorRuntimeHabitat.getInhabitants(ConnectorRuntime.class);
        Iterator i$ = inhabitants.iterator();
        if (i$.hasNext()) {
            Inhabitant inhabitant = (Inhabitant)i$.next();
            return inhabitant.isInstantiated();
        }
        return true;
    }

    private void addListenerToResources(Collection<Resource> resources) {
        for (Resource configuredResource : resources) {
            this.addListenerToResource(configuredResource);
        }
    }

    private void addListenerToResourceRefs() {
        for (ResourceRef ref : this.resourceRefs) {
            this.addListenerToResource(ref);
        }
    }

    private void addListenerToResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.addListener((ConfigListener)this);
        } else if (instance instanceof ResourceRef) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.addListener((ConfigListener)this);
        }
    }

    private void removeListenerForResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.removeListener((ConfigListener)this);
        } else if (instance instanceof ResourceRef) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.removeListener((ConfigListener)this);
        }
    }

    private void removeListenerForResourceRefs() {
        for (ResourceRef ref : this.resourceRefs) {
            this.removeListenerForResource(ref);
        }
    }

    private void removeListenerForResources() {
        for (Resource configuredResource : this.allResources.getResources()) {
            this.removeListenerForResource(configuredResource);
        }
    }

    private ResourceDeployer getResourceDeployer(Object resource) {
        Collection deployers = this.deployerHabitat.getAllByContract(ResourceDeployer.class);
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            return deployer;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyChangeHandler
    implements Changed {
        PropertyChangeEvent[] events;

        private PropertyChangeHandler(PropertyChangeEvent[] events) {
            this.events = events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader ccl = ResourceManager.this.getConnectorRuntime().getConnectorClassLoader();
                Thread.currentThread().setContextClassLoader(ccl);
                switch (type) {
                    case ADD: {
                        logger.fine("A new " + changedType.getName() + " was added : " + changedInstance);
                        np = this.handleAddEvent(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                        np = this.handleChangeEvent(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                        np = this.handleRemoveEvent(changedInstance);
                        break;
                    }
                    default: {
                        np = new NotProcessed("Unrecognized type of change: " + type);
                    }
                }
                NotProcessed notProcessed = np;
                return notProcessed;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            NotProcessed np = null;
            try {
                if (ConnectorsUtil.isValidEventType(instance)) {
                    ResourceManager.this.getResourceDeployer(instance).redeployResource(instance);
                } else if (ConnectorsUtil.isValidEventType((Object)instance.getParent())) {
                    ResourceManager.this.getResourceDeployer(instance.getParent()).redeployResource((Object)instance.getParent());
                } else if (instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    ResourceDeployer deployer = null;
                    String refName = ref.getRef();
                    BindableResource bindableResource = null;
                    for (PropertyChangeEvent event : this.events) {
                        String propertyName = event.getPropertyName();
                        if (!"enabled".equalsIgnoreCase(propertyName)) continue;
                        boolean newValue = ConnectorsUtil.parseBoolean((String)event.getNewValue().toString());
                        boolean oldValue = ConnectorsUtil.parseBoolean((String)event.getOldValue().toString());
                        for (Resource resource : ResourceManager.this.allResources.getResources()) {
                            if (!(resource instanceof BindableResource)) continue;
                            bindableResource = (BindableResource)resource;
                            if (refName == null || !refName.equals(bindableResource.getJndiName())) continue;
                            deployer = ResourceManager.this.getResourceDeployer(bindableResource);
                            break;
                        }
                        if (deployer == null || newValue && oldValue) continue;
                        if (newValue) {
                            deployer.enableResource(bindableResource);
                            continue;
                        }
                        deployer.disableResource(bindableResource);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "resources.resource-manager.change-event-failed");
                np = new NotProcessed(localStrings.getLocalString("resources.resource-manager.change-event-failed", "Change event failed"));
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
            NotProcessed np = null;
            ResourceManager.this.addListenerToResource(instance);
            if (!(instance instanceof BindableResource) && !(instance instanceof ResourcePool)) {
                if (instance instanceof Resource) {
                    try {
                        ResourceManager.this.getResourceDeployer(instance).deployResource(instance);
                    }
                    catch (Exception e) {
                        Object[] params = new Object[]{ConnectorsUtil.getGenericResourceInfo((Resource)((Resource)instance)), e};
                        logger.log(Level.WARNING, "resources.resource-manager.deploy-resource-failed", params);
                    }
                } else if (!(instance instanceof Property) && instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    BindableResource resource = (BindableResource)ResourceManager.this.allResources.getResourceByName(BindableResource.class, ref.getRef());
                    ResourceInfo resourceInfo = new ResourceInfo(resource.getJndiName());
                    ResourceManager.this.resourcesBinder.deployResource(resourceInfo, (Resource)resource);
                }
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
            NotProcessed np = null;
            try {
                if (instance instanceof BindableResource) {
                    ResourceManager.this.removeListenerForResource(instance);
                } else if (instance instanceof Resource) {
                    ResourceManager.this.removeListenerForResource(instance);
                    ResourceManager.this.getResourceDeployer(instance).undeployResource(instance);
                } else if (ConnectorsUtil.isValidEventType((Object)instance.getParent())) {
                    ResourceManager.this.getResourceDeployer(instance).redeployResource((Object)instance.getParent());
                } else if (instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    BindableResource resource = (BindableResource)ResourceManager.this.allResources.getResourceByName(BindableResource.class, ref.getRef());
                    ResourceManager.this.getResourceDeployer(resource).undeployResource((Object)resource);
                    ResourceManager.this.removeListenerForResource(instance);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "resources.resource-manager.remove-event-failed");
                np = new NotProcessed(localStrings.getLocalString("resources.resource-manager.remove-event-failed", "Remove event failed"));
            }
            return np;
        }
    }
}

