/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.callback;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.jmac.config.CallbackHandlerConfig;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.enterprise.security.jmac.config.HandlerContext;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.security.ssl.SecuritySupportImpl;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.CertStoreCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.message.callback.PrivateKeyCallback;
import javax.security.auth.message.callback.SecretKeyCallback;
import javax.security.auth.message.callback.TrustStoreCallback;
import javax.security.auth.x500.X500Principal;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.MasterPassword;
import org.glassfish.security.common.PrincipalImpl;
import sun.security.util.DerValue;

abstract class BaseContainerCallbackHandler
implements CallbackHandler,
CallbackHandlerConfig {
    private static final String SUBJECT_KEY_IDENTIFIER_OID = "2.5.29.14";
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA-1";
    private static final String CLIENT_SECRET_KEYSTORE = "com.sun.appserv.client.secretKeyStore";
    private static final String CLIENT_SECRET_KEYSTORE_PASSWORD = "com.sun.appserv.client.secretKeyStorePassword";
    protected static final Logger _logger = LogDomains.getLogger(BaseContainerCallbackHandler.class, (String)"javax.enterprise.system.core.security");
    protected HandlerContext handlerContext = null;
    protected final SSLUtils sslUtils;
    protected final SecuritySupport secSup;
    protected final MasterPassword masterPasswordHelper;

    protected BaseContainerCallbackHandler() {
        if (Globals.getDefaultHabitat() == null) {
            this.sslUtils = new SSLUtils();
            this.secSup = new SecuritySupportImpl();
            this.masterPasswordHelper = null;
            this.sslUtils.postConstruct();
        } else {
            this.sslUtils = (SSLUtils)Globals.getDefaultHabitat().getComponent(SSLUtils.class);
            this.secSup = (SecuritySupport)Globals.getDefaultHabitat().getByContract(SecuritySupport.class);
            this.masterPasswordHelper = (MasterPassword)Globals.getDefaultHabitat().getComponent(MasterPassword.class, "Security SSL Password Provider Service");
        }
    }

    public void setHandlerContext(HandlerContext handlerContext) {
        this.handlerContext = handlerContext;
    }

    protected abstract boolean isSupportedCallback(Callback var1);

    protected abstract void handleSupportedCallbacks(Callback[] var1) throws IOException, UnsupportedCallbackException;

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            return;
        }
        for (Callback callback : callbacks) {
            if (this.isSupportedCallback(callback)) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JMAC: UnsupportedCallback : " + callback.getClass().getName());
            }
            throw new UnsupportedCallbackException(callback);
        }
        this.handleSupportedCallbacks(callbacks);
    }

    protected void processCallback(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof CallerPrincipalCallback) {
            this.processCallerPrincipal((CallerPrincipalCallback)callback);
        } else if (callback instanceof GroupPrincipalCallback) {
            this.processGroupPrincipal((GroupPrincipalCallback)callback);
        } else if (callback instanceof PasswordValidationCallback) {
            this.processPasswordValidation((PasswordValidationCallback)callback);
        } else if (callback instanceof PrivateKeyCallback) {
            this.processPrivateKey((PrivateKeyCallback)callback);
        } else if (callback instanceof TrustStoreCallback) {
            TrustStoreCallback tstoreCallback = (TrustStoreCallback)callback;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JMAC: In TrustStoreCallback Processor");
            }
            tstoreCallback.setTrustStore(this.sslUtils.getMergedTrustStore());
        } else if (callback instanceof CertStoreCallback) {
            this.processCertStore((CertStoreCallback)callback);
        } else if (callback instanceof SecretKeyCallback) {
            this.processSecretKey((SecretKeyCallback)callback);
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JMAC: UnsupportedCallback : " + callback.getClass().getName());
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void processCallerPrincipal(CallerPrincipalCallback cpCallback) {
        final Subject fs = cpCallback.getSubject();
        Principal principal = cpCallback.getPrincipal();
        String realmName = null;
        if (this.handlerContext != null) {
            realmName = this.handlerContext.getRealmName();
        }
        boolean isCertRealm = "certificate".equals(realmName);
        if (principal == null) {
            principal = cpCallback.getName() != null ? (isCertRealm ? new X500Principal(cpCallback.getName()) : new PrincipalImpl(cpCallback.getName())) : SecurityContext.getDefaultCallerPrincipal();
        }
        if (isCertRealm) {
            if (principal instanceof X500Principal) {
                LoginContextDriver.jmacLogin(fs, (X500Principal)principal);
            }
        } else if (!((Object)principal).equals(SecurityContext.getDefaultCallerPrincipal())) {
            LoginContextDriver.jmacLogin(fs, principal.getName(), realmName);
        }
        final Principal fprin = principal;
        final DistinguishedPrincipalCredential fdpc = new DistinguishedPrincipalCredential(principal);
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fs.getPrincipals().add(fprin);
                Iterator<Object> iter = fs.getPublicCredentials().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof DistinguishedPrincipalCredential)) continue;
                    iter.remove();
                }
                fs.getPublicCredentials().add(fdpc);
                return fs;
            }
        });
    }

    private void processGroupPrincipal(GroupPrincipalCallback gpCallback) {
        final Subject fs = gpCallback.getSubject();
        final String[] groups = gpCallback.getGroups();
        if (groups != null && groups.length > 0) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (String group : groups) {
                        fs.getPrincipals().add((Principal)new Group(group));
                    }
                    return fs;
                }
            });
        } else if (groups == null) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set<Principal> principalSet = fs.getPrincipals();
                    principalSet.removeAll(fs.getPrincipals(Group.class));
                    return fs;
                }
            });
        }
    }

    private void processPasswordValidation(PasswordValidationCallback pwdCallback) {
        if (SecurityServicesUtil.getInstance().isACC()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JMAC: In PasswordValidationCallback Processor for appclient - will do nothing");
            }
            pwdCallback.setResult(true);
            return;
        }
        String username = pwdCallback.getUsername();
        char[] passwd = pwdCallback.getPassword();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JMAC: In PasswordValidationCallback Processor");
        }
        try {
            String realmName = null;
            if (this.handlerContext != null) {
                realmName = this.handlerContext.getRealmName();
            }
            Subject s = LoginContextDriver.jmacLogin(pwdCallback.getSubject(), username, passwd, realmName);
            GFServerConfigProvider.setValidateRequestSubject(s);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JMAC: authentication succeeded for user = ", username);
            }
            passwd = null;
            pwdCallback.setResult(true);
        }
        catch (LoginException le) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "jmac.loginfail", username);
            }
            pwdCallback.setResult(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPrivateKey(PrivateKeyCallback privKeyCallback) {
        Certificate[] certs;
        PrivateKey privKey;
        block23: {
            KeyStore[] kstores = this.secSup.getKeyStores();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JMAC: In PrivateKeyCallback Processor");
            }
            if (kstores == null || kstores.length == 0) {
                privKeyCallback.setKey(null, null);
                return;
            }
            PrivateKeyCallback.Request req = privKeyCallback.getRequest();
            privKey = null;
            certs = null;
            if (req == null) {
                KeyStore.PrivateKeyEntry pke = this.getDefaultPrivateKeyEntry(kstores);
                if (pke != null) {
                    privKey = pke.getPrivateKey();
                    certs = pke.getCertificateChain();
                }
                privKeyCallback.setKey(privKey, certs);
                return;
            }
            try {
                if (req instanceof PrivateKeyCallback.AliasRequest) {
                    PrivateKeyCallback.AliasRequest aReq = (PrivateKeyCallback.AliasRequest)req;
                    String alias = aReq.getAlias();
                    KeyStore.PrivateKeyEntry privKeyEntry = alias == null ? this.getDefaultPrivateKeyEntry(kstores) : this.sslUtils.getPrivateKeyEntryFromTokenAlias(alias);
                    if (privKeyEntry != null) {
                        privKey = privKeyEntry.getPrivateKey();
                        certs = privKeyEntry.getCertificateChain();
                    }
                    break block23;
                }
                if (req instanceof PrivateKeyCallback.IssuerSerialNumRequest) {
                    PrivateKeyCallback.IssuerSerialNumRequest isReq = (PrivateKeyCallback.IssuerSerialNumRequest)req;
                    X500Principal issuer = isReq.getIssuer();
                    BigInteger serialNum = isReq.getSerialNum();
                    if (issuer != null && serialNum != null) {
                        boolean found = false;
                        for (int i = 0; i < kstores.length && !found; ++i) {
                            Enumeration<String> aliases = kstores[i].aliases();
                            while (aliases.hasMoreElements() && !found) {
                                Certificate[] certificates;
                                X509Certificate eeCert;
                                String nextAlias = aliases.nextElement();
                                PrivateKey key = this.secSup.getPrivateKeyForAlias(nextAlias, i);
                                if (key == null || !(eeCert = (X509Certificate)(certificates = kstores[i].getCertificateChain(nextAlias))[0]).getIssuerX500Principal().equals(issuer) || !eeCert.getSerialNumber().equals(serialNum)) continue;
                                privKey = key;
                                certs = certificates;
                                found = true;
                            }
                        }
                    }
                    break block23;
                }
                if (req instanceof PrivateKeyCallback.SubjectKeyIDRequest) {
                    PrivateKeyCallback.SubjectKeyIDRequest skReq = (PrivateKeyCallback.SubjectKeyIDRequest)req;
                    byte[] subjectKeyID = skReq.getSubjectKeyID();
                    if (subjectKeyID != null) {
                        boolean found = false;
                        DerValue derValue1 = new DerValue(4, subjectKeyID);
                        DerValue derValue2 = new DerValue(4, derValue1.toByteArray());
                        byte[] derSubjectKeyID = derValue2.toByteArray();
                        for (int i = 0; i < kstores.length && !found; ++i) {
                            Enumeration<String> aliases = kstores[i].aliases();
                            while (aliases.hasMoreElements() && !found) {
                                Certificate[] certificates;
                                X509Certificate eeCert;
                                byte[] derSubKeyID;
                                String nextAlias = aliases.nextElement();
                                PrivateKey key = this.secSup.getPrivateKeyForAlias(nextAlias, i);
                                if (key == null || (derSubKeyID = (eeCert = (X509Certificate)(certificates = kstores[i].getCertificateChain(nextAlias))[0]).getExtensionValue(SUBJECT_KEY_IDENTIFIER_OID)) == null || !Arrays.equals(derSubKeyID, derSubjectKeyID)) continue;
                                privKey = key;
                                certs = certificates;
                                found = true;
                            }
                        }
                    }
                    break block23;
                }
                if (req instanceof PrivateKeyCallback.DigestRequest) {
                    PrivateKeyCallback.DigestRequest dReq = (PrivateKeyCallback.DigestRequest)req;
                    byte[] digest = dReq.getDigest();
                    String algorithm = dReq.getAlgorithm();
                    KeyStore.PrivateKeyEntry privKeyEntry = null;
                    if (digest == null) {
                        privKeyEntry = this.getDefaultPrivateKeyEntry(kstores);
                    } else {
                        if (algorithm == null) {
                            algorithm = DEFAULT_DIGEST_ALGORITHM;
                        }
                        MessageDigest md = MessageDigest.getInstance(algorithm);
                        privKeyEntry = this.getPrivateKeyEntry(kstores, md, digest);
                    }
                    if (privKeyEntry != null) {
                        privKey = privKeyEntry.getPrivateKey();
                        certs = privKeyEntry.getCertificateChain();
                    }
                    break block23;
                }
                if (!_logger.isLoggable(Level.FINE)) break block23;
                _logger.log(Level.FINE, "invalid request type: " + req.getClass().getName());
            }
            catch (Exception e) {
                block24: {
                    try {
                        if (!_logger.isLoggable(Level.FINE)) break block24;
                        _logger.log(Level.FINE, "JMAC: In PrivateKeyCallback Processor:  Error reading key !", e);
                    }
                    catch (Throwable throwable) {
                        privKeyCallback.setKey(privKey, certs);
                        throw throwable;
                    }
                }
                privKeyCallback.setKey(privKey, certs);
            }
        }
        privKeyCallback.setKey(privKey, certs);
    }

    private KeyStore.PrivateKeyEntry getDefaultPrivateKeyEntry(KeyStore[] kstores) {
        Certificate[] certs;
        PrivateKey privKey;
        block4: {
            privKey = null;
            certs = null;
            try {
                for (int i = 0; i < kstores.length && privKey == null; ++i) {
                    Enumeration<String> aliases = kstores[i].aliases();
                    while (aliases.hasMoreElements() && privKey == null) {
                        String nextAlias = aliases.nextElement();
                        privKey = null;
                        certs = null;
                        PrivateKey key = this.secSup.getPrivateKeyForAlias(nextAlias, i);
                        if (key == null) continue;
                        privKey = key;
                        certs = kstores[i].getCertificateChain(nextAlias);
                    }
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINE)) break block4;
                _logger.log(Level.FINE, "Exception in getDefaultPrivateKeyEntry", e);
            }
        }
        return new KeyStore.PrivateKeyEntry(privKey, certs);
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(KeyStore[] kstores, MessageDigest md, byte[] digest) {
        Certificate[] certs;
        PrivateKey privKey;
        block4: {
            privKey = null;
            certs = null;
            try {
                for (int i = 0; i < kstores.length && privKey == null; ++i) {
                    Enumeration<String> aliases = kstores[i].aliases();
                    while (aliases.hasMoreElements() && privKey == null) {
                        String nextAlias = aliases.nextElement();
                        privKey = null;
                        certs = null;
                        PrivateKey key = this.secSup.getPrivateKeyForAlias(nextAlias, i);
                        if (key == null) continue;
                        certs = kstores[i].getCertificateChain(nextAlias);
                        md.reset();
                        byte[] cDigest = md.digest(certs[0].getEncoded());
                        if (!Arrays.equals(digest, cDigest)) continue;
                        privKey = key;
                    }
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINE)) break block4;
                _logger.log(Level.FINE, "Exception in getPrivateKeyEntry for Digest", e);
            }
        }
        return new KeyStore.PrivateKeyEntry(privKey, certs);
    }

    private void processCertStore(CertStoreCallback certStoreCallback) {
        block12: {
            KeyStore certStore;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JMAC: In CertStoreCallback Processor");
            }
            if ((certStore = this.sslUtils.getMergedTrustStore()) == null) {
                certStoreCallback.setCertStore(null);
            }
            ArrayList<Certificate> list = new ArrayList<Certificate>();
            try {
                if (certStore != null) {
                    Enumeration<String> enu = certStore.aliases();
                    while (enu.hasMoreElements()) {
                        String alias = enu.nextElement();
                        if (!certStore.isCertificateEntry(alias)) continue;
                        try {
                            Certificate cert = certStore.getCertificate(alias);
                            list.add(cert);
                        }
                        catch (KeyStoreException kse) {
                            if (!_logger.isLoggable(Level.FINE)) continue;
                            _logger.log(Level.FINE, "JMAC: Cannot retrievecertificate for alias " + alias);
                        }
                    }
                }
                CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
                CertStore certstore = CertStore.getInstance("Collection", ccsp);
                certStoreCallback.setCertStore(certstore);
            }
            catch (KeyStoreException kse) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "JMAC:  Cannot determine truststore aliases", kse);
                }
            }
            catch (InvalidAlgorithmParameterException iape) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "JMAC:  Cannot instantiate CertStore", iape);
                }
            }
            catch (NoSuchAlgorithmException nsape) {
                if (!_logger.isLoggable(Level.FINE)) break block12;
                _logger.log(Level.FINE, "JMAC:  Cannot instantiate CertStore", nsape);
            }
        }
    }

    private void processSecretKey(SecretKeyCallback secretKeyCallback) {
        String alias;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JMAC: In SecretKeyCallback Processor");
        }
        if ((alias = ((SecretKeyCallback.AliasRequest)secretKeyCallback.getRequest()).getAlias()) != null) {
            try {
                PasswordAdapter passwordAdapter = null;
                passwordAdapter = SecurityServicesUtil.getInstance().isACC() ? new PasswordAdapter(System.getProperty(CLIENT_SECRET_KEYSTORE), System.getProperty(CLIENT_SECRET_KEYSTORE_PASSWORD).toCharArray()) : this.masterPasswordHelper.getMasterPasswordAdapter();
                secretKeyCallback.setKey(passwordAdapter.getPasswordSecretKeyForAlias(alias));
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "JMAC: In SecretKeyCallback Processor:  Error reading key ! for alias " + alias, e);
                }
                secretKeyCallback.setKey(null);
            }
        } else {
            secretKeyCallback.setKey(null);
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "jmac.unsupportreadprinciple");
            }
        }
    }
}

