/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.cli.DeleteJaccProvider;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-jacc-providers")
@Scoped(value=PerLookup.class)
@I18n(value="list.jacc.provider")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class ListJaccProviders
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJaccProvider.class);
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        Cluster cluster;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (targetServer != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        SecurityService securityService = this.config.getSecurityService();
        List jaccProviders = securityService.getJaccProvider();
        Object jprov = null;
        for (JaccProvider jaccProv : jaccProviders) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(jaccProv.getName());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

